/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.WeatherConstraints;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.BatchOTXMLUnitMapper;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.P2GXMLActionPerformer;
import alma.obsprep.ot.scripting.bindings.Angle;
import alma.obsprep.ot.scripting.bindings.Coordinates;
import alma.obsprep.ot.scripting.bindings.CoordinatesType;
import alma.obsprep.ot.scripting.bindings.EditSBAction;
import alma.obsprep.ot.scripting.bindings.Frequency;
import alma.obsprep.ot.scripting.bindings.IntentType;
import alma.obsprep.ot.scripting.bindings.Length;
import alma.obsprep.ot.scripting.bindings.ReceiverbandType;
import alma.obsprep.ot.scripting.bindings.SBUpdateParameters;
import alma.obsprep.ot.scripting.bindings.Speed;
import alma.obsprep.ot.scripting.bindings.TargetChange;
import alma.obsprep.ot.scripting.bindings.Time;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public class EditSBPerformer
extends P2GXMLActionPerformer
implements P2GActionInterface {
    private final List<EditSBAction> editSBActions;

    EditSBPerformer(@NonNull BatchOT batchOT, @NonNull List<EditSBAction> list, boolean bl) throws P2GXMLActionPerformer.InputParameterValidationException {
        super(bl, batchOT);
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("editSBActions is marked non-null but is null");
        }
        actionName = "<EditSB>";
        this.editSBActions = list;
        this.validateRequestedActions();
    }

    @Override
    public void validateRequestedActions() throws P2GXMLActionPerformer.InputParameterValidationException {
        for (EditSBAction editSBAction : this.editSBActions) {
            if (!EditSBPerformer.verifyUID(editSBAction.getProjectuid())) {
                throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, actionName + ": The UID " + editSBAction.getProjectuid() + " is not specified correctly");
            }
            for (SBUpdateParameters sBUpdateParameters : editSBAction.getSb()) {
                if (StringUtils.isNotEmpty((String)sBUpdateParameters.getUid()) && StringUtils.isNotEmpty((String)sBUpdateParameters.getSbname())) {
                    throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, "The SB's name (" + sBUpdateParameters.getSbname() + ") and UID has been specified - only one of which can be specified");
                }
                for (JAXBElement<?> jAXBElement : sBUpdateParameters.getDescriptionOrMinhaOrMaxha()) {
                    Object object;
                    Object object2;
                    String string = jAXBElement.getName().getLocalPart();
                    if (string.equals("representativecoordinates") && (object2 = jAXBElement.getValue()) instanceof CoordinatesType) {
                        object = (CoordinatesType)object2;
                        try {
                            this.validateSBCoordinateChangeParameters((CoordinatesType)object, sBUpdateParameters.getUid() + sBUpdateParameters.getSbname());
                        }
                        catch (P2GXMLActionPerformer.InvalidCoordinateException invalidCoordinateException) {
                            throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, invalidCoordinateException);
                        }
                    }
                    if (!string.equals("representativefrequency") || !((object2 = jAXBElement.getValue()) instanceof Frequency)) continue;
                    object = (Frequency)object2;
                    try {
                        this.validateValidFrequency((Frequency)object, sBUpdateParameters.getUid() + sBUpdateParameters.getSbname());
                    }
                    catch (P2GXMLActionPerformer.InvalidFrequencyException invalidFrequencyException) {
                        throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, invalidFrequencyException.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void startAction() throws P2GActionInterface.UnableToCompleteActionException {
        for (EditSBAction editSBAction : this.editSBActions) {
            this.consoleOutput("Updating SB parameters in the project " + editSBAction.getProjectuid());
            P2GXMLActionPerformer.ProjectTopLevelEntities projectTopLevelEntities = this.fetchProjectFromArchive(editSBAction.getProjectuid());
            for (SBUpdateParameters sBUpdateParameters : editSBAction.getSb()) {
                ScienceGoal[] scienceGoalArray = projectTopLevelEntities.getObsProgram().getAbstractScienceGoalScienceGoal();
                boolean bl = StringUtils.isNotEmpty((String)sBUpdateParameters.getSciencegoals());
                boolean bl2 = StringUtils.isNotEmpty((String)sBUpdateParameters.getUid());
                boolean bl3 = StringUtils.isNotEmpty((String)sBUpdateParameters.getSbname());
                if (bl) {
                    scienceGoalArray = this.getRequestedScienceGoals(sBUpdateParameters.getSciencegoals(), scienceGoalArray);
                }
                if (!(bl3 ^ bl2 ^ bl)) {
                    this.consoleOutput("Only one of sbuid, sbname or sciencegoals can be specified");
                    throw new P2GActionInterface.UnableToCompleteActionException("Only one of uid, sbname or sciencegoals can be specified");
                }
                ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
                if (bl2) {
                    arrayList.addAll(this.getSBsToEditedByUID(editSBAction.getProjectuid(), scienceGoalArray, sBUpdateParameters.getUid()));
                } else if (bl3) {
                    arrayList.addAll(this.getSBsToBeEditedUsingSBName(editSBAction.getProjectuid(), scienceGoalArray, sBUpdateParameters.getSbname()));
                } else if (bl) {
                    arrayList.addAll(this.getSBsInScienceGoals(scienceGoalArray));
                }
                if (arrayList.isEmpty()) {
                    throw new P2GActionInterface.UnableToCompleteActionException("No SBs can be found to edit for the project " + editSBAction.getProjectuid());
                }
                this.updateSBDescription(sBUpdateParameters, arrayList);
                this.updateSBHourAngle(sBUpdateParameters, arrayList);
                this.updateSBTargets(sBUpdateParameters, arrayList);
                this.updateSBPhaseStability(sBUpdateParameters, arrayList);
                this.updateSBMaxPWVC(sBUpdateParameters, arrayList);
                this.updateSBAngularResolution(sBUpdateParameters, arrayList);
                this.updateSeeing(sBUpdateParameters, arrayList);
                this.updateMaxWindVelocity(sBUpdateParameters, arrayList);
                this.updateRepresentativeReceiverBand(sBUpdateParameters, arrayList);
                this.updateRepresentativeFrequency(sBUpdateParameters, arrayList);
                this.updateRepresentativeCoordinates(sBUpdateParameters, arrayList);
            }
            try {
                this.storeProject(projectTopLevelEntities.getObsProject(), "SBs in project " + editSBAction.getProjectuid() + " updated in archive");
            }
            catch (Exception exception) {
                this.consoleOutput("Unable to store project " + editSBAction.getProjectuid() + " : " + exception.getMessage());
                throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
            }
        }
    }

    private void updateRepresentativeCoordinates(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull ArrayList<SchedBlock> arrayList) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (arrayList == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list) {
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("representativecoordinates") || !((object = jAXBElement.getValue()) instanceof Coordinates)) continue;
            Coordinates coordinates = (Coordinates)object;
            object = this.getAPDMCoordinates(coordinates.getCoordinates());
            for (SchedBlock schedBlock : arrayList) {
                SkyCoordinates skyCoordinates = schedBlock.getSchedulingConstraints().getRepresentativeCoordinates();
                ((P2GXMLActionPerformer.CoordinatesRecord)object).ra().ifPresent(d -> skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Longitude.UNIT_DEG)));
                ((P2GXMLActionPerformer.CoordinatesRecord)object).dec().ifPresent(d -> skyCoordinates.setLatitude(Latitude.createLatitude((double)d, (String)Latitude.UNIT_DEG)));
                this.consoleOutput("Updating representative coordinates of " + schedBlock.getName() + " to " + skyCoordinates);
            }
        }
    }

    private void updateRepresentativeFrequency(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Iterator<SchedBlock> iterator;
            if (!jAXBElement.getName().getLocalPart().equals("representativefrequency") || !((iterator = jAXBElement.getValue()) instanceof Frequency)) continue;
            Frequency frequency = (Frequency)((Object)iterator);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                alma.valuetypes.Frequency frequency2;
                SchedBlock schedBlock = iterator.next();
                try {
                    frequency2 = BatchOTXMLUnitMapper.mapFrequency(frequency);
                }
                catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                    throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException.getMessage());
                }
                schedBlock.getSchedulingConstraints().setRepresentativeFrequency(frequency2);
                this.consoleOutput("Updating representative frequency of " + schedBlock.getName() + " to " + frequency2);
            }
        }
    }

    private void updateRepresentativeReceiverBand(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull ArrayList<SchedBlock> arrayList) {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (arrayList == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list) {
            Iterator<SchedBlock> iterator;
            if (!jAXBElement.getName().getLocalPart().equals("representativereceiverband") || !((iterator = jAXBElement.getValue()) instanceof ReceiverbandType)) continue;
            ReceiverbandType receiverbandType = (ReceiverbandType)((Object)iterator);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SchedBlock schedBlock = iterator.next();
                String string = BatchOTXMLUnitMapper.mapRxb(receiverbandType);
                schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand(string);
                this.consoleOutput("Updating representative receiver band  in " + schedBlock.getName() + " to " + string);
            }
        }
    }

    private Collection<? extends SchedBlock> getSBsInScienceGoals(ScienceGoal[] scienceGoalArray) {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        for (ScienceGoal scienceGoal : scienceGoalArray) {
            arrayList.addAll(SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal)));
        }
        return arrayList;
    }

    private ScienceGoal[] getRequestedScienceGoals(@NonNull String string, @NonNull ScienceGoal[] scienceGoalArray) throws P2GActionInterface.UnableToCompleteActionException {
        if (string == null) {
            throw new NullPointerException("scienceGoals is marked non-null but is null");
        }
        if (scienceGoalArray == null) {
            throw new NullPointerException("scienceGoalsInObsProgram is marked non-null but is null");
        }
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
        for (String string2 : StringUtils.split((String)string, (String)",")) {
            boolean bl = false;
            for (ScienceGoal scienceGoal : scienceGoalArray) {
                if (!scienceGoal.getName().trim().equals(string2.trim())) continue;
                arrayList.add(scienceGoal);
                bl = true;
                break;
            }
            if (bl) continue;
            this.consoleOutput("Unable to find the science goal " + string2 + " in the project");
            throw new P2GActionInterface.UnableToCompleteActionException(actionName + " Unable to find the science goal " + string2 + " in the project");
        }
        return (ScienceGoal[])arrayList.stream().toArray(ScienceGoal[]::new);
    }

    private void updateMaxWindVelocity(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("maxwindvelocity") || !((object = jAXBElement.getValue()) instanceof Speed)) continue;
            Speed speed = (Speed)object;
            try {
                object = BatchOTXMLUnitMapper.mapSpeed(speed);
                list.stream().forEach(arg_0 -> this.lambda$updateMaxWindVelocity$3((alma.valuetypes.Speed)((Object)object), arg_0));
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
        }
    }

    private void updateSeeing(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("seeing") || !((object = jAXBElement.getValue()) instanceof Angle)) continue;
            Angle angle = (Angle)object;
            try {
                object = BatchOTXMLUnitMapper.mapAngle(angle);
                if (object.isLessThan((AbstractDoubleWithUnit)alma.valuetypes.Angle.createAngleDegs(0.0))) {
                    this.consoleOutput("The seeing angle is less than zero");
                    throw new P2GActionInterface.UnableToCompleteActionException("The seeing angle is less than zero");
                }
                list.stream().forEach(arg_0 -> this.lambda$updateSeeing$4((alma.valuetypes.Angle)((Object)object), arg_0));
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
        }
    }

    private void updateSBAngularResolution(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Angle angle;
            Object object;
            if (jAXBElement.getName().getLocalPart().equals("maxar") && (object = jAXBElement.getValue()) instanceof Angle) {
                angle = (Angle)object;
                try {
                    object = BatchOTXMLUnitMapper.mapAngle(angle);
                }
                catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                    throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
                }
                list.stream().forEach(arg_0 -> this.lambda$updateSBAngularResolution$5((alma.valuetypes.Angle)((Object)object), arg_0));
            }
            if (!jAXBElement.getName().getLocalPart().equals("minar") || !((object = jAXBElement.getValue()) instanceof Angle)) continue;
            angle = (Angle)object;
            try {
                object = BatchOTXMLUnitMapper.mapAngle(angle);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
            list.stream().forEach(arg_0 -> this.lambda$updateSBAngularResolution$6((alma.valuetypes.Angle)((Object)object), arg_0));
        }
    }

    private void updateSBMaxPWVC(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("maxpwvc") || !((object = jAXBElement.getValue()) instanceof Length)) continue;
            Length length = (Length)object;
            try {
                object = BatchOTXMLUnitMapper.mapLength(length);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
            list.stream().forEach(arg_0 -> this.lambda$updateSBMaxPWVC$7((alma.valuetypes.Length)((Object)object), arg_0));
        }
    }

    private void updateSBPhaseStability(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("phasestability") || !((object = jAXBElement.getValue()) instanceof Angle)) continue;
            Angle angle = (Angle)object;
            try {
                object = BatchOTXMLUnitMapper.mapAngle(angle);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
            list.stream().forEach(arg_0 -> this.lambda$updateSBPhaseStability$8((alma.valuetypes.Angle)((Object)object), arg_0));
        }
    }

    private void updateSBTargets(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        for (JAXBElement<?> jAXBElement : sBUpdateParameters.getDescriptionOrMinhaOrMaxha()) {
            ObsType obsType;
            List<Target> list2 = jAXBElement.getValue();
            if (!(list2 instanceof TargetChange)) continue;
            TargetChange targetChange = (TargetChange)((Object)list2);
            try {
                IntentType intentType = targetChange.getIntent();
                list2 = BatchOTXMLUnitMapper.fetchSBTargets(intentType, list);
                obsType = BatchOTXMLUnitMapper.mapIntentToAPDMCalType(intentType);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
            if (list2.isEmpty()) {
                this.consoleOutput("Cannot find any targets which match the intent " + obsType + " for this action");
            }
            for (Target target : list2) {
                CalibratorParameters calibratorParameters = target.getObservingParameters(obsType);
                block14: for (JAXBElement<?> jAXBElement2 : targetChange.getIntegrationtimeOrCycletimeOrSearchradius()) {
                    String string = jAXBElement2.getName().getLocalPart();
                    Object object = jAXBElement2.getValue();
                    switch (string) {
                        case "integrationtime": {
                            this.setIntegrationTime(calibratorParameters, object);
                            continue block14;
                        }
                        case "cycletime": {
                            this.setCycleTime(calibratorParameters, object);
                            continue block14;
                        }
                        case "searchradius": {
                            this.setSearchRadius(target, object);
                            continue block14;
                        }
                    }
                    throw new P2GActionInterface.UnableToCompleteActionException("Unknown intent field " + string);
                }
            }
        }
    }

    private void setSearchRadius(@NonNull Target target, @NonNull Object object) throws P2GActionInterface.UnableToCompleteActionException {
        if (target == null) {
            throw new NullPointerException("targetForIntent is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("searchRadius is marked non-null but is null");
        }
        if (!target.getFieldSource().getIsQuery()) {
            throw new P2GActionInterface.UnableToCompleteActionException("Only query sources can have their search radius changed");
        }
        if (object instanceof Angle) {
            Angle angle = (Angle)object;
            QuerySource querySource = target.getFieldSource().getQuerySource();
            try {
                alma.valuetypes.Angle angle2 = BatchOTXMLUnitMapper.mapAngle(angle);
                if (angle2.isLessThan((AbstractDoubleWithUnit)alma.valuetypes.Angle.createAngleDegs(0.0))) {
                    this.consoleOutput("Only query sources can have their search radius changed");
                }
                this.consoleOutput("Setting search radius to " + angle2 + " for intent " + target.getFieldSource().getSourceName());
                querySource.setSearchRadius(angle2);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
        } else {
            throw new P2GActionInterface.UnableToCompleteActionException("Expected value to be of type Angle");
        }
    }

    private void setCycleTime(CalibratorParameters calibratorParameters, Object object) throws P2GActionInterface.UnableToCompleteActionException {
        if (object instanceof Time) {
            Time time = (Time)object;
            try {
                alma.valuetypes.Time time2 = BatchOTXMLUnitMapper.mapTime(time);
                calibratorParameters.setCycleTime(time2);
                this.consoleOutput("Setting cycle time to " + time2.getMins() + " for " + calibratorParameters.getName());
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
        } else {
            throw new P2GActionInterface.UnableToCompleteActionException("Expected value to be of type Time");
        }
    }

    private void setIntegrationTime(@NonNull CalibratorParameters calibratorParameters, @NonNull Object object) throws P2GActionInterface.UnableToCompleteActionException {
        if (calibratorParameters == null) {
            throw new NullPointerException("calObsParameters is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            try {
                alma.valuetypes.Time time2 = BatchOTXMLUnitMapper.mapTime(time);
                calibratorParameters.setDefaultIntegrationTime(time2);
                this.consoleOutput("Setting integration time to " + time2.getMins() + " for " + calibratorParameters.getName());
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
        } else {
            throw new P2GActionInterface.UnableToCompleteActionException("Expected value to be of type Time");
        }
    }

    private void updateSBHourAngle(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) throws P2GActionInterface.UnableToCompleteActionException {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            Object object = jAXBElement.getValue();
            if (!(object instanceof Angle)) continue;
            Angle angle = (Angle)object;
            try {
                object = BatchOTXMLUnitMapper.mapUserAngle(angle);
            }
            catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
            }
            String string = jAXBElement.getName().getLocalPart();
            list.stream().forEach(arg_0 -> this.lambda$updateSBHourAngle$9(string, (UserAngle)object, arg_0));
        }
    }

    private void updateSBDescription(@NonNull SBUpdateParameters sBUpdateParameters, @NonNull List<SchedBlock> list) {
        if (sBUpdateParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        List<JAXBElement<?>> list2 = sBUpdateParameters.getDescriptionOrMinhaOrMaxha();
        for (JAXBElement<?> jAXBElement : list2) {
            String string;
            Object object;
            if (!jAXBElement.getName().getLocalPart().equals("description") || !((object = jAXBElement.getValue()) instanceof String) || !StringUtils.isNotEmpty((String)(string = (String)object))) continue;
            list.stream().forEach(schedBlock -> {
                this.consoleOutput("Updating SB description for " + schedBlock.getName() + " to " + string);
                schedBlock.setNote(string.trim());
            });
        }
    }

    private /* synthetic */ void lambda$updateSBHourAngle$9(String string, UserAngle userAngle, SchedBlock schedBlock) {
        Preconditions preconditions = schedBlock.getPreconditions();
        if (string.equals("minha")) {
            this.consoleOutput("Updating minHA in " + schedBlock.getName());
            preconditions.setMinAllowedHA(userAngle.deepCopy());
        } else if (string.equals("maxha")) {
            this.consoleOutput("Updating maxHA in " + schedBlock.getName());
            preconditions.setMaxAllowedHA(userAngle.deepCopy());
        }
    }

    private /* synthetic */ void lambda$updateSBPhaseStability$8(alma.valuetypes.Angle angle, SchedBlock schedBlock) {
        WeatherConstraints weatherConstraints = schedBlock.getPreconditions().getWeatherConstraints();
        this.consoleOutput("Updating phase stability in " + schedBlock.getName() + " to " + angle);
        weatherConstraints.setPhaseStability(angle.deepCopy());
    }

    private /* synthetic */ void lambda$updateSBMaxPWVC$7(alma.valuetypes.Length length, SchedBlock schedBlock) {
        WeatherConstraints weatherConstraints = schedBlock.getPreconditions().getWeatherConstraints();
        this.consoleOutput("Updating PWVC in " + schedBlock.getName() + " to " + length);
        weatherConstraints.setMaxPWVC(length.deepCopy());
    }

    private /* synthetic */ void lambda$updateSBAngularResolution$6(alma.valuetypes.Angle angle, SchedBlock schedBlock) {
        schedBlock.getSchedulingConstraints().setMinAcceptableAngResolution(angle);
        this.consoleOutput("Updating minAR in " + schedBlock.getName());
    }

    private /* synthetic */ void lambda$updateSBAngularResolution$5(alma.valuetypes.Angle angle, SchedBlock schedBlock) {
        schedBlock.getSchedulingConstraints().setMaxAcceptableAngResolution(angle);
        this.consoleOutput("Updating maxAR in " + schedBlock.getName());
    }

    private /* synthetic */ void lambda$updateSeeing$4(alma.valuetypes.Angle angle, SchedBlock schedBlock) {
        WeatherConstraints weatherConstraints = schedBlock.getPreconditions().getWeatherConstraints();
        this.consoleOutput("Updating seeing in " + schedBlock.getName() + " to " + angle);
        weatherConstraints.setSeeing(angle.deepCopy());
    }

    private /* synthetic */ void lambda$updateMaxWindVelocity$3(alma.valuetypes.Speed speed, SchedBlock schedBlock) {
        WeatherConstraints weatherConstraints = schedBlock.getPreconditions().getWeatherConstraints();
        this.consoleOutput("Updating max wind velocity in " + schedBlock.getName() + " to " + speed);
        weatherConstraints.setMaxWindVelocity(speed.deepCopy());
    }
}

