/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.BatchOTXMLUnitMapper;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.P2GXMLActionPerformer;
import alma.obsprep.ot.scripting.bindings.CoordinatesType;
import alma.obsprep.ot.scripting.bindings.EditSBSourceAction;
import alma.obsprep.ot.scripting.bindings.SBEditParameters;
import alma.obsprep.ot.scripting.bindings.VelocityType;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public class EditSBSourcePerformer
extends P2GXMLActionPerformer
implements P2GActionInterface {
    private final List<EditSBSourceAction> editSBActions;

    EditSBSourcePerformer(@NonNull BatchOT batchOT, @NonNull List<EditSBSourceAction> list, boolean bl) throws P2GXMLActionPerformer.InputParameterValidationException {
        super(bl, batchOT);
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("editSBActions is marked non-null but is null");
        }
        actionName = "<EditSBSource>";
        this.editSBActions = list;
        this.validateRequestedActions();
    }

    @Override
    public void validateRequestedActions() throws P2GXMLActionPerformer.InputParameterValidationException {
        for (EditSBSourceAction editSBSourceAction : this.editSBActions) {
            if (!EditSBSourcePerformer.verifyUID(editSBSourceAction.getProjectuid())) {
                throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, "EditSBAction: The UID " + editSBSourceAction.getProjectuid() + " is not specified correctly");
            }
            for (SBEditParameters sBEditParameters : editSBSourceAction.getSb()) {
                if (sBEditParameters.isUpdateallsources() && StringUtils.isNotEmpty((String)sBEditParameters.getSourcename())) {
                    throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, "All sources have been flagged to be updated but a source name (" + sBEditParameters.getSourcename() + ") has been specified too - define only one option");
                }
                if (!sBEditParameters.isUpdateallsources() && StringUtils.isEmpty((String)sBEditParameters.getSourcename())) {
                    throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, "A source name should be specified when updating SB parameters");
                }
                if (!StringUtils.isNotEmpty((String)sBEditParameters.getUid()) || !StringUtils.isNotEmpty((String)sBEditParameters.getSbname())) continue;
                throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, "The SB's name (" + sBEditParameters.getSbname() + ") and UID has been specified - only one of which can be specified");
            }
            for (SBEditParameters sBEditParameters : editSBSourceAction.getSb()) {
                try {
                    this.validateSBCoordinateChangeParameters(sBEditParameters.getCoordinates(), sBEditParameters.getUid());
                }
                catch (P2GXMLActionPerformer.InvalidCoordinateException invalidCoordinateException) {
                    throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, invalidCoordinateException.getMessage());
                }
                try {
                    this.validateSBVelocityChangeParameters(sBEditParameters);
                }
                catch (InvalidVelocityException invalidVelocityException) {
                    throw new P2GXMLActionPerformer.InputParameterValidationException((P2GXMLActionPerformer)this, invalidVelocityException.getMessage());
                }
            }
        }
    }

    private void validateSBVelocityChangeParameters(@NonNull SBEditParameters sBEditParameters) throws InvalidVelocityException {
        if (sBEditParameters == null) {
            throw new NullPointerException("actionParameters is marked non-null but is null");
        }
        VelocityType velocityType = sBEditParameters.getVelocity();
        if (velocityType == null) {
            return;
        }
        if (velocityType.getVelocity() != null && velocityType.getZ() != null) {
            throw new InvalidVelocityException("Either Z (" + velocityType.getZ() + ") or a velocity (" + velocityType.getVelocity() + " ) may be specified but not both");
        }
        if (velocityType.getVelocity() != null && velocityType.getUnit() == null) {
            throw new InvalidVelocityException("No velocity unit has been specified for velocity " + velocityType.getVelocity());
        }
    }

    @Override
    public void startAction() throws P2GActionInterface.UnableToCompleteActionException {
        for (EditSBSourceAction editSBSourceAction : this.editSBActions) {
            this.consoleOutput("Updating SBs in the project " + editSBSourceAction.getProjectuid());
            P2GXMLActionPerformer.ProjectTopLevelEntities projectTopLevelEntities = this.fetchProjectFromArchive(editSBSourceAction.getProjectuid());
            ScienceGoal[] scienceGoalArray = projectTopLevelEntities.getObsProgram().getAbstractScienceGoalScienceGoal();
            for (SBEditParameters sBEditParameters : editSBSourceAction.getSb()) {
                ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
                if (StringUtils.isNotEmpty((String)sBEditParameters.getUid())) {
                    arrayList.addAll(this.getSBsToEditedByUID(editSBSourceAction.getProjectuid(), scienceGoalArray, sBEditParameters.getUid()));
                } else if (StringUtils.isNotEmpty((String)sBEditParameters.getSbname())) {
                    arrayList.addAll(this.getSBsToBeEditedUsingSBName(editSBSourceAction.getProjectuid(), scienceGoalArray, sBEditParameters.getSbname()));
                } else {
                    arrayList.addAll(this.getAllSBs(scienceGoalArray));
                }
                if (arrayList.isEmpty()) {
                    throw new P2GActionInterface.UnableToCompleteActionException("No SBs can be found to edit for the project " + editSBSourceAction.getProjectuid());
                }
                if (sBEditParameters.getCoordinates() != null) {
                    this.updateSBCoordinates(arrayList, sBEditParameters);
                }
                if (sBEditParameters.getVelocity() == null) continue;
                try {
                    this.updateSBVelocity(arrayList, sBEditParameters);
                }
                catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
                    throw new P2GActionInterface.UnableToCompleteActionException(unitMappingErrorException);
                }
            }
            try {
                this.storeProject(projectTopLevelEntities.getObsProject(), "SBs in project " + editSBSourceAction.getProjectuid() + " updated in archive");
            }
            catch (Exception exception) {
                this.consoleOutput("Unable to store project " + editSBSourceAction.getProjectuid() + " : " + exception.getMessage());
                throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
            }
        }
    }

    private void updateSBVelocity(@NonNull List<SchedBlock> list, @NonNull SBEditParameters sBEditParameters) throws BatchOTXMLUnitMapper.UnitMappingErrorException {
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        if (sBEditParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        VelocityType velocityType = sBEditParameters.getVelocity();
        if (velocityType == null) {
            return;
        }
        boolean bl = sBEditParameters.isUpdateallsources();
        for (SchedBlock schedBlock : list) {
            for (FieldSource fieldSource : schedBlock.getFieldSource()) {
                if (!bl && !StringUtils.equalsIgnoreCase((String)fieldSource.getSourceName(), (String)sBEditParameters.getSourcename())) continue;
                Optional<Object> optional = Optional.empty();
                Optional<Object> optional2 = Optional.empty();
                Optional<Object> optional3 = Optional.empty();
                Optional<Object> optional4 = Optional.empty();
                if (velocityType.getDopplertype() != null) {
                    optional = Optional.of(BatchOTXMLUnitMapper.mapDopplerType(velocityType.getDopplertype()));
                }
                if (velocityType.getReferenceframe() != null) {
                    optional2 = Optional.of(BatchOTXMLUnitMapper.mapVelocityReferenceType(velocityType.getReferenceframe()));
                }
                if (velocityType.getVelocity() != null) {
                    optional3 = Optional.of(velocityType.getVelocity());
                }
                Optional<Object> optional5 = velocityType.getUnit() != null ? Optional.of(BatchOTXMLUnitMapper.mapVelocityUnitType(velocityType.getUnit())) : Optional.empty();
                if (velocityType.getZ() != null) {
                    optional4 = Optional.of(velocityType.getZ());
                }
                optional3.ifPresent(d -> this.updateSourceVelocity((Double)d, (Optional<String>)optional5, fieldSource));
                optional2.ifPresent(string -> fieldSource.getSourceVelocity().setReferenceSystem((String)string));
                optional4.ifPresent(d -> this.updateZ((Double)d, fieldSource));
            }
        }
    }

    private void updateZ(@NonNull Double d, @NonNull FieldSource fieldSource) {
        if (d == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        Velocity velocity = fieldSource.getSourceVelocity();
        Velocity velocity2 = velocity.fromRedshift(d);
        Speed speed = velocity2.getCenterVelocity();
        speed.convertToUnit(velocity.getCenterVelocity().getUnit());
        velocity.getCenterVelocity().setContentAndUnit((ValueUnitPair)speed);
        velocity.setDopplerCalcType(velocity2.getDopplerCalcType());
        this.consoleOutput("Field source " + fieldSource.getSourceName() + " velocity changed to " + velocity + " (z=" + d + ")");
    }

    private void updateSourceVelocity(@NonNull Double d, @NonNull Optional<String> optional, @NonNull FieldSource fieldSource) {
        if (d == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("velocityUnit is marked non-null but is null");
        }
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        Speed speed = fieldSource.getSourceVelocity().getCenterVelocity();
        speed.setContent(d);
        optional.ifPresent(arg_0 -> ((Speed)speed).setUnit(arg_0));
        this.consoleOutput("Updating velocity of field source " + fieldSource.getSourceName() + " to " + speed);
    }

    private void updateSBCoordinates(@NonNull List<SchedBlock> list, @NonNull SBEditParameters sBEditParameters) throws P2GActionInterface.UnableToCompleteActionException {
        if (list == null) {
            throw new NullPointerException("schedBlocksInSGToEdit is marked non-null but is null");
        }
        if (sBEditParameters == null) {
            throw new NullPointerException("requestedSBEdit is marked non-null but is null");
        }
        CoordinatesType coordinatesType = sBEditParameters.getCoordinates();
        if (coordinatesType == null) {
            return;
        }
        String string = sBEditParameters.getSourcename();
        P2GXMLActionPerformer.CoordinatesRecord coordinatesRecord = this.getAPDMCoordinates(coordinatesType);
        boolean bl = sBEditParameters.isUpdateallsources();
        for (SchedBlock schedBlock : list) {
            for (FieldSource fieldSource : schedBlock.getFieldSource()) {
                if (!StringUtils.equalsIgnoreCase((String)fieldSource.getSourceName(), (String)string) && !bl) continue;
                SkyCoordinates skyCoordinates = fieldSource.getTargetCenter();
                coordinatesRecord.ra().ifPresent(d -> skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Longitude.UNIT_DEG)));
                coordinatesRecord.dec().ifPresent(d -> skyCoordinates.setLatitude(Latitude.createLatitude((double)d, (String)Latitude.UNIT_DEG)));
                this.consoleOutput("Updating coordinates of " + string + " in SB " + schedBlock.getName());
            }
        }
    }

    public class InvalidVelocityException
    extends Exception {
        public InvalidVelocityException(String string) {
            super(string);
        }
    }

    public class UnknownScienceGoalsInRegenerationActionException
    extends Exception {
        public UnknownScienceGoalsInRegenerationActionException(String string) {
            super(string);
        }
    }
}

