/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.BatchOTXMLUnitMapper;
import alma.obsprep.ot.scripting.P2GActionInterface;
import alma.obsprep.ot.scripting.bindings.CoordinatesType;
import alma.obsprep.ot.scripting.bindings.Frequency;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.util.Convert4dp;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public abstract class P2GXMLActionPerformer {
    protected boolean isNoStoredEnable = false;
    protected static String actionName = "<ActionUndefined>";
    protected BatchOT batchOTHelper;
    protected boolean isAbandonAtFirstError = true;

    public P2GXMLActionPerformer(boolean bl, @NonNull BatchOT batchOT) {
        if (batchOT == null) {
            throw new NullPointerException("batchOTHelper2 is marked non-null but is null");
        }
        this.isNoStoredEnable = bl;
        this.batchOTHelper = batchOT;
    }

    public static boolean verifyUID(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return Pattern.matches("uid://\\w+/\\w+/\\w+", string);
    }

    public abstract void validateRequestedActions() throws InputParameterValidationException;

    protected ProjectTopLevelEntities fetchProjectFromArchive(@NonNull String string) throws P2GActionInterface.UnableToCompleteActionException {
        if (string == null) {
            throw new NullPointerException("projectUID is marked non-null but is null");
        }
        ObsProject obsProject = null;
        try {
            obsProject = this.batchOTHelper.retrieveprj(string);
        }
        catch (Exception exception) {
            System.out.println("Could not retreive project " + string + " - check that the project exists and your credentials are correct and you have authority to access this project");
            Throwable throwable = exception.getCause();
            if (throwable instanceof PersistenceException) {
                PersistenceException persistenceException = (PersistenceException)throwable;
                System.out.println(persistenceException.getTechnicalDetails());
            }
            throw new P2GActionInterface.UnableToCompleteActionException(exception.getMessage());
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram == null) {
            throw new P2GActionInterface.UnableToCompleteActionException("Cannot find phase 2 ObsProgram - is this project: " + string);
        }
        this.backupProject(obsProject, string);
        return new ProjectTopLevelEntities(obsProject, obsProgram);
    }

    private void backupProject(@NonNull ObsProject obsProject, @NonNull String string) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("projectUID is marked non-null but is null");
        }
        File file = new File(System.getProperty("user.home"), ".almaot/batchbackups");
        file.mkdir();
        String string2 = new SimpleDateFormat("yyyy.MM.dd-HH.mm").format(Date.from(Instant.now()));
        String string3 = string.replace(":", "").replace("/", "") + "-" + string2 + ".aot";
        File file2 = new File(file, string3);
        this.batchOTHelper.exportprj(obsProject, file2.toString());
    }

    protected List<SchedBlock> getSBsToEditedByUID(@NonNull String string, @NonNull ScienceGoal[] scienceGoalArray, @NonNull String string2) throws P2GActionInterface.UnableToCompleteActionException {
        if (string == null) {
            throw new NullPointerException("projectUID is marked non-null but is null");
        }
        if (scienceGoalArray == null) {
            throw new NullPointerException("scienceGoalsInObsProgram is marked non-null but is null");
        }
        if (string2 == null) {
            throw new NullPointerException("sbUID is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        Optional<Object> optional = Optional.empty();
        for (ScienceGoal scienceGoal : scienceGoalArray) {
            List<SchedBlock> list = SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal));
            Optional<SchedBlock> optional2 = list.stream().filter(schedBlock -> schedBlock.getEntityID().equals(string2)).findFirst();
            if (!optional2.isPresent()) continue;
            optional = optional2;
            break;
        }
        if (optional.isEmpty()) {
            throw new P2GActionInterface.UnableToCompleteActionException("Cannot find the SB with UID " + string2 + " in the project with UID " + string);
        }
        arrayList.add((SchedBlock)optional.get());
        return arrayList;
    }

    protected ArrayList<SchedBlock> getSBsToBeEditedUsingSBName(@NonNull String string, @NonNull ScienceGoal[] scienceGoalArray, @NonNull String string2) throws P2GActionInterface.UnableToCompleteActionException {
        if (string == null) {
            throw new NullPointerException("projectUID is marked non-null but is null");
        }
        if (scienceGoalArray == null) {
            throw new NullPointerException("phase2SGs is marked non-null but is null");
        }
        if (string2 == null) {
            throw new NullPointerException("sbName is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        Optional<Object> optional = Optional.empty();
        for (ScienceGoal scienceGoal : scienceGoalArray) {
            List<SchedBlock> list = SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal));
            Optional<SchedBlock> optional2 = list.stream().filter(schedBlock -> schedBlock.getName().equals(string2)).findFirst();
            if (!optional2.isPresent()) continue;
            optional = optional2;
            break;
        }
        if (optional.isEmpty()) {
            throw new P2GActionInterface.UnableToCompleteActionException("Cannot find the SB with name " + string2 + " in the project with UID " + string);
        }
        arrayList.add((SchedBlock)optional.get());
        return arrayList;
    }

    protected List<SchedBlock> getAllSBs(@NonNull ScienceGoal[] scienceGoalArray) {
        if (scienceGoalArray == null) {
            throw new NullPointerException("scienceGoalsInObsProgram is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        for (ScienceGoal scienceGoal : scienceGoalArray) {
            arrayList.addAll(SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal)));
        }
        return arrayList;
    }

    protected void consoleOutput(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        System.out.println(actionName + ": " + string);
    }

    protected void validateSBCoordinateChangeParameters(CoordinatesType coordinatesType, String string) throws InvalidCoordinateException {
        if (coordinatesType != null) {
            String string2 = coordinatesType.getRA();
            try {
                Convert4dp.HHMMSSToDeg(string2);
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                throw new InvalidCoordinateException("The RA specified for SB " + string + " is invalid " + string2);
            }
            String string3 = coordinatesType.getDec();
            try {
                Convert4dp.DDMMSSToDeg(string3);
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                throw new InvalidCoordinateException("The declination specified for SB " + string + " is invalid " + string3);
            }
        }
    }

    protected CoordinatesRecord getAPDMCoordinates(@NonNull CoordinatesType coordinatesType) throws P2GActionInterface.UnableToCompleteActionException {
        if (coordinatesType == null) {
            throw new NullPointerException("coordinates is marked non-null but is null");
        }
        Optional<Double> optional = Optional.empty();
        Optional<Double> optional2 = Optional.empty();
        if (StringUtils.isNotEmpty((String)coordinatesType.getDec())) {
            try {
                optional = Optional.of(Convert4dp.DDMMSSToDeg(coordinatesType.getDec()));
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                throw new P2GActionInterface.UnableToCompleteActionException(exception);
            }
        }
        if (StringUtils.isNotEmpty((String)coordinatesType.getRA())) {
            try {
                optional2 = Optional.of(Convert4dp.HHMMSSToDeg(coordinatesType.getRA()));
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                throw new P2GActionInterface.UnableToCompleteActionException(exception);
            }
        }
        return new CoordinatesRecord(optional2, optional);
    }

    protected void storeProject(@NonNull ObsProject obsProject, @NonNull String string) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.isNoStoredEnable) {
            this.consoleOutput("User requested that modified projects are not re-submitted");
            return;
        }
        this.consoleOutput("Validating and then submitting project to archive");
        this.batchOTHelper.storeprj(obsProject);
        this.consoleOutput(string);
    }

    protected void validateValidFrequency(Frequency frequency, String string) throws InvalidFrequencyException {
        alma.valuetypes.Frequency frequency2;
        try {
            frequency2 = BatchOTXMLUnitMapper.mapFrequency(frequency);
        }
        catch (BatchOTXMLUnitMapper.UnitMappingErrorException unitMappingErrorException) {
            throw new InvalidFrequencyException(unitMappingErrorException);
        }
        try {
            ReceiverBand.getReceiverBand(frequency2.getContentInGHz());
        }
        catch (Exception exception) {
            String string2 = "Frequency " + frequency2 + " is not a valid ALMA frequency";
            this.consoleOutput(string2);
            throw new InvalidFrequencyException(string + " " + string2);
        }
    }

    protected class ProjectTopLevelEntities {
        private ObsProject obsProject;
        private ObsProgram obsProgram;

        public ObsProject getObsProject() {
            return this.obsProject;
        }

        public ObsProgram getObsProgram() {
            return this.obsProgram;
        }

        public void setObsProject(ObsProject obsProject) {
            this.obsProject = obsProject;
        }

        public void setObsProgram(ObsProgram obsProgram) {
            this.obsProgram = obsProgram;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ProjectTopLevelEntities)) {
                return false;
            }
            ProjectTopLevelEntities projectTopLevelEntities = (ProjectTopLevelEntities)object;
            if (!projectTopLevelEntities.canEqual(this)) {
                return false;
            }
            ObsProject obsProject = this.getObsProject();
            ObsProject obsProject2 = projectTopLevelEntities.getObsProject();
            if (obsProject == null ? obsProject2 != null : !obsProject.equals(obsProject2)) {
                return false;
            }
            ObsProgram obsProgram = this.getObsProgram();
            ObsProgram obsProgram2 = projectTopLevelEntities.getObsProgram();
            return !(obsProgram == null ? obsProgram2 != null : !obsProgram.equals(obsProgram2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ProjectTopLevelEntities;
        }

        public int hashCode() {
            int n = 1;
            ObsProject obsProject = this.getObsProject();
            n = n * 59 + (obsProject == null ? 43 : obsProject.hashCode());
            ObsProgram obsProgram = this.getObsProgram();
            n = n * 59 + (obsProgram == null ? 43 : obsProgram.hashCode());
            return n;
        }

        public String toString() {
            return "P2GXMLActionPerformer.ProjectTopLevelEntities(obsProject=" + this.getObsProject() + ", obsProgram=" + this.getObsProgram() + ")";
        }

        public ProjectTopLevelEntities(ObsProject obsProject, ObsProgram obsProgram) {
            this.obsProject = obsProject;
            this.obsProgram = obsProgram;
        }
    }

    public class InvalidCoordinateException
    extends Exception {
        public InvalidCoordinateException(String string) {
            super(string);
        }
    }

    protected record CoordinatesRecord(Optional<Double> ra, Optional<Double> dec) {
    }

    public class InvalidFrequencyException
    extends Exception {
        public InvalidFrequencyException(Exception exception) {
            super(exception);
        }

        public InvalidFrequencyException(String string) {
            super(string);
        }
    }

    public class InputParameterValidationException
    extends Exception {
        public InputParameterValidationException(String string) {
            super(string);
        }

        public InputParameterValidationException(Exception exception) {
            super(exception);
        }
    }
}

