/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyChangeEvent;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public abstract class ETCTimeCalculator {
    private static CacheAccess<Integer, Integer> numberTuningsCache = JCS.getInstance((String)"numberTuningsCache");
    protected Log.Logger logger = Log.logger((Object)this);
    protected ScienceGoal scienceGoal;
    protected int numRetunings = 1;
    protected ObsUnitSet obsUnitSet = null;
    protected double sigma;
    protected double beamsizeFactor;

    public Sensitivity singlePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, CorrConfigMode corrConfigMode, Frequency frequency, CorrelatorModeConversionEnum correlatorModeConversionEnum) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (targetParameters == null) {
            return Sensitivity.createSensitivity((double)0.0, (String)Sensitivity.UNIT_JY);
        }
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        int n = spectralSetupParameters.getPolarizationFactor();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Frequency frequency2 = (Frequency)performanceParameters.getSpectralSetupParameters().getDesiredSensitivityFrequencyWidth().multiply(n);
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
        Latitude latitude = SiteCharacteristics.getInstance().getObsLatitude();
        int n2 = AlmaCapabilities.getInstance().getNumAntennas(array, this.scienceGoal.getSpectralSetupParameters());
        int n3 = this.scienceGoal.getRecommendedWVCIndex();
        if (correlatorModeConversionEnum.equals((Object)CorrelatorModeConversionEnum.Convert4BitModeTo2Bit)) {
            corrConfigMode = CorrConfigMode.get2bitEquivalentCorrelatorMode(corrConfigMode);
        }
        double d = Array.isBLC(array) ? corrConfigMode.getBLEfficiency() : corrConfigMode.getACAEfficiency();
        double d2 = this.scienceGoal.getSpectralSetupParameters().getLO1Frequency().getContentInGHz();
        if (this.scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
            d2 = Double.NaN;
        }
        double d3 = 1.0;
        try {
            d3 = Configuration.getShadowMultiplierForArray(array, this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        ReceiverBand receiverBand = targetParameters.getScienceGoal().getSpectralSetupParameters().getReceiverBand();
        Sensitivity sensitivity = ExposureTimeCalculator.pointSourceSensitivity(time, frequency, frequency2, d, skyCoordinates, n2, array, latitude, n3, d2, d3, Optional.ofNullable(receiverBand));
        if (targetParameters.isRectanglePattern() && !Array.ARRAY_TP.equals((Object)array)) {
            try {
                double d4 = this.getMosaicTimeReductionFactor(targetParameters);
                sensitivity = (Sensitivity)sensitivity.divide(Math.sqrt(d4));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                invalidObsProgramParametersException.printStackTrace();
            }
        }
        return sensitivity;
    }

    public Sensitivity singlePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency, CorrelatorModeConversionEnum correlatorModeConversionEnum) throws InvalidFrequencyException, SourceNeverVisibleException {
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        int n = spectralSetupParameters.getPolarizationFactor();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Frequency frequency2 = (Frequency)performanceParameters.getSpectralSetupParameters().getDesiredSensitivityFrequencyWidth().multiply(n);
        return this.singlePointOnSourceSensitivity(array, time, targetParameters, frequency, frequency2, correlatorModeConversionEnum);
    }

    public Sensitivity singlePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, Frequency frequency, Frequency frequency2, CorrelatorModeConversionEnum correlatorModeConversionEnum) throws InvalidFrequencyException, SourceNeverVisibleException {
        CorrConfigMode corrConfigMode;
        if (targetParameters == null) {
            return Sensitivity.createSensitivity((double)0.0, (String)Sensitivity.UNIT_JY);
        }
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
        int n = AlmaCapabilities.getInstance().getNumAntennas(array, spectralSetupParameters);
        if (spectralSetupParameters.isSpectralScan()) {
            corrConfigMode = spectralSetupParameters.getSpectralScan().getCorrConfigMode();
        } else {
            try {
                corrConfigMode = spectralSetupParameters.getRepresentativeSpectralWindow().getCorrConfigMode();
            }
            catch (Exception exception) {
                Log.logger((Object)this).warning("Could not find representative window");
                if (spectralSetupParameters.getAbstractScienceSpectralWindowCount() > 0) {
                    corrConfigMode = spectralSetupParameters.getScienceSpectralWindow(0).getCorrConfigMode();
                }
                throw new InvalidFrequencyException();
            }
        }
        if (correlatorModeConversionEnum.equals((Object)CorrelatorModeConversionEnum.Convert4BitModeTo2Bit)) {
            corrConfigMode = CorrConfigMode.get2bitEquivalentCorrelatorMode(corrConfigMode);
        }
        double d = Array.isBLC(array) ? corrConfigMode.getBLEfficiency() : corrConfigMode.getACAEfficiency();
        double d2 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
        if (spectralSetupParameters.isSpectralScan()) {
            d2 = Double.NaN;
        }
        double d3 = 1.0;
        try {
            d3 = Configuration.getShadowMultiplierForArray(array, this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        Latitude latitude = SiteCharacteristics.getInstance().getObsLatitude();
        int n2 = this.scienceGoal.getRecommendedWVCIndex();
        Sensitivity sensitivity = ExposureTimeCalculator.pointSourceSensitivity(time, frequency, frequency2, d, skyCoordinates, n, array, latitude, n2, d2, d3, Optional.ofNullable(receiverBand));
        if (targetParameters.isRectanglePattern() && !Array.ARRAY_TP.equals((Object)array)) {
            try {
                double d4 = this.getMosaicTimeReductionFactor(targetParameters);
                sensitivity = (Sensitivity)sensitivity.divide(Math.sqrt(d4));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                invalidObsProgramParametersException.printStackTrace();
            }
        }
        return sensitivity;
    }

    public Sensitivity singlePointOnSourceSensitivity(Array array, Time time, TargetParameters targetParameters, ScienceSpectralWindow scienceSpectralWindow) throws InvalidFrequencyException, SourceNeverVisibleException {
        Frequency frequency = scienceSpectralWindow.getCenterFrequencySky();
        return this.singlePointOnSourceSensitivity(array, time, targetParameters, frequency, CorrConfigMode.getCorrelatorConversionMode(array));
    }

    public synchronized Time singlePointOnSourceTime(Array array, Sensitivity sensitivity, TargetParameters targetParameters, Frequency frequency, boolean bl, CorrelatorModeConversionEnum correlatorModeConversionEnum) throws InvalidFrequencyException, SourceNeverVisibleException {
        boolean bl2;
        CorrConfigMode corrConfigMode;
        if (targetParameters == null) {
            return Time.createTimeSec(0.0);
        }
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        int n = spectralSetupParameters.getPolarizationFactor();
        boolean bl3 = spectralSetupParameters.isSingleContinuumSkyFrequency();
        Frequency frequency2 = spectralSetupParameters.isSpectralScan() || spectralSetupParameters.getSSPDerivedFromSpectralScanSetup() ? this.scienceGoal.getSpectralSetupParameters().getRepresentativeFrequency() : (bl3 ? this.scienceGoal.getRepresentativeFrequencyInSky() : spectralSetupParameters.getRepresentativeFrequency().dopplerShifted(targetParameters.getSourceVelocity()));
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        TargetParameters targetParameters2 = this.scienceGoal.getSoleTargetParameters();
        boolean bl4 = true;
        if (((Object)((Object)targetParameters2.getSourceVelocity().getCenterVelocity())).equals((Object)Speed.ZERO_SPEED)) {
            bl4 = false;
        }
        Frequency frequency3 = this.scienceGoal.getRepresentativeFrequencyInSky();
        if (!(spectralSetupParameters.isSpectralScan() || spectralSetupParameters.getSSPDerivedFromSpectralScanSetup() || !bl4 || bl3 || frequency3.equals((Object)performanceParameters.getRepresentativeFrequency()))) {
            performanceParameters.representativeFrequencyUpdated(new RepresentativeFrequencyChangeEvent((Object)spectralSetupParameters.getRepresentativeFrequency()));
        }
        Frequency frequency4 = (Frequency)frequency.multiply(n);
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
        Latitude latitude = SiteCharacteristics.getInstance().getObsLatitude();
        int n2 = AlmaCapabilities.getInstance().getNumAntennas(array, spectralSetupParameters);
        int n3 = this.scienceGoal.getRecommendedWVCIndex();
        if (spectralSetupParameters.isSpectralScan()) {
            corrConfigMode = spectralSetupParameters.getSpectralScan().getCorrConfigMode();
        } else {
            try {
                corrConfigMode = spectralSetupParameters.getRepresentativeSpectralWindow().getCorrConfigMode();
            }
            catch (Exception exception) {
                Log.logger((Object)this).warning("Could not find representative window " + exception);
                if (spectralSetupParameters.getAbstractScienceSpectralWindowCount() > 0) {
                    corrConfigMode = spectralSetupParameters.getScienceSpectralWindow(0).getCorrConfigMode();
                }
                throw new InvalidFrequencyException();
            }
        }
        boolean bl5 = correlatorModeConversionEnum.equals((Object)CorrelatorModeConversionEnum.Convert4BitModeTo2Bit);
        if (bl5) {
            corrConfigMode = CorrConfigMode.get2bitEquivalentCorrelatorMode(corrConfigMode);
        }
        if ((bl2 = Array.isBLC(array)) && bl5) {
            Log.logger(ETCTimeCalculator.class).warning("converting to 2-bit correlator mode with the BLC is unexpected");
        }
        double d = bl2 ? corrConfigMode.getBLEfficiency() : corrConfigMode.getACAEfficiency();
        double d2 = Double.NaN;
        if (!spectralSetupParameters.isSpectralScan()) {
            d2 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
        }
        double d3 = 1.0;
        try {
            d3 = Configuration.getShadowMultiplierForArray(array, this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        Time time = ExposureTimeCalculator.pointSourceExposureTime(sensitivity, frequency2, frequency4, d, skyCoordinates, n2, array, latitude, n3, d2, d3, Optional.ofNullable(spectralSetupParameters.getReceiverBand()));
        if (targetParameters.isRectanglePattern() && !Array.ARRAY_TP.equals((Object)array)) {
            try {
                time = (Time)time.divide(this.getMosaicTimeReductionFactor(targetParameters));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                invalidObsProgramParametersException.printStackTrace();
            }
        }
        if (this.logger.fine()) {
            this.logger.fine("ETC parameters : time " + time + " sensit : " + sensitivity + ", targetSkyFrequency : " + frequency2 + ", bandwidth : " + frequency4 + ", corrEff : " + d + " targetCoords : " + skyCoordinates + " site latitude : " + latitude + " wv index : " + n3 + " array " + array);
        }
        Time time2 = AlmaPolicies.getInstance().getMinimumTimeOnSrc();
        if (bl && time.isLessThan((AbstractDoubleWithUnit)time2)) {
            return time2.deepCopy();
        }
        return time;
    }

    public Time singlePointOnSourceTime(Array array, TargetParameters targetParameters, boolean bl, CorrelatorModeConversionEnum correlatorModeConversionEnum) throws InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        UserSensitivity userSensitivity = performanceParameters.getSensitivityForFinestAR();
        Time time = this.singlePointOnSourceTime(array, (Sensitivity)((Object)userSensitivity), targetParameters, performanceParameters.getSensitivityFrequencyWidth(), bl, correlatorModeConversionEnum);
        if (bl && EnumSet.of(Array.ARRAY_12M, Array.ARRAY_7M).contains((Object)array)) {
            Integer n = 0;
            Object object = this.scienceGoal.getTargetParameters();
            int n2 = ((TargetParameters[])object).length;
            for (int i = 0; i < n2; ++i) {
                TargetParameters targetParameters2 = object[i];
                n = n + targetParameters2.getNumberOfPointings(array);
            }
            Time time2 = AlmaPolicies.getInstance().getMinTimeOnSourcePerSB();
            if (this.scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
                time2 = (Time)time2.divide(this.getNoOfTunings());
            }
            if ((object = (Time)time.multiply(n.intValue())).isLessThan((AbstractDoubleWithUnit)time2)) {
                time = (Time)time2.divide(n.intValue());
            }
        }
        return time;
    }

    public Time singlePointOnSourceTimeFromSB(TargetParameters targetParameters) throws InvalidObsProgramParametersException, UnknownEntityException {
        return this.singlePointOnSourceTimeFromSB(targetParameters, Array.ARRAY_12M);
    }

    public Time singlePointOnSourceTimeFromSB(@NonNull TargetParameters targetParameters, @NonNull Map<String, SchedBlock> map) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameter is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("targetSBMapping is marked non-null but is null");
        }
        SchedBlock schedBlock = map.get(targetParameters.getSourceName());
        if (schedBlock == null) {
            Log.logger(ETCTimeCalculator.class).warning(targetParameters.getSourceName() + " not found in the map");
            throw new IllegalArgumentException(targetParameters.getSourceName() + " not found in the map");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            for (Target target : observingGroup.getAllOrderedTargets(ScienceParameters.scienceParametersFilter)) {
                FieldSource fieldSource = target.getFieldSource();
                if (!fieldSource.getTargetParameters().matches(targetParameters)) continue;
                int n = fieldSource.getNumberOfPointings();
                Time time = (Time)((Time)target.getScienceParametersList()[0].getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount())).divide(n);
                if (this.logger.fine()) {
                    this.logger.fine(String.format("Single point on source time for target \"%s\" is %.5g mins", targetParameters.getSourceName(), time.getContentInUnits(Time.UNIT_MIN)));
                }
                return time;
            }
        }
        return Time.createTimeSec(0.0);
    }

    public Time singlePointOnSourceTimeFromSB(TargetParameters targetParameters, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        Time time = Time.createTimeSec(0.0);
        this.generateSBs(this.scienceGoal);
        for (ObsUnitSet obsUnitSet : this.obsUnitSet.getObsUnitSet()) {
            for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
                for (SchedBlock schedBlock : obsUnitSet2.findSchedBlocks()) {
                    if (array.equals((Object)Array.ARRAY_12M) ? !schedBlock.is12mExtendedArraySB() : array.equals((Object)Array.ARRAY_7M) && !schedBlock.isACA7mArraySB()) continue;
                    for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                            Target target = orderedTarget.getTarget();
                            if (!target.hasScienceParameters() || !target.getFieldSource().getTargetParameters().matches(targetParameters)) continue;
                            Integer n = target.getFieldSource().getNumberOfPointings();
                            time = (Time)((Time)target.getScienceParametersList()[0].getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount())).divide(n.intValue());
                            if (this.logger.fine()) {
                                this.logger.fine(String.format("Single point on source time for target \"%s\" is %.5g mins", targetParameters.getSourceName(), time.getContentInUnits(Time.UNIT_MIN)));
                            }
                            return time;
                        }
                    }
                }
            }
        }
        this.logger.warning("Could not find a target in any SB structure which matched the target parameters provided" + targetParameters.getSourceName());
        return Time.createTimeSec(0.0);
    }

    abstract ObsUnitSet generateSBs(ScienceGoal var1) throws InvalidObsProgramParametersException;

    static Angle getDistanceBetween(@NonNull SkyCoordinates skyCoordinates, @NonNull SkyCoordinates skyCoordinates2) {
        if (skyCoordinates == null) {
            throw new NullPointerException("p1 is marked non-null but is null");
        }
        if (skyCoordinates2 == null) {
            throw new NullPointerException("p2 is marked non-null but is null");
        }
        double d = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_RAD);
        double d2 = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_RAD);
        double d3 = skyCoordinates2.getLongitude().getContentInUnits(Longitude.UNIT_RAD);
        double d4 = skyCoordinates2.getLatitude().getContentInUnits(Latitude.UNIT_RAD);
        double d5 = Math.sin((d2 - d4) / 2.0);
        double d6 = Math.sin((d - d3) / 2.0);
        double d7 = Math.pow(d5, 2.0) + Math.cos(d4) * Math.cos(d2) * Math.pow(d6, 2.0);
        double d8 = 2.0 * Math.asin(Math.sqrt(d7));
        return Angle.createAngle((double)d8, (String)UserAngle.UNIT_RAD);
    }

    double getMosaicTimeReductionFactor(@NonNull TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        if (targetParameters == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        double d = 0.0;
        for (Rectangle rectangle : targetParameters.getFieldRectangle()) {
            RectangleMosaic rectangleMosaic = new RectangleMosaic(rectangle);
            PointingPattern pointingPattern = rectangleMosaic.getPointingPattern();
            Frequency frequency = rectangle.getReferenceFrequency();
            SkyCoordinates skyCoordinates = rectangle.getFieldCenterCoordinates();
            SkyCoordinates skyCoordinates2 = targetParameters.getSourceCoordinates();
            PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(skyCoordinates2);
            SkyCoordinates[] skyCoordinatesArray = pointingPattern.getPhaseCenterCoordinates();
            SkyCoordinates skyCoordinates3 = this.getMostCentralPointing(skyCoordinatesArray, skyCoordinates, pointingCoordsConverter);
            for (SkyCoordinates skyCoordinates4 : skyCoordinatesArray) {
                if (skyCoordinates.isAbsoluteCoordinates()) {
                    skyCoordinates4 = pointingCoordsConverter.offsetToAbsolute(skyCoordinates4);
                }
                Angle angle = ETCTimeCalculator.getDistanceBetween(skyCoordinates4, skyCoordinates3);
                double d2 = this.getEquivalentOnSourceTime(angle, frequency);
                d += d2;
            }
        }
        return d;
    }

    private SkyCoordinates getMostCentralPointing(SkyCoordinates[] skyCoordinatesArray, SkyCoordinates skyCoordinates, PointingCoordsConverter pointingCoordsConverter) {
        HashMap<Angle, SkyCoordinates> hashMap = new HashMap<Angle, SkyCoordinates>();
        for (SkyCoordinates skyCoordinates2 : skyCoordinatesArray) {
            if (skyCoordinates.isAbsoluteCoordinates()) {
                skyCoordinates2 = pointingCoordsConverter.offsetToAbsolute(skyCoordinates2);
            }
            Angle angle = ETCTimeCalculator.getDistanceBetween(skyCoordinates2, skyCoordinates);
            hashMap.put(angle, skyCoordinates2);
        }
        Angle angle = (Angle)((Object)Collections.min(hashMap.keySet(), AbstractDoubleWithUnit::compareTo));
        return (SkyCoordinates)hashMap.get((Object)angle);
    }

    protected int getNoOfTunings() throws InvalidObsProgramParametersException {
        Integer n = MiscUtils.convertToString((BusinessObject)this.scienceGoal).hashCode();
        Integer n2 = (Integer)numberTuningsCache.get((Object)n);
        if (n2 != null) {
            return n2;
        }
        if (this.scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
            try {
                this.numRetunings = this.scienceGoal.getSpectralSetupParameters().getSpectralScan().getTunings().getNumberOfTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                throw new InvalidObsProgramParametersException(unableToFindSolutionException.getMessage());
            }
        }
        try {
            this.numRetunings = MinTuningsCalculator.getLO1Tunings(this.scienceGoal).size();
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
            throw new InvalidObsProgramParametersException(unableToCalculateMinNumberOfTunings.getMessage());
        }
        numberTuningsCache.put((Object)n, (Object)this.numRetunings);
        return this.numRetunings;
    }

    protected double getEquivalentOnSourceTime(@NonNull Angle angle, Frequency frequency) {
        if (angle == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        return this.getEquivalentOnSourceTime(UserAngle.createUserAngle(angle.getContent(), angle.getUnit(), frequency));
    }

    protected double getEquivalentOnSourceTime(@NonNull UserAngle userAngle) {
        if (userAngle == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        userAngle.convertToUserUnit(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
        double d = userAngle.getUserContent();
        double d2 = d * this.beamsizeFactor;
        double d3 = Math.exp(-Math.pow(d2 / this.sigma, 2.0) * 0.5);
        return Math.pow(d3, 2.0);
    }

    public Time getSinglePointOnSourceTime(Array array, TargetParameters targetParameters, boolean bl) throws InvalidObsProgramParametersException {
        try {
            return this.singlePointOnSourceTime(array, targetParameters, bl, CorrConfigMode.getCorrelatorConversionMode(array));
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new InvalidObsProgramParametersException(exception);
        }
    }

    public int getNumRetunings() {
        return this.numRetunings;
    }

    public static enum CorrelatorModeConversionEnum {
        NoCorrelatorConversion,
        Convert4BitModeTo2Bit;

    }
}

