/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.valuetypes.Time;
import java.util.HashMap;
import java.util.Map;

class TimeOnSourceData {
    private SchedBlock schedBlock;
    private Integer noOfSBExecutions;
    private Map<String, Time> onSourceTimePerObservingGroup = new HashMap<String, Time>(30);

    public TimeOnSourceData(SchedBlock schedBlock, Integer n) {
        this.schedBlock = schedBlock;
        this.setNoOfSBExecutions(n);
    }

    public void addTimeOnSourceForObservingGroup(String string, Time time) {
        this.onSourceTimePerObservingGroup.put(string, time);
    }

    public Time getTimeOnSourceForObservingGroup(String string) throws SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        if (!this.onSourceTimePerObservingGroup.containsKey(string)) {
            throw new SBTimeEstimateHelper.UnknownObservingGroupTypeException("Unknown OG " + string + " found ");
        }
        return this.onSourceTimePerObservingGroup.get(string);
    }

    public Time getTimeOnSourcePerSBExecution() {
        Time time = Time.createTimeSec(0.0);
        for (Time time2 : this.onSourceTimePerObservingGroup.values()) {
            time.aggregate(time2);
        }
        return time;
    }

    public String toString() {
        return "Time on source per SB exec is " + this.getTimeOnSourcePerSBExecution() + " no of SB execs is " + this.getNoOfSBExecutions();
    }

    public SchedBlock getSchedBlock() {
        return this.schedBlock;
    }

    public void setNoOfSBExecutions(Integer n) {
        this.noOfSBExecutions = n;
    }

    public Integer getNoOfSBExecutions() {
        return this.noOfSBExecutions;
    }
}

