/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.io.Serializable;
import lombok.NonNull;

public class DeclinationData
implements Comparable<DeclinationData>,
Serializable {
    private static final long serialVersionUID = 1783648768L;
    private Angle dec = null;
    private Angle coarsestAR = null;
    private Angle finestAR = null;
    private Angle LAS = null;

    public DeclinationData(double d, double d2, double d3, double d4) {
        this.dec = UserAngle.createUserAngle(d, Angle.UNIT_DEG);
        this.coarsestAR = UserAngle.createUserAngle(d2, Angle.UNIT_ARCSEC);
        this.finestAR = UserAngle.createUserAngle(d3, Angle.UNIT_ARCSEC);
        this.LAS = UserAngle.createUserAngle(d4, Angle.UNIT_ARCSEC);
    }

    public Angle getFinestARAtRF(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        return (Angle)this.getFinestAR().multiply(100.0 / frequency.getContentInGHz());
    }

    public Angle getCoarsestARAtRF(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        return (Angle)this.getCoarsestAR().multiply(100.0 / frequency.getContentInGHz());
    }

    public Angle getAveragedAR() {
        return (Angle)((Angle)this.coarsestAR.plus((AbstractDoubleWithUnit)this.finestAR)).divide(2.0, true);
    }

    @Override
    public int compareTo(DeclinationData declinationData) {
        if (this.getDec().isGreaterThan((AbstractDoubleWithUnit)declinationData.getDec())) {
            return 1;
        }
        if (this.getDec().isLessThan((AbstractDoubleWithUnit)declinationData.getDec())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "DeclinationData(dec=" + this.getDec() + ", coarsestAR=" + this.getCoarsestAR() + ", finestAR=" + this.getFinestAR() + ", LAS=" + this.getLAS() + ")";
    }

    public Angle getDec() {
        return this.dec;
    }

    public Angle getCoarsestAR() {
        return this.coarsestAR;
    }

    public Angle getFinestAR() {
        return this.finestAR;
    }

    public Angle getLAS() {
        return this.LAS;
    }
}

