/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class TechnicalJustificationExpert {
    @NonNull
    private final ScienceGoal scienceGoal;
    private Optional<Map<String, SchedBlock>> targetMapping;

    public TechnicalJustificationCalculations calculateTJValuesForStandardObsmode() {
        TechnicalJustificationCalculations technicalJustificationCalculations = new TechnicalJustificationCalculations();
        TechnicalJustificationCalculations.setTJDesiredResolution(technicalJustificationCalculations, this.scienceGoal);
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        ExpectedPropertiesElements expectedPropertiesElements = this.targetMapping.isPresent() ? this.scienceGoal.getConsolidatedExpectedProperties(this.targetMapping.get()) : this.scienceGoal.getConsolidatedExpectedProperties();
        technicalJustificationCalculations.setConsolidatedExpectedProperties(expectedPropertiesElements);
        UserFrequency userFrequency = performanceParameters.getSensitivityFrequencyWidthAsUF();
        technicalJustificationCalculations.setBandwidthSensitivityUser(userFrequency);
        UserSensitivity userSensitivity = TechnicalJustificationModel.getContinuumSensitivity(performanceParameters);
        technicalJustificationCalculations.setDesiredSensitivity(userSensitivity);
        double d = userSensitivity.getContentInUnits(TechnicalJustificationModel.SENSITIVITY_CALC_UNIT);
        technicalJustificationCalculations.setReqContSensitivity(d);
        double d2 = expectedPropertiesElements.expectedLineWidth.asSpeed().getContentInUnits(TechnicalJustificationModel.SPEED_CALC_UNIT);
        technicalJustificationCalculations.setLineWidthInKMS(d2);
        double d3 = userFrequency.getContentInUnits(TechnicalJustificationModel.FREQUENCY_CALC_UNIT);
        double d4 = d2 / d3;
        technicalJustificationCalculations.setFBWCalculationResult(d4);
        TechnicalJustificationCalculations.setTJRepresentativeFreq(technicalJustificationCalculations, this.scienceGoal);
        UserSensitivity userSensitivity2 = TechnicalJustificationExpert.createUserSensitivityWithDefinedBeamsizeAndObsFreq((Angle)((Object)technicalJustificationCalculations.getDesiredResolution()), technicalJustificationCalculations.getRepresentativeFrequency());
        userSensitivity2.setContentAndUnit((ValueUnitPair)expectedPropertiesElements.expectedPeakLineFluxDensity);
        technicalJustificationCalculations.setPeakLineFlux(userSensitivity2);
        UserSensitivity userSensitivity3 = TechnicalJustificationExpert.createUserSensitivityWithDefinedBeamsizeAndObsFreq((Angle)((Object)technicalJustificationCalculations.getDesiredResolution()), technicalJustificationCalculations.getRepresentativeFrequency());
        userSensitivity3.setContentAndUnit((ValueUnitPair)expectedPropertiesElements.expectedPeakFluxDensity);
        technicalJustificationCalculations.setPeakContFlux(userSensitivity3);
        SNR sNR = TechnicalJustificationCalculations.calculateSourceWithPoorestSNR(expectedPropertiesElements, technicalJustificationCalculations, this.scienceGoal);
        UserSensitivity userSensitivity4 = sNR.getSnr();
        technicalJustificationCalculations.setContinuumRMS(sNR.getSnr());
        expectedPropertiesElements.setSensitivityForBW(sNR.getAchievedBWForSensitivity());
        UserSensitivity userSensitivity5 = expectedPropertiesElements.lineRMS;
        technicalJustificationCalculations.setLineRMS(userSensitivity5);
        boolean bl = userSensitivity2 != null && userSensitivity2.getContent() > 0.0;
        boolean bl2 = userSensitivity3 != null && userSensitivity3.getContent() > 0.0;
        technicalJustificationCalculations.setLineFluxSet(bl);
        technicalJustificationCalculations.setContFluxSet(bl2);
        boolean bl3 = false;
        UserSensitivity userSensitivity6 = userSensitivity;
        if (bl2) {
            if (bl) {
                if (d3 > 2.0 * d2) {
                    bl3 = true;
                    userSensitivity6 = userSensitivity5;
                }
            } else {
                bl3 = true;
            }
        }
        technicalJustificationCalculations.setContinuumFluxToBeUsed(bl3);
        boolean bl4 = !bl3;
        boolean bl5 = bl2 && bl4 || performanceParameters.getNeedsMoreTime() || spectralSetupParameters.getPolarizationFactor() != 1;
        technicalJustificationCalculations.setShowContRMSCalc(bl5);
        double d5 = bl3 ? userSensitivity3.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / d : userSensitivity2.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / d;
        technicalJustificationCalculations.setPeakFluxSNR(d5);
        technicalJustificationCalculations.setThirdOfLineWidth(d2 / 3.0);
        if (d2 > 0.0) {
            Object object;
            technicalJustificationCalculations.setLineWidthSet(true);
            Frequency frequency = spectralSetupParameters.getRepresentativeBandwidth();
            Frequency frequency2 = spectralSetupParameters.getRepresentativeFrequency();
            if (spectralSetupParameters.isSpectralScan()) {
                object = spectralSetupParameters.getSpectralScan();
                frequency = object.getEffectiveBandwidth();
                frequency2 = object.getCenterFrequency();
            } else {
                object = spectralSetupParameters.getRepresentativeSpectralWindow();
                if (null != object) {
                    frequency = ((ScienceSpectralWindow)object).getEffectiveBandwidth();
                    frequency2 = ((ScienceSpectralWindow)object).getCenterFrequencySky();
                }
            }
            object = Speed.getSpeedResolution(frequency, frequency2);
            technicalJustificationCalculations.setRepresentativeWidthAsSpeed(Optional.of(object));
            technicalJustificationCalculations.setLineWidthGreaterThanSPWWarningShown(d2 > object.getContentInUnits(Speed.UNIT_KM_S));
        } else {
            technicalJustificationCalculations.setLineWidthGreaterThanSPWWarningShown(false);
            technicalJustificationCalculations.setLineWidthSet(false);
        }
        double d6 = userSensitivity3.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT);
        double d7 = userSensitivity4.getContentInUnits(TechnicalJustificationModel.SENSITIVITY_CALC_UNIT);
        double d8 = d6 / d7;
        technicalJustificationCalculations.setContSNR(d8);
        technicalJustificationCalculations.setShowSNRLowWarning(d5 < 3.0 || bl2 && d8 < 3.0 || bl && technicalJustificationCalculations.getLineFluxSNR() < 3.0);
        Angle angle = performanceParameters.getDesiredLargestScale();
        technicalJustificationCalculations.setDesiredLargestStructure(angle);
        boolean bl6 = bl && d2 > 0.0 && d2 / d3 < 3.0;
        technicalJustificationCalculations.setWideBandwidthWarningRequired(bl6);
        if (bl && bl2 && userSensitivity6.getContent() > 0.0) {
            double d9 = expectedPropertiesElements.getSpectralDynamicRange();
            technicalJustificationCalculations.setSpectralDynamicRange(d9);
            technicalJustificationCalculations.setDynamicRangeShown(true);
            int[] nArray = new int[]{1000, -1, 1000, 1000, 500, 1000, 400, 250, 170, 150};
            int n = -1;
            if (!this.scienceGoal.getRepresentativeFrequency().isZero()) {
                try {
                    int n2;
                    ReceiverBand receiverBand = this.scienceGoal.getReceiverBand();
                    if (receiverBand != null && 0 <= (n2 = receiverBand.getNumber() - 1) && n2 < nArray.length) {
                        n = nArray[receiverBand.getNumber() - 1];
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.logger((Object)this).info("Illegal argument exception was thrown - this could be trapped up front");
                }
                technicalJustificationCalculations.setMaxSpectralDynamicRange(n);
                boolean bl7 = n > 0 && (double)n < d9;
                technicalJustificationCalculations.setDynamicRangeWarningShown(bl7);
            }
        } else {
            technicalJustificationCalculations.setDynamicRangeShown(false);
            technicalJustificationCalculations.setDynamicRangeWarningShown(false);
        }
        technicalJustificationCalculations.setMayNotResolve(d2 > 0.0 && bl && expectedPropertiesElements.resolvedVelocity > d2 / 3.0);
        return technicalJustificationCalculations;
    }

    private static UserSensitivity createUserSensitivityWithDefinedBeamsizeAndObsFreq(Angle angle, Frequency frequency) {
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity();
        userSensitivity.setBeamsize(angle);
        userSensitivity.setObservingFrequency(frequency);
        return userSensitivity;
    }

    private static Optional<Map<String, SchedBlock>> $default$targetMapping() {
        return Optional.empty();
    }

    TechnicalJustificationExpert(@NonNull ScienceGoal scienceGoal, Optional<Map<String, SchedBlock>> optional) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.targetMapping = optional;
    }

    public static TechnicalJustificationExpertBuilder builder() {
        return new TechnicalJustificationExpertBuilder();
    }

    public static class TechnicalJustificationCalculations {
        private ExpectedPropertiesElements consolidatedExpectedProperties;
        private boolean isSensitivityFlux = true;
        private double contSNR;
        private boolean isShowSNRLowWarning = false;
        private UserFrequency bandwidthSensitivityUser;
        private boolean isMayNotResolve;
        private double thirdOfLineWidth;
        private double fBWCalculationResult;
        private boolean isLineWidthGreaterThanSPWWarningShown = false;
        private boolean isLineWidthSet = false;
        private boolean isDynamicRangeWarningShown;
        private boolean isDynamicRangeShown;
        private double maxSpectralDynamicRange;
        private double spectralDynamicRange;
        private boolean isWideBandwidthWarningRequired;
        private Optional<Speed> representativeWidthAsSpeed = Optional.empty();
        private double lineWidthInKMS;
        private UserSensitivity continuumRMS;
        private Frequency representativeFrequency;
        private UserAngle desiredResolution;
        private Angle desiredLargestStructure;
        private UserSensitivity desiredSensitivity;
        private double reqContSensitivity;
        private UserSensitivity peakLineFlux;
        private UserSensitivity peakContFlux;
        private boolean isLineFluxSet = false;
        private boolean isContFluxSet = false;
        private boolean isContinuumFluxToBeUsed = false;
        private boolean isShowContRMSCalc = false;
        private UserSensitivity lineRMS;
        private double peakFluxSNR;

        public double getLineFluxSNR() {
            return this.peakLineFlux.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / this.lineRMS.getContentInUnits(TechnicalJustificationModel.SENSITIVITY_CALC_UNIT);
        }

        public double getBandwidthSensitivityInKMS() {
            return this.bandwidthSensitivityUser.getContentInUnits(TechnicalJustificationModel.FREQUENCY_CALC_UNIT);
        }

        public static void setTJDesiredResolution(TechnicalJustificationCalculations technicalJustificationCalculations, ScienceGoal scienceGoal) {
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            technicalJustificationCalculations.setSensitivityFlux(performanceParameters.getDesiredSensitivity().inFluxUnit());
            if (performanceParameters.isARModeRangeWithTemp()) {
                technicalJustificationCalculations.setDesiredResolution(SfiControlParameterModel.getAchieveableAngularResolutionForARRangeInKelvins(scienceGoal));
            } else {
                technicalJustificationCalculations.setDesiredResolution(performanceParameters.getDesiredAngularResolution());
            }
        }

        public static SNR calculateSourceWithPoorestSNR(@NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull ScienceGoal scienceGoal) {
            if (expectedPropertiesElements == null) {
                throw new NullPointerException("consolidatedExpectedProperties is marked non-null but is null");
            }
            if (technicalJustificationCalculations == null) {
                throw new NullPointerException("tjData is marked non-null but is null");
            }
            if (scienceGoal == null) {
                throw new NullPointerException("scienceGoal is marked non-null but is null");
            }
            SNR sNR = null;
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                UserSensitivity userSensitivity = expectedPropertiesElements.getAchievedSensitivities().get(targetParameters);
                UserSensitivity userSensitivity2 = TechnicalJustificationExpert.createUserSensitivityWithDefinedBeamsizeAndObsFreq((Angle)((Object)technicalJustificationCalculations.getDesiredResolution()), technicalJustificationCalculations.getRepresentativeFrequency());
                userSensitivity2.setContentAndUnit(userSensitivity);
                userSensitivity2.convertToUnit(userSensitivity2.getFriendlyUnit());
                if (sNR == null) {
                    sNR = new SNR(targetParameters, userSensitivity2, userSensitivity);
                    continue;
                }
                if (!sNR.getSnr().isGreaterThan((AbstractDoubleWithUnit)userSensitivity2)) continue;
                sNR.setSnr(userSensitivity2);
                sNR.setSource(targetParameters);
                sNR.setAchievedBWForSensitivity(userSensitivity);
            }
            if (sNR == null) {
                throw new RuntimeException("Unable to calculate the poorest SNR");
            }
            return sNR;
        }

        public static void setTJRepresentativeFreq(@NonNull TechnicalJustificationCalculations technicalJustificationCalculations, @NonNull ScienceGoal scienceGoal) {
            if (technicalJustificationCalculations == null) {
                throw new NullPointerException("tjData is marked non-null but is null");
            }
            if (scienceGoal == null) {
                throw new NullPointerException("scienceGoal is marked non-null but is null");
            }
            Frequency frequency = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset();
            technicalJustificationCalculations.setRepresentativeFrequency(frequency);
        }

        public ExpectedPropertiesElements getConsolidatedExpectedProperties() {
            return this.consolidatedExpectedProperties;
        }

        public boolean isSensitivityFlux() {
            return this.isSensitivityFlux;
        }

        public double getContSNR() {
            return this.contSNR;
        }

        public boolean isShowSNRLowWarning() {
            return this.isShowSNRLowWarning;
        }

        public UserFrequency getBandwidthSensitivityUser() {
            return this.bandwidthSensitivityUser;
        }

        public boolean isMayNotResolve() {
            return this.isMayNotResolve;
        }

        public double getThirdOfLineWidth() {
            return this.thirdOfLineWidth;
        }

        public double getFBWCalculationResult() {
            return this.fBWCalculationResult;
        }

        public boolean isLineWidthGreaterThanSPWWarningShown() {
            return this.isLineWidthGreaterThanSPWWarningShown;
        }

        public boolean isLineWidthSet() {
            return this.isLineWidthSet;
        }

        public boolean isDynamicRangeWarningShown() {
            return this.isDynamicRangeWarningShown;
        }

        public boolean isDynamicRangeShown() {
            return this.isDynamicRangeShown;
        }

        public double getMaxSpectralDynamicRange() {
            return this.maxSpectralDynamicRange;
        }

        public double getSpectralDynamicRange() {
            return this.spectralDynamicRange;
        }

        public boolean isWideBandwidthWarningRequired() {
            return this.isWideBandwidthWarningRequired;
        }

        public Optional<Speed> getRepresentativeWidthAsSpeed() {
            return this.representativeWidthAsSpeed;
        }

        public double getLineWidthInKMS() {
            return this.lineWidthInKMS;
        }

        public UserSensitivity getContinuumRMS() {
            return this.continuumRMS;
        }

        public Frequency getRepresentativeFrequency() {
            return this.representativeFrequency;
        }

        public UserAngle getDesiredResolution() {
            return this.desiredResolution;
        }

        public Angle getDesiredLargestStructure() {
            return this.desiredLargestStructure;
        }

        public UserSensitivity getDesiredSensitivity() {
            return this.desiredSensitivity;
        }

        public double getReqContSensitivity() {
            return this.reqContSensitivity;
        }

        public UserSensitivity getPeakLineFlux() {
            return this.peakLineFlux;
        }

        public UserSensitivity getPeakContFlux() {
            return this.peakContFlux;
        }

        public boolean isLineFluxSet() {
            return this.isLineFluxSet;
        }

        public boolean isContFluxSet() {
            return this.isContFluxSet;
        }

        public boolean isContinuumFluxToBeUsed() {
            return this.isContinuumFluxToBeUsed;
        }

        public boolean isShowContRMSCalc() {
            return this.isShowContRMSCalc;
        }

        public UserSensitivity getLineRMS() {
            return this.lineRMS;
        }

        public double getPeakFluxSNR() {
            return this.peakFluxSNR;
        }

        public void setConsolidatedExpectedProperties(ExpectedPropertiesElements expectedPropertiesElements) {
            this.consolidatedExpectedProperties = expectedPropertiesElements;
        }

        public void setSensitivityFlux(boolean bl) {
            this.isSensitivityFlux = bl;
        }

        public void setContSNR(double d) {
            this.contSNR = d;
        }

        public void setShowSNRLowWarning(boolean bl) {
            this.isShowSNRLowWarning = bl;
        }

        public void setBandwidthSensitivityUser(UserFrequency userFrequency) {
            this.bandwidthSensitivityUser = userFrequency;
        }

        public void setMayNotResolve(boolean bl) {
            this.isMayNotResolve = bl;
        }

        public void setThirdOfLineWidth(double d) {
            this.thirdOfLineWidth = d;
        }

        public void setFBWCalculationResult(double d) {
            this.fBWCalculationResult = d;
        }

        public void setLineWidthGreaterThanSPWWarningShown(boolean bl) {
            this.isLineWidthGreaterThanSPWWarningShown = bl;
        }

        public void setLineWidthSet(boolean bl) {
            this.isLineWidthSet = bl;
        }

        public void setDynamicRangeWarningShown(boolean bl) {
            this.isDynamicRangeWarningShown = bl;
        }

        public void setDynamicRangeShown(boolean bl) {
            this.isDynamicRangeShown = bl;
        }

        public void setMaxSpectralDynamicRange(double d) {
            this.maxSpectralDynamicRange = d;
        }

        public void setSpectralDynamicRange(double d) {
            this.spectralDynamicRange = d;
        }

        public void setWideBandwidthWarningRequired(boolean bl) {
            this.isWideBandwidthWarningRequired = bl;
        }

        public void setRepresentativeWidthAsSpeed(Optional<Speed> optional) {
            this.representativeWidthAsSpeed = optional;
        }

        public void setLineWidthInKMS(double d) {
            this.lineWidthInKMS = d;
        }

        public void setContinuumRMS(UserSensitivity userSensitivity) {
            this.continuumRMS = userSensitivity;
        }

        public void setRepresentativeFrequency(Frequency frequency) {
            this.representativeFrequency = frequency;
        }

        public void setDesiredResolution(UserAngle userAngle) {
            this.desiredResolution = userAngle;
        }

        public void setDesiredLargestStructure(Angle angle) {
            this.desiredLargestStructure = angle;
        }

        public void setDesiredSensitivity(UserSensitivity userSensitivity) {
            this.desiredSensitivity = userSensitivity;
        }

        public void setReqContSensitivity(double d) {
            this.reqContSensitivity = d;
        }

        public void setPeakLineFlux(UserSensitivity userSensitivity) {
            this.peakLineFlux = userSensitivity;
        }

        public void setPeakContFlux(UserSensitivity userSensitivity) {
            this.peakContFlux = userSensitivity;
        }

        public void setLineFluxSet(boolean bl) {
            this.isLineFluxSet = bl;
        }

        public void setContFluxSet(boolean bl) {
            this.isContFluxSet = bl;
        }

        public void setContinuumFluxToBeUsed(boolean bl) {
            this.isContinuumFluxToBeUsed = bl;
        }

        public void setShowContRMSCalc(boolean bl) {
            this.isShowContRMSCalc = bl;
        }

        public void setLineRMS(UserSensitivity userSensitivity) {
            this.lineRMS = userSensitivity;
        }

        public void setPeakFluxSNR(double d) {
            this.peakFluxSNR = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TechnicalJustificationCalculations)) {
                return false;
            }
            TechnicalJustificationCalculations technicalJustificationCalculations = (TechnicalJustificationCalculations)object;
            if (!technicalJustificationCalculations.canEqual(this)) {
                return false;
            }
            if (this.isSensitivityFlux() != technicalJustificationCalculations.isSensitivityFlux()) {
                return false;
            }
            if (Double.compare(this.getContSNR(), technicalJustificationCalculations.getContSNR()) != 0) {
                return false;
            }
            if (this.isShowSNRLowWarning() != technicalJustificationCalculations.isShowSNRLowWarning()) {
                return false;
            }
            if (this.isMayNotResolve() != technicalJustificationCalculations.isMayNotResolve()) {
                return false;
            }
            if (Double.compare(this.getThirdOfLineWidth(), technicalJustificationCalculations.getThirdOfLineWidth()) != 0) {
                return false;
            }
            if (Double.compare(this.getFBWCalculationResult(), technicalJustificationCalculations.getFBWCalculationResult()) != 0) {
                return false;
            }
            if (this.isLineWidthGreaterThanSPWWarningShown() != technicalJustificationCalculations.isLineWidthGreaterThanSPWWarningShown()) {
                return false;
            }
            if (this.isLineWidthSet() != technicalJustificationCalculations.isLineWidthSet()) {
                return false;
            }
            if (this.isDynamicRangeWarningShown() != technicalJustificationCalculations.isDynamicRangeWarningShown()) {
                return false;
            }
            if (this.isDynamicRangeShown() != technicalJustificationCalculations.isDynamicRangeShown()) {
                return false;
            }
            if (Double.compare(this.getMaxSpectralDynamicRange(), technicalJustificationCalculations.getMaxSpectralDynamicRange()) != 0) {
                return false;
            }
            if (Double.compare(this.getSpectralDynamicRange(), technicalJustificationCalculations.getSpectralDynamicRange()) != 0) {
                return false;
            }
            if (this.isWideBandwidthWarningRequired() != technicalJustificationCalculations.isWideBandwidthWarningRequired()) {
                return false;
            }
            if (Double.compare(this.getLineWidthInKMS(), technicalJustificationCalculations.getLineWidthInKMS()) != 0) {
                return false;
            }
            if (Double.compare(this.getReqContSensitivity(), technicalJustificationCalculations.getReqContSensitivity()) != 0) {
                return false;
            }
            if (this.isLineFluxSet() != technicalJustificationCalculations.isLineFluxSet()) {
                return false;
            }
            if (this.isContFluxSet() != technicalJustificationCalculations.isContFluxSet()) {
                return false;
            }
            if (this.isContinuumFluxToBeUsed() != technicalJustificationCalculations.isContinuumFluxToBeUsed()) {
                return false;
            }
            if (this.isShowContRMSCalc() != technicalJustificationCalculations.isShowContRMSCalc()) {
                return false;
            }
            if (Double.compare(this.getPeakFluxSNR(), technicalJustificationCalculations.getPeakFluxSNR()) != 0) {
                return false;
            }
            ExpectedPropertiesElements expectedPropertiesElements = this.getConsolidatedExpectedProperties();
            ExpectedPropertiesElements expectedPropertiesElements2 = technicalJustificationCalculations.getConsolidatedExpectedProperties();
            if (expectedPropertiesElements == null ? expectedPropertiesElements2 != null : !((Object)expectedPropertiesElements).equals(expectedPropertiesElements2)) {
                return false;
            }
            UserFrequency userFrequency = this.getBandwidthSensitivityUser();
            UserFrequency userFrequency2 = technicalJustificationCalculations.getBandwidthSensitivityUser();
            if (userFrequency == null ? userFrequency2 != null : !userFrequency.equals(userFrequency2)) {
                return false;
            }
            Optional<Speed> optional = this.getRepresentativeWidthAsSpeed();
            Optional<Speed> optional2 = technicalJustificationCalculations.getRepresentativeWidthAsSpeed();
            if (optional == null ? optional2 != null : !((Object)optional).equals(optional2)) {
                return false;
            }
            UserSensitivity userSensitivity = this.getContinuumRMS();
            UserSensitivity userSensitivity2 = technicalJustificationCalculations.getContinuumRMS();
            if (userSensitivity == null ? userSensitivity2 != null : !userSensitivity.equals(userSensitivity2)) {
                return false;
            }
            Frequency frequency = this.getRepresentativeFrequency();
            Frequency frequency2 = technicalJustificationCalculations.getRepresentativeFrequency();
            if (frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2)) {
                return false;
            }
            UserAngle userAngle = this.getDesiredResolution();
            UserAngle userAngle2 = technicalJustificationCalculations.getDesiredResolution();
            if (userAngle == null ? userAngle2 != null : !userAngle.equals(userAngle2)) {
                return false;
            }
            Angle angle = this.getDesiredLargestStructure();
            Angle angle2 = technicalJustificationCalculations.getDesiredLargestStructure();
            if (angle == null ? angle2 != null : !((Object)((Object)angle)).equals((Object)angle2)) {
                return false;
            }
            UserSensitivity userSensitivity3 = this.getDesiredSensitivity();
            UserSensitivity userSensitivity4 = technicalJustificationCalculations.getDesiredSensitivity();
            if (userSensitivity3 == null ? userSensitivity4 != null : !userSensitivity3.equals(userSensitivity4)) {
                return false;
            }
            UserSensitivity userSensitivity5 = this.getPeakLineFlux();
            UserSensitivity userSensitivity6 = technicalJustificationCalculations.getPeakLineFlux();
            if (userSensitivity5 == null ? userSensitivity6 != null : !userSensitivity5.equals(userSensitivity6)) {
                return false;
            }
            UserSensitivity userSensitivity7 = this.getPeakContFlux();
            UserSensitivity userSensitivity8 = technicalJustificationCalculations.getPeakContFlux();
            if (userSensitivity7 == null ? userSensitivity8 != null : !userSensitivity7.equals(userSensitivity8)) {
                return false;
            }
            UserSensitivity userSensitivity9 = this.getLineRMS();
            UserSensitivity userSensitivity10 = technicalJustificationCalculations.getLineRMS();
            return !(userSensitivity9 == null ? userSensitivity10 != null : !userSensitivity9.equals(userSensitivity10));
        }

        protected boolean canEqual(Object object) {
            return object instanceof TechnicalJustificationCalculations;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isSensitivityFlux() ? 79 : 97);
            long l = Double.doubleToLongBits(this.getContSNR());
            n = n * 59 + (int)(l >>> 32 ^ l);
            n = n * 59 + (this.isShowSNRLowWarning() ? 79 : 97);
            n = n * 59 + (this.isMayNotResolve() ? 79 : 97);
            long l2 = Double.doubleToLongBits(this.getThirdOfLineWidth());
            n = n * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getFBWCalculationResult());
            n = n * 59 + (int)(l3 >>> 32 ^ l3);
            n = n * 59 + (this.isLineWidthGreaterThanSPWWarningShown() ? 79 : 97);
            n = n * 59 + (this.isLineWidthSet() ? 79 : 97);
            n = n * 59 + (this.isDynamicRangeWarningShown() ? 79 : 97);
            n = n * 59 + (this.isDynamicRangeShown() ? 79 : 97);
            long l4 = Double.doubleToLongBits(this.getMaxSpectralDynamicRange());
            n = n * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = Double.doubleToLongBits(this.getSpectralDynamicRange());
            n = n * 59 + (int)(l5 >>> 32 ^ l5);
            n = n * 59 + (this.isWideBandwidthWarningRequired() ? 79 : 97);
            long l6 = Double.doubleToLongBits(this.getLineWidthInKMS());
            n = n * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = Double.doubleToLongBits(this.getReqContSensitivity());
            n = n * 59 + (int)(l7 >>> 32 ^ l7);
            n = n * 59 + (this.isLineFluxSet() ? 79 : 97);
            n = n * 59 + (this.isContFluxSet() ? 79 : 97);
            n = n * 59 + (this.isContinuumFluxToBeUsed() ? 79 : 97);
            n = n * 59 + (this.isShowContRMSCalc() ? 79 : 97);
            long l8 = Double.doubleToLongBits(this.getPeakFluxSNR());
            n = n * 59 + (int)(l8 >>> 32 ^ l8);
            ExpectedPropertiesElements expectedPropertiesElements = this.getConsolidatedExpectedProperties();
            n = n * 59 + (expectedPropertiesElements == null ? 43 : ((Object)expectedPropertiesElements).hashCode());
            UserFrequency userFrequency = this.getBandwidthSensitivityUser();
            n = n * 59 + (userFrequency == null ? 43 : userFrequency.hashCode());
            Optional<Speed> optional = this.getRepresentativeWidthAsSpeed();
            n = n * 59 + (optional == null ? 43 : ((Object)optional).hashCode());
            UserSensitivity userSensitivity = this.getContinuumRMS();
            n = n * 59 + (userSensitivity == null ? 43 : userSensitivity.hashCode());
            Frequency frequency = this.getRepresentativeFrequency();
            n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
            UserAngle userAngle = this.getDesiredResolution();
            n = n * 59 + (userAngle == null ? 43 : userAngle.hashCode());
            Angle angle = this.getDesiredLargestStructure();
            n = n * 59 + (angle == null ? 43 : ((Object)((Object)angle)).hashCode());
            UserSensitivity userSensitivity2 = this.getDesiredSensitivity();
            n = n * 59 + (userSensitivity2 == null ? 43 : userSensitivity2.hashCode());
            UserSensitivity userSensitivity3 = this.getPeakLineFlux();
            n = n * 59 + (userSensitivity3 == null ? 43 : userSensitivity3.hashCode());
            UserSensitivity userSensitivity4 = this.getPeakContFlux();
            n = n * 59 + (userSensitivity4 == null ? 43 : userSensitivity4.hashCode());
            UserSensitivity userSensitivity5 = this.getLineRMS();
            n = n * 59 + (userSensitivity5 == null ? 43 : userSensitivity5.hashCode());
            return n;
        }

        public String toString() {
            return "TechnicalJustificationExpert.TechnicalJustificationCalculations(consolidatedExpectedProperties=" + this.getConsolidatedExpectedProperties() + ", isSensitivityFlux=" + this.isSensitivityFlux() + ", contSNR=" + this.getContSNR() + ", isShowSNRLowWarning=" + this.isShowSNRLowWarning() + ", bandwidthSensitivityUser=" + this.getBandwidthSensitivityUser() + ", isMayNotResolve=" + this.isMayNotResolve() + ", thirdOfLineWidth=" + this.getThirdOfLineWidth() + ", fBWCalculationResult=" + this.getFBWCalculationResult() + ", isLineWidthGreaterThanSPWWarningShown=" + this.isLineWidthGreaterThanSPWWarningShown() + ", isLineWidthSet=" + this.isLineWidthSet() + ", isDynamicRangeWarningShown=" + this.isDynamicRangeWarningShown() + ", isDynamicRangeShown=" + this.isDynamicRangeShown() + ", maxSpectralDynamicRange=" + this.getMaxSpectralDynamicRange() + ", spectralDynamicRange=" + this.getSpectralDynamicRange() + ", isWideBandwidthWarningRequired=" + this.isWideBandwidthWarningRequired() + ", representativeWidthAsSpeed=" + this.getRepresentativeWidthAsSpeed() + ", lineWidthInKMS=" + this.getLineWidthInKMS() + ", continuumRMS=" + this.getContinuumRMS() + ", representativeFrequency=" + this.getRepresentativeFrequency() + ", desiredResolution=" + this.getDesiredResolution() + ", desiredLargestStructure=" + this.getDesiredLargestStructure() + ", desiredSensitivity=" + this.getDesiredSensitivity() + ", reqContSensitivity=" + this.getReqContSensitivity() + ", peakLineFlux=" + this.getPeakLineFlux() + ", peakContFlux=" + this.getPeakContFlux() + ", isLineFluxSet=" + this.isLineFluxSet() + ", isContFluxSet=" + this.isContFluxSet() + ", isContinuumFluxToBeUsed=" + this.isContinuumFluxToBeUsed() + ", isShowContRMSCalc=" + this.isShowContRMSCalc() + ", lineRMS=" + this.getLineRMS() + ", peakFluxSNR=" + this.getPeakFluxSNR() + ")";
        }
    }

    public static class SNR {
        private TargetParameters source;
        private UserSensitivity snr;
        private UserSensitivity achievedBWForSensitivity;

        public TargetParameters getSource() {
            return this.source;
        }

        public UserSensitivity getSnr() {
            return this.snr;
        }

        public UserSensitivity getAchievedBWForSensitivity() {
            return this.achievedBWForSensitivity;
        }

        public void setSource(TargetParameters targetParameters) {
            this.source = targetParameters;
        }

        public void setSnr(UserSensitivity userSensitivity) {
            this.snr = userSensitivity;
        }

        public void setAchievedBWForSensitivity(UserSensitivity userSensitivity) {
            this.achievedBWForSensitivity = userSensitivity;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SNR)) {
                return false;
            }
            SNR sNR = (SNR)object;
            if (!sNR.canEqual(this)) {
                return false;
            }
            TargetParameters targetParameters = this.getSource();
            TargetParameters targetParameters2 = sNR.getSource();
            if (targetParameters == null ? targetParameters2 != null : !targetParameters.equals(targetParameters2)) {
                return false;
            }
            UserSensitivity userSensitivity = this.getSnr();
            UserSensitivity userSensitivity2 = sNR.getSnr();
            if (userSensitivity == null ? userSensitivity2 != null : !userSensitivity.equals(userSensitivity2)) {
                return false;
            }
            UserSensitivity userSensitivity3 = this.getAchievedBWForSensitivity();
            UserSensitivity userSensitivity4 = sNR.getAchievedBWForSensitivity();
            return !(userSensitivity3 == null ? userSensitivity4 != null : !userSensitivity3.equals(userSensitivity4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SNR;
        }

        public int hashCode() {
            int n = 1;
            TargetParameters targetParameters = this.getSource();
            n = n * 59 + (targetParameters == null ? 43 : targetParameters.hashCode());
            UserSensitivity userSensitivity = this.getSnr();
            n = n * 59 + (userSensitivity == null ? 43 : userSensitivity.hashCode());
            UserSensitivity userSensitivity2 = this.getAchievedBWForSensitivity();
            n = n * 59 + (userSensitivity2 == null ? 43 : userSensitivity2.hashCode());
            return n;
        }

        public String toString() {
            return "TechnicalJustificationExpert.SNR(source=" + this.getSource() + ", snr=" + this.getSnr() + ", achievedBWForSensitivity=" + this.getAchievedBWForSensitivity() + ")";
        }

        public SNR(TargetParameters targetParameters, UserSensitivity userSensitivity, UserSensitivity userSensitivity2) {
            this.source = targetParameters;
            this.snr = userSensitivity;
            this.achievedBWForSensitivity = userSensitivity2;
        }
    }

    public static class TechnicalJustificationExpertBuilder {
        private ScienceGoal scienceGoal;
        private boolean targetMapping$set;
        private Optional<Map<String, SchedBlock>> targetMapping$value;

        TechnicalJustificationExpertBuilder() {
        }

        public TechnicalJustificationExpertBuilder scienceGoal(@NonNull ScienceGoal scienceGoal) {
            if (scienceGoal == null) {
                throw new NullPointerException("scienceGoal is marked non-null but is null");
            }
            this.scienceGoal = scienceGoal;
            return this;
        }

        public TechnicalJustificationExpertBuilder targetMapping(Optional<Map<String, SchedBlock>> optional) {
            this.targetMapping$value = optional;
            this.targetMapping$set = true;
            return this;
        }

        public TechnicalJustificationExpert build() {
            Optional<Map<String, SchedBlock>> optional = this.targetMapping$value;
            if (!this.targetMapping$set) {
                optional = TechnicalJustificationExpert.$default$targetMapping();
            }
            return new TechnicalJustificationExpert(this.scienceGoal, optional);
        }

        public String toString() {
            return "TechnicalJustificationExpert.TechnicalJustificationExpertBuilder(scienceGoal=" + this.scienceGoal + ", targetMapping$value=" + this.targetMapping$value + ")";
        }
    }
}

