/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.TotalPowerSBScienceTargetDistributor;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPRasterData;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class TotalPowerIntegrationTimeCalculator {
    private static final double tpMaxTOSPerSB_s = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();
    private static final double tpMaxTOSPerSpectralScanSB_s = AlmaPolicies.getInstance().getTpMaxTOSPerSpectralScanSB().getSecs();

    public static int getTPSBExecutionCount(@NonNull SchedBlock schedBlock2, @NonNull Time time, @NonNull ScienceGoal scienceGoal, @NonNull List<ObsUnitSet> list, @NonNull SchedBlock schedBlock3) throws WizardSBGenerationException, Exception {
        if (schedBlock2 == null) {
            throw new NullPointerException("totalPowerScienceSB is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("principalArrayTOS is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("ousContainingSGSchedBlocks is marked non-null but is null");
        }
        if (schedBlock3 == null) {
            throw new NullPointerException("aca7MSB is marked non-null but is null");
        }
        if (!schedBlock2.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("SB must be a TP science SB");
        }
        List<SchedBlock> list2 = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list2, list);
        list2 = list2.stream().filter(schedBlock -> schedBlock.isTotalPowerScienceSB()).toList();
        if (list2.isEmpty()) {
            throw new WizardSBGenerationException("Unable to find TP SBs when expected");
        }
        boolean bl = list2.size() > 1 || list2.stream().filter(schedBlock -> schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).size() > 1).findFirst().isPresent();
        Map<Target, Double> map = TotalPowerIntegrationTimeCalculator.calculateAreaMappingCorrectionFactors(schedBlock2, schedBlock3);
        int n = bl ? TotalPowerIntegrationTimeCalculator.getTPExecutionCountForMultipleSources(schedBlock2, scienceGoal, list, map) : TotalPowerIntegrationTimeCalculator.getTPExecutionCountForSingleSource(schedBlock2, time, scienceGoal, map);
        assert (n > 0);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static int getTPExecutionCountForMultipleSources(@NonNull SchedBlock schedBlock2, @NonNull ScienceGoal scienceGoal, @NonNull List<ObsUnitSet> list, @NonNull Map<Target, Double> map) throws WizardSBGenerationException, Exception {
        void var13_15;
        double d;
        if (schedBlock2 == null) {
            throw new NullPointerException("totalPowerScienceSB is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("ousContainingSGSchedBlocks is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("areaMappingGainFactors is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(arrayList, list);
        List<SchedBlock> list2 = arrayList.stream().filter(schedBlock -> schedBlock.getSbGenerationContext().getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M)).toList();
        List<Target> list3 = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter);
        Target target = list3.get(0);
        Optional<Object> optional = Optional.empty();
        SchedBlock schedBlock3 = null;
        for (SchedBlock object2 : list2) {
            optional = object2.getScienceTargets().stream().filter(target2 -> target2.getFieldSource().getSourceName().equals(target.getFieldSource().getSourceName())).findFirst();
            if (!optional.isPresent()) continue;
            schedBlock3 = object2;
            break;
        }
        assert (schedBlock3 != null);
        try {
            d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        assert (d > 0.0);
        int n = schedBlock3.getSchedBlockControl().getExecutionCount();
        Object var13_14 = null;
        double d2 = 0.0;
        for (Target target3 : list3) {
            Target target4 = schedBlock3.getScienceTargets().stream().filter(target2 -> target2.getFieldSource().getSourceName().equals(target.getFieldSource().getSourceName())).findFirst().orElseThrow(WizardSBGenerationException::new);
            double d3 = target4.getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException).getIntegrationTime().getSecs() * (double)n;
            assert (map.containsKey(target3));
            double d4 = d3 * d * map.get(target3);
            d2 += d4;
            if (var13_15 != null && !(d4 > var13_15.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s)) continue;
            ITOS iTOS = new ITOS(d4, target3, d3);
        }
        assert (var13_15 != null);
        double d5 = var13_15.tpScienceTarget.getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException).getIntegrationTime().getSecs();
        int n2 = (int)Math.ceil(var13_15.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s / d5);
        assert (n2 > 0);
        TotalPowerIntegrationTimeCalculator.reduceExcessITOS(d2, n2, schedBlock2);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(" minTotalTOSTPTimeNeeded_s=" + var13_15.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s / 60.0 + " (min) tpSBExecutionCount=" + n2 + " minTotalTOSTPTimeNeededForSource_s=" + var13_15.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s + " tpArrayTimeMultiplier=" + d + " itosOfTPSource_s : " + d5);
        return n2;
    }

    static int getTPExecutionCountForSingleSource(@NonNull SchedBlock schedBlock, @NonNull Time time, @NonNull ScienceGoal scienceGoal, @NonNull Map<Target, Double> map) {
        double d;
        double d2;
        if (schedBlock == null) {
            throw new NullPointerException("totalPowerScienceSB is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("principalArrayTOS is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("areaMappingGainFactors is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list.size() != 1) {
            throw new IllegalArgumentException("totalPowerScienceSB contains more than once science target");
        }
        try {
            d2 = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal, Configuration.ApplyACATP2bitScaling.ScalingApplied);
            d = ObservingTimeCalculator.getTotalTOSTimeForSB(schedBlock, true).getContentInUnits(Time.UNIT_S);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        assert (d2 > 0.0);
        assert (d > 0.0);
        Target target = list.get(0);
        double d3 = map.get(target);
        double d4 = ((Time)time.multiply(d2)).getSecs() * d3;
        int n = (int)Math.ceil(d4 / d);
        TotalPowerIntegrationTimeCalculator.reduceExcessITOS(d4, n, schedBlock);
        assert (n > 0);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine("principalArrayTOS=" + time + " minTotalTOSTPTimeNeeded_s=" + d4 / 60.0 + " (min) tpSBExecutionCount=" + n + " tosScheduledForSingleTPSBExec_s=" + d + " tpArrayTimeMultiplier=" + d2);
        return n;
    }

    private static void reduceExcessITOS(double d, int n, @NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("totalPowerScienceSB is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list.isEmpty()) {
            throw new WizardSBGenerationException("No science targets found");
        }
        double d2 = 0.0;
        try {
            d2 = ((Time)ObservingTimeCalculator.getTotalTOSTimeForSB(schedBlock, true).multiply(n)).getContentInUnits(Time.UNIT_S);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        boolean bl = false;
        do {
            HashSet hashSet = new HashSet();
            Map<ScienceParameters, IntTimeSource> map = list.stream().map(target -> target.getScienceParametersList()[0]).filter(scienceParameters -> {
                boolean bl = hashSet.contains(scienceParameters);
                if (!bl) {
                    hashSet.add(scienceParameters);
                }
                return !bl;
            }).collect(Collectors.toMap(scienceParameters -> scienceParameters, scienceParameters -> scienceParameters.getIntegrationTime()));
            HashSet<ScienceParameters> hashSet2 = new HashSet<ScienceParameters>();
            for (Target target2 : list) {
                for (ScienceParameters scienceParameters2 : target2.getScienceParametersCollection()) {
                    if (hashSet2.contains((Object)scienceParameters2)) continue;
                    TPRasterData tPRasterData = scienceParameters2.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("Unable to get TP raster data"));
                    IntTimeSource intTimeSource = (IntTimeSource)scienceParameters2.getIntegrationTime().minus((AbstractDoubleWithUnit)IntTimeSource.of(tPRasterData.getT_rect()));
                    scienceParameters2.setIntegrationTime(intTimeSource);
                    hashSet2.add(scienceParameters2);
                }
            }
            try {
                d2 = ((Time)ObservingTimeCalculator.getTotalTOSTimeForSB(schedBlock, true).multiply(n)).getContentInUnits(Time.UNIT_S);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            boolean bl2 = bl = d2 > d;
            if (bl) continue;
            map.entrySet().stream().forEach(entry -> ((ScienceParameters)((Object)((Object)entry.getKey()))).setIntegrationTime((IntTimeSource)((Object)((Object)entry.getValue()))));
        } while (bl);
        if (Log.logger(TotalPowerIntegrationTimeCalculator.class).fine()) {
            try {
                d2 = ((Time)ObservingTimeCalculator.getTotalTOSTimeForSB(schedBlock, true).multiply(n)).getContentInUnits(Time.UNIT_S);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            Log.logger(TotalPowerIntegrationTimeCalculator.class).fine("Revised itosForAllTPSBExec_s: " + d2 + " minTotalTOSTPTimeNeeded_s " + d);
        }
    }

    public static void adjustSourceRasterTimes(@NonNull SchedBlock schedBlock) throws UnknownEntityException {
        if (schedBlock == null) {
            throw new NullPointerException("tpSB is marked non-null but is null");
        }
        if (!schedBlock.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("Illegal argument: sb (" + schedBlock + ") did not pass the test: should be TP science SB");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal();
        if (scienceGoal.isSolarScienceGoal()) {
            return;
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list.size() == 1) {
            TotalPowerIntegrationTimeCalculator.applyNRepeatsForSingleSourceSB(list);
        } else {
            TotalPowerIntegrationTimeCalculator.scaleScienceParametersITOS(schedBlock);
        }
        if (Log.logger(TotalPowerSBScienceTargetDistributor.class).fine()) {
            List<Target> list2 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            HashSet hashSet = new HashSet();
            list2.stream().forEach(target -> target.getScienceParametersCollection().stream().filter(scienceParameters -> !hashSet.contains(scienceParameters)).forEach(scienceParameters -> {
                hashSet.add(scienceParameters);
                Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("SB name " + schedBlock.getName() + " ITOS reported " + scienceParameters.getIntegrationTime());
            }));
        }
    }

    private static void applyNRepeatsForSingleSourceSB(@NonNull List<Target> list) {
        if (list == null) {
            throw new NullPointerException("scienceTargets is marked non-null but is null");
        }
        if (list.size() != 1) {
            throw new IllegalArgumentException("Illegal argument: scienceTargets.size() (" + list.size() + ") did not pass the test: scienceTargets.size() != 1");
        }
        ScienceParameters scienceParameters = list.get(0).getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to locate raster data"));
        TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("Unable to locate TP raster data"));
        Time time = tPRasterData.getT_expectedTotalITOS();
        if (scienceParameters.getIntegrationTime().getTime().isLessThan((AbstractDoubleWithUnit)time)) {
            double d = scienceParameters.getIntegrationTime().getSecs();
            double d2 = time.getSecs() - d;
            if (d2 > 0.0) {
                double d3 = tPRasterData.getT_rect().getSecs();
                int n = (int)Math.floor(d2 / d3);
                scienceParameters.setIntegrationTime((IntTimeSource)scienceParameters.getIntegrationTime().plus((AbstractDoubleWithUnit)IntTimeSource.createIntTimeSource((double)(d3 * (double)n), (String)IntTimeSource.UNIT_S)));
            }
        }
    }

    private static Map<Target, Double> calculateAreaMappingCorrectionFactors(@NonNull SchedBlock schedBlock, @NonNull SchedBlock schedBlock2) {
        if (schedBlock == null) {
            throw new NullPointerException("tpScienceSB is marked non-null but is null");
        }
        if (schedBlock2 == null) {
            throw new NullPointerException("aca7mSB is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<Target> list2 = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter);
        assert (list != null && !list.isEmpty()) : "No TP science targets found";
        assert (list2 != null && !list2.isEmpty()) : "No ACA 7-m science targets found";
        HashMap<Target, Double> hashMap = new HashMap<Target, Double>();
        Frequency frequency = schedBlock2.getSchedulingConstraints().getRepresentativeFrequency();
        assert (frequency != null);
        double d = Antenna.ANTENNA_7M.getBeamArea(frequency).getArcsec();
        for (Target target : list) {
            Target target3 = list2.stream().filter(target2 -> target2.getFieldSource().getSourceName().equals(target.getFieldSource().getSourceName())).findFirst().orElseThrow(() -> new WizardSBGenerationException("Unable to find the counterpart target in the ACA 7-m SB"));
            if (target3.getFieldSource().getFieldPattern().getNumberOfPointings() == 1) {
                FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
                if (!fieldPattern.isRectanglePattern()) {
                    throw new WizardSBGenerationException("TP field pattern should be a rectangle");
                }
                RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldPattern);
                double d2 = rectanglePattern.getLatitudeLength().getArcsec() * rectanglePattern.getLongitudeLength().getArcsec();
                double d3 = d2 / d;
                Log.logger(TotalPowerIntegrationTimeCalculator.class).fine("tp7mMappingAreaRatio: " + d3);
                hashMap.put(target, 1.0);
                continue;
            }
            hashMap.put(target, 1.0);
        }
        return hashMap;
    }

    static void scaleScienceParametersITOS(@NonNull SchedBlock schedBlock) {
        double d;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        double d2 = d = schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) ? tpMaxTOSPerSpectralScanSB_s : tpMaxTOSPerSB_s;
        while (TotalPowerIntegrationTimeCalculator.isScalingITOSPermissible(list, d)) {
            HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
            for (Target target : list) {
                ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("No science parameters found when expected"));
                if (hashSet.contains((Object)scienceParameters)) continue;
                TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("Unable to fetch TP raster data"));
                Time time = scienceParameters.getIntegrationTime().getTime();
                time = ((Time)time.plus((AbstractDoubleWithUnit)tPRasterData.getT_rect())).adjustToIntegerMultipleOf(tPRasterData.getT_rect());
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time.getSecs(), (String)IntTimeSource.UNIT_S));
                hashSet.add(scienceParameters);
            }
        }
    }

    private static boolean isScalingITOSPermissible(@NonNull List<Target> list, double d) {
        if (list == null) {
            throw new NullPointerException("allScienceTargets is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: allScienceTargets.size() (" + list.size() + ") did not pass the test: allScienceTargets.size() < 1");
        }
        double d2 = 0.0;
        for (Target target : list) {
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("No science parameters found when expected"));
            TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("No TP raster data found for science parameters"));
            d2 += scienceParameters.getIntegrationTime().getSecs() + tPRasterData.getT_rect().getSecs();
        }
        boolean bl = d2 <= d;
        Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("isScalingPermissible: " + bl + " scaledTotalITOS: " + d2 + " maxITOSPerSBExec_s " + d);
        return bl;
    }

    public String toString() {
        return "TotalPowerIntegrationTimeCalculator()";
    }

    public static class ITOS {
        private double tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s;
        private Target tpScienceTarget;
        private double principalArrayTotalSourceITOS_s;

        public String toString() {
            return "TotalPowerIntegrationTimeCalculator.ITOS(tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s=" + this.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s + ", tpScienceTarget=" + this.tpScienceTarget + ", principalArrayTotalSourceITOS_s=" + this.principalArrayTotalSourceITOS_s + ")";
        }

        public ITOS(double d, Target target, double d2) {
            this.tpScienceTargetTotalITOSIncludingAreaCorrectionFactor_s = d;
            this.tpScienceTarget = target;
            this.principalArrayTotalSourceITOS_s = d2;
        }
    }
}

