/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.logging.Level;
import lombok.NonNull;

public class BandpassCalIntermediateTarget
extends AbstractIntermediateTarget {
    private static final ObsType intent = ObsType.BANDPASS;

    public BandpassCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        this.sbContext = sBGenerationContext;
        this.setObservingGroupManager(observingGroupManager);
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
            Integer n2 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, sBGenerationContext);
            this.completeTargetConstruction(target, target2, spectralSetupParameters, sBGenerationContext, targetWithIntent);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            this.assignMultipleVelocitySourceTargetsToObservingGroups(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n);
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            this.createBandpassCalibratorsForSpectralScans(targetWithIntent, spectralSetupParameters, observingGroupManager, sBGenerationContext);
        } else {
            throw new UnsupportedOperationException("Unknown SB schema specified " + enumSet);
        }
        this.setTargetPriority(3);
    }

    private void createBandpassCalibratorsForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, ObservingGroupManager observingGroupManager, SBGenerationContext sBGenerationContext) {
        Integer n = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        try {
            spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, sBGenerationContext);
                Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, sBGenerationContext);
                this.completeTargetConstruction(target2, target, spectralSetupParameters2, sBGenerationContext, targetWithIntent);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to create a bandpass intermediate target ", (Throwable)exception);
        }
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (ReceiverBand.isReceiverBandInSet(receiverBand, 1, 2, 3, 4, 6)) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (ReceiverBand.isReceiverBandInSet(receiverBand, 7, 8, 9, 10)) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (receiverBand.getNumber() == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)20.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m TDM and receiver band " + receiverBand);
        }
        return time;
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        return Time.createTime((double)5.0, (String)Time.UNIT_MIN);
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (ReceiverBand.isReceiverBandInSet(receiverBand, 1, 2, 3, 4, 6)) {
            time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
        } else if (ReceiverBand.isReceiverBandInSet(receiverBand, 9, 8)) {
            time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
        } else if (receiverBand.getNumber() == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (receiverBand.getNumber() == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                assert (atmosphericWindow != null);
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new WizardSBGenerationException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)20.0, (String)Time.UNIT_MIN);
            }
        } else if (receiverBand.getNumber() == 10) {
            time = Time.createTime((double)30.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m FDM and receiver band " + receiverBand);
        }
        return time;
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (ReceiverBand.isReceiverBandInSet(receiverBand, 1, 2, 3, 4, 6)) {
            time = Time.createTime((double)5.0, (String)Time.UNIT_MIN);
        } else if (ReceiverBand.isReceiverBandInSet(receiverBand, 8, 9)) {
            time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
        } else if (receiverBand.getNumber() == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (receiverBand.getNumber() == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            }
        } else if (receiverBand.getNumber() == 10) {
            time = Time.createTime((double)15.0, (String)Time.UNIT_MIN);
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 12m FDM and receiver band " + receiverBand);
        }
        return time;
    }

    private void completeTargetConstruction(@NonNull Target target, @NonNull Target target2, @NonNull SpectralSetupParameters spectralSetupParameters, SBGenerationContext sBGenerationContext, TargetWithIntent targetWithIntent) {
        if (target == null) {
            throw new NullPointerException("bpSpecTarget is marked non-null but is null");
        }
        if (target2 == null) {
            throw new NullPointerException("scienceSpecTarget is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        Velocity velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, ObsType.SCIENCE, Optional.of(targetWithIntent));
        target2.setSpectralSpec(spectralSpec);
        this.targets.add(target2);
        arrayList.add(target2);
        for (BandpassCalParameters bandpassCalParameters : target2.getBandpassCalParametersList()) {
            Time time = null;
            try {
                boolean bl = !spectralSetupParameters.isPureTDM();
                time = this.determineIntegrationTimes(bl, spectralSetupParameters, sBGenerationContext.getArray());
                bandpassCalParameters.setDefaultIntegrationTime(time);
                bandpassCalParameters.setBandPassSubtype(Optional.of(BandpassCalParameters.BandpassSubType.DGCScienceBandPass));
            }
            catch (IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException integrationTimeUndeterminedException) {
                this.logger.warning("Unable to determine integration time for science bandpass calibration " + integrationTimeUndeterminedException.getMessage() + " reverting to default");
            }
            bandpassCalParameters.setName("BandpassCalParameters (" + target2.getSpectralSpec().getName() + ")");
        }
        boolean bl = sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC);
        int n = sBGenerationContext.getGoal().getCalibrationSetupParameters().getIsDGCOverride() ? 1 : 0;
        if (bl && n == 0) {
            velocity = spectralSetupParameters.getSourceVelocity().deepCopy();
            target.setSpectralSpec(spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, intent, Optional.of(targetWithIntent)));
            for (BandpassCalParameters bandpassCalParameters : target.getBandpassCalParametersList()) {
                SpectralSpec spectralSpec2 = target.getSpectralSpec();
                bandpassCalParameters.setName("BandpassCalParameters (" + spectralSpec2.getName() + ")");
                try {
                    boolean bl2 = sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
                    boolean bl3 = !spectralSpec2.isPureTDM() && bl2;
                    bandpassCalParameters.setDefaultIntegrationTime(this.determineIntegrationTimes(bl3, spectralSetupParameters, sBGenerationContext.getArray()));
                    bandpassCalParameters.setBandPassSubtype(Optional.of(BandpassCalParameters.BandpassSubType.DGCReferenceBandPass));
                }
                catch (IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException integrationTimeUndeterminedException) {
                    this.logger.warning("Unable to determine integration time for science bandpass calibration " + integrationTimeUndeterminedException.getMessage() + " reverting to default");
                    bandpassCalParameters.setDefaultIntegrationTime(Time.createTime((double)1.0, (String)Time.UNIT_MIN));
                }
            }
            for (BandpassCalParameters bandpassCalParameters : target2.getBandpassCalParametersList()) {
                bandpassCalParameters.setName("BandpassCalParameters (" + target2.getSpectralSpec().getName() + ")");
            }
            target.setFieldSource(target2.getFieldSource());
            this.targets.add(target);
            arrayList.add(target);
        }
        for (Target target3 : arrayList) {
            OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
            orderedTarget.setTarget(target3);
            this.orderedTargets.add(orderedTarget);
        }
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
        Integer n2 = observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n);
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, this.sbContext);
        Target target2 = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n2, this.sbContext);
        this.completeTargetConstruction(target2, target, spectralSetupParameters, this.sbContext, targetWithIntent);
    }
}

