/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AmplitudeCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.BandpassCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.CheckSourceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.DGCReferenceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.DGCScienceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.DelayCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.FocusCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PointingCalForCalGroupIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PointingCalForScienceGroupIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PolarizationCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ScienceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.SidebandRatioCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.IntStream;
import lombok.NonNull;

public class IntermediateTargetFactory {
    private IntermediateTargetFactory() {
    }

    public static Collection<IntermediateTarget> getIntermediateTarget(@NonNull ScienceGoal scienceGoal, @NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull ObservingGroupManager observingGroupManager, @NonNull Integer n, @NonNull SBGenerationContext sBGenerationContext) {
        if (scienceGoal == null) {
            throw new NullPointerException("parentScienceGoal is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningGroup is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        switch (targetWithIntent.getObsType()) {
            case AMPLITUDE: {
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.ACA_TP)) {
                    arrayList.add(new AmplitudeCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext));
                } else {
                    arrayList.add(new AmplitudeCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.CALIBRATOR, enumSet, sBGenerationContext));
                }
                return arrayList;
            }
            case ATMOSPHERIC: {
                return arrayList;
            }
            case BANDPASS: {
                arrayList.add(new BandpassCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case DELAY: {
                arrayList.add(new DelayCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case CHECKSOURCE: {
                arrayList.add(new CheckSourceIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case FOCUS: {
                arrayList.add(new FocusCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case PHASE: {
                arrayList.add(new PhaseCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case POINTING: {
                IntermediateTargetFactory.addPointingsForCalibratorGroup(scienceGoal, targetWithIntent, spectralSetupParameters, observingGroupManager, n, sBGenerationContext, arrayList);
                IntermediateTargetFactory.addPointingsForScienceGroups(scienceGoal, targetWithIntent, spectralSetupParameters, observingGroupManager, n, sBGenerationContext, arrayList);
                return arrayList;
            }
            case POLARIZATION: {
                if (!sBGenerationContext.isVLBI()) {
                    arrayList.add(new PolarizationCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, enumSet, ObservingGroupManager.ObservingGroupType.CALIBRATOR.getNominalObservingGroup(), sBGenerationContext, ObservingGroupManager.ObservingGroupType.CALIBRATOR));
                }
                arrayList.add(new PolarizationCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case DGCREFERENCE: {
                arrayList.add(new DGCReferenceIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case DGCSCIENCE: {
                arrayList.add(new DGCScienceIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case SCIENCE: {
                arrayList.add(new ScienceIntermediateTarget(scienceGoal, targetWithIntent, spectralSetupParameters, observingGroupManager, n, sBGenerationContext));
                return arrayList;
            }
            case SIDEBANDRATIO: {
                arrayList.add(new SidebandRatioCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
        }
        throw new UnsupportedOperationException("Could not generate intermediate target with parameters set to target='" + targetWithIntent + "', ssp='" + spectralSetupParameters + "', array='" + requestedArray + "'.");
    }

    private static void addPointingsForScienceGroups(@NonNull ScienceGoal scienceGoal, @NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ObservingGroupManager observingGroupManager, int n2, @NonNull SBGenerationContext sBGenerationContext, @NonNull Collection<IntermediateTarget> collection) {
        if (scienceGoal == null) {
            throw new NullPointerException("parentScienceGoal is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        RequestedArray requestedArray = sBGenerationContext.getArray();
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        boolean bl = requestedArray.isTP();
        boolean bl2 = scienceGoal.isSpectralScan();
        if (!sBGenerationContext.isVLBI()) {
            if (bl && bl2) {
                try {
                    Integer n3 = spectralSetupParameters.getSpectralScan().getTunings().getNumberOfTunings();
                    IntStream.range(1, 1 + n3).forEach(n -> collection.add(new PointingCalForScienceGroupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext)));
                }
                catch (UnableToFindSolutionException unableToFindSolutionException) {
                    throw new WizardSBGenerationException("Unable to establish spectral scan tunings" + unableToFindSolutionException.getMessage());
                }
            } else {
                collection.add(new PointingCalForScienceGroupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n2, enumSet, sBGenerationContext));
            }
        }
    }

    private static void addPointingsForCalibratorGroup(@NonNull ScienceGoal scienceGoal, @NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ObservingGroupManager observingGroupManager, int n, @NonNull SBGenerationContext sBGenerationContext, @NonNull Collection<IntermediateTarget> collection) {
        boolean bl;
        if (scienceGoal == null) {
            throw new NullPointerException("parentScienceGoal is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (observingGroupManager == null) {
            throw new NullPointerException("observingGroupManager is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        RequestedArray requestedArray = sBGenerationContext.getArray();
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        boolean bl2 = requestedArray.isTP();
        boolean bl3 = scienceGoal.isSpectralScan();
        boolean bl4 = bl = !bl2 || bl3 && n == 1;
        if (bl) {
            collection.add(new PointingCalForCalGroupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
        }
    }
}

