/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ReceiverCalibrationParameters;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationConfigurationHelper;
import alma.obsprep.services.generator.refactored.obsparams.ScienceGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationParametersException;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

public class PhaseCalIntermediateTarget
extends StandardCalIntermediateTarget
implements IntegrationTimeResolverInterface {
    public static final Collection<ReceiverBand> HIGHBANDS = List.of(ReceiverBand.getReceiverBand(8), ReceiverBand.getReceiverBand(9), ReceiverBand.getReceiverBand(10));
    private static final double CHECKSOURCE_AR_THRESHOLD_ARCSEC = 0.25;

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n) {
        block5: {
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
            try {
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
                    int n2 = 1;
                    for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                        SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                        this.sspsDerivedFromSpectralScanTuning.add(spectralSetupParameters2);
                        Integer n3 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n2);
                        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n3, this.sbContext);
                        this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
                        if (this.isCheckSourceNeeded(spectralSetupParameters2, requestedArray, this.sbContext, targetWithIntent.isDependentTargetsMandated())) {
                            this.createCheckSource(targetWithIntent, spectralSetupParameters2, requestedArray, n3, this.sbContext);
                        }
                        ++n2;
                    }
                    break block5;
                }
                throw new WizardSBGenerationException("Unexpected spectral scan generation mode detected " + enumSet);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                Log.Logger logger = Log.logger((Object)this);
                logger.log(Level.WARNING, "Failed to add spectral scan tunings ", (Throwable)exception);
            }
        }
    }

    public PhaseCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.PHASE, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        this.setTargetPriority(2);
        boolean bl = VLBIExpert.isPassivePhasingEnabled(sBGenerationContext.getGoal());
        if (bl) {
            this.setPassivePhasingParameters(targetWithIntent);
        }
        if (!enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) && this.isCheckSourceNeeded(spectralSetupParameters, requestedArray, sBGenerationContext, targetWithIntent.isDependentTargetsMandated())) {
            if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n), sBGenerationContext);
            } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1), sBGenerationContext);
            } else {
                throw new WizardSBGenerationException("Unknown SB generation schema type detected " + enumSet);
            }
        }
    }

    private void setPassivePhasingParameters(@NonNull TargetWithIntent targetWithIntent) {
        if (targetWithIntent == null) {
            throw new NullPointerException("phaseTarget is marked non-null but is null");
        }
        this.getTargets().stream().filter(target -> !(targetWithIntent instanceof QuerySource) && targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                phaseCalParameters.setSubScanDuration(Time.createTimeSec(16.128));
                phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(4.0));
            }
            FieldSource fieldSource = target.getFieldSource();
            fieldSource.setName("VLBI Phasor");
        });
    }

    private void createCheckSource(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n, SBGenerationContext sBGenerationContext) {
        ReceiverCalibrationParameters receiverCalibrationParameters;
        CalibrationConfigurationHelper calibrationConfigurationHelper;
        Configuration configuration;
        Object object;
        Object object2;
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_CHECKSOURCE);
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        boolean bl = false;
        if (targetWithIntent instanceof QuerySource) {
            object2 = (QuerySource)targetWithIntent;
            querySource.setQueryCenter(object2.getQueryCenter().deepCopy());
            bl = true;
        } else if (targetWithIntent instanceof CalibrationTargetParameters) {
            object = (CalibrationTargetParameters)targetWithIntent;
            querySource.setQueryCenter(object.getSourceCoordinates().deepCopy());
        }
        object2 = TargetCreator.createTarget(querySource, spectralSetupParameters, n, sBGenerationContext);
        object2.getFieldSource().setName("Check source");
        object = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = ((SpectralSpecFactory)object).getSpectralSpec(spectralSetupParameters, spectralSetupParameters.getSourceVelocity(), ObsType.SCIENCE, Optional.of(targetWithIntent));
        ((Target)object2).setSpectralSpec(spectralSpec);
        if (sBGenerationContext.isTM1SB()) {
            try {
                configuration = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for phase cal setup: " + exception.getMessage());
            }
        } else if (sBGenerationContext.is7mSB()) {
            try {
                configuration = Configuration.getACAConfiguration();
            }
            catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                throw new WizardSBGenerationException("Unable to determine ACA 7-m configuration for phase cal setup: " + unableToDetermineConfigurationException.getMessage());
            }
        } else {
            configuration = sBGenerationContext.getConfiguration();
        }
        boolean bl2 = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
        try {
            calibrationConfigurationHelper = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            throw new WizardSBGenerationException("Cannot access the calibration configuration XML data " + throwable.getMessage());
        }
        CorrelatorType correlatorType = spectralSpec.isBLSpectralSpec() ? CorrelatorType.BL : CorrelatorType.ACA;
        int n2 = spectralSpec.getReceiverBand().getNumber();
        try {
            receiverCalibrationParameters = calibrationConfigurationHelper.getCalibrationParameters(configuration, ObsType.CHECKSOURCE, correlatorType, n2, bl2);
        }
        catch (UnableToDetermineCalibrationParametersException unableToDetermineCalibrationParametersException) {
            String string = String.format("Unable to find check source calibration parameters for %s/%s/rxb %d", new Object[]{configuration.getName(), correlatorType, n2});
            Log.logger(PhaseCalIntermediateTarget.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        for (Target target : this.targets) {
            HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(target.getIntendedObservingGroupList()));
            if (!target.hasPhaseCalParameters() || !hashSet.contains(n)) continue;
            PhaseCalParameters phaseCalParameters = target.getPhaseCalParametersList()[0];
            for (CheckSourceCalParameters checkSourceCalParameters : ((Target)object2).getCheckSourceCalParametersList()) {
                checkSourceCalParameters.setName("Check source parameters");
                checkSourceCalParameters.setDataOrigin(phaseCalParameters.getDataOrigin());
                ScienceGoalObservingParametersFactory scienceGoalObservingParametersFactory = new ScienceGoalObservingParametersFactory(sBGenerationContext.getGoal(), spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
                checkSourceCalParameters.setDefaultIntegrationTime(CalibrationConfigurationHelper.getTime(receiverCalibrationParameters.getIntegrationDuration()));
                checkSourceCalParameters.setSubScanDuration(scienceGoalObservingParametersFactory.getAlignedSubscanDuration(CalibrationConfigurationHelper.getTime(receiverCalibrationParameters.getSubscanDuration()).getSecs()));
            }
            FieldSource fieldSource = target.getFieldSource().deepCopy();
            fieldSource.setName("Check");
            object2.setFieldSource(fieldSource);
            if (!bl) break;
            fieldSource.getQuerySource().setSearchRadius(CalibrationConfigurationHelper.getAngle(receiverCalibrationParameters.getSeparationAngle()));
            break;
        }
        this.targets.add(object2);
        Object object4 = OrderedTarget.createOrderedTarget();
        object4.setTarget((Target)object2);
        this.orderedTargets.add(object4);
    }

    boolean isCheckSourceNeeded(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull SBGenerationContext sBGenerationContext, boolean bl) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (requestedArray.isTP() || sBGenerationContext.isVLBI() && !bl) {
            return false;
        }
        if (bl) {
            return true;
        }
        if (HIGHBANDS.contains(spectralSetupParameters.getReceiverBand())) {
            return true;
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        boolean bl2 = sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
        if (bl2 && SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            return true;
        }
        if (requestedArray.isACA7M()) {
            return false;
        }
        assert (RequestedArray.TWELVE_M.equals((Object)requestedArray));
        SBGeneratorTemplate.SchedBlockType schedBlockType = sBGenerationContext.getSBType();
        assert (EnumSet.of(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).contains((Object)schedBlockType)) : "Should only be 12-m SBs at this point";
        boolean bl3 = scienceGoal.getCalibrationSetupParameters().isEnhancedAstrometry();
        if (schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION) && bl3) {
            return true;
        }
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        schedBlock.setSbGenerationContext(sBGenerationContext);
        AngularResolutionLimitsExpertInterface angularResolutionLimitsExpertInterface = AngularResolutionLimitsExpertFactory.getARLimitsExpert(schedBlockType);
        angularResolutionLimitsExpertInterface.setARLimitsInSBConstraints(scienceGoal, List.of(List.of(schedBlock)));
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        return schedulingConstraints.getMinAcceptableAngResolution().getArcsec() < 0.25 || schedulingConstraints.getMaxAcceptableAngResolution().getArcsec() < 0.25;
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP FDM calibration times are as yet unknown");
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 7) {
            try {
                AtmosphericWindow atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                switch (atmosphericWindow) {
                    case GHZ321: 
                    case GHZ365: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
                return Time.createTime((double)2.0, (String)Time.UNIT_MIN);
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                // empty catch block
            }
        }
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7-m FDM and receiver band " + n);
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP calibration times are as yet undetermined");
    }
}

