/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Optional;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class ObservatoryGoalSpectralSpecWorker {
    private final CorrelatorExpert correxp = CorrelatorExpert.getBLInstance();
    private final SpectralSetupParameters setupParameters;
    private final Time integrationTime;

    public ObservatoryGoalSpectralSpecWorker(SpectralSetupParameters spectralSetupParameters, Time time) {
        this.setupParameters = spectralSetupParameters;
        this.integrationTime = time;
    }

    public SpectralSpec getSpectralSpec() throws WizardSBGenerationException {
        SpectralSpec spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(Optional.empty());
        this.configure(spectralSpec);
        return spectralSpec;
    }

    private void configure(SpectralSpec spectralSpec) {
        this.configure(spectralSpec.getCorrelatorConfiguration());
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        this.configure(frequencySetup);
        Frequency frequency = frequencySetup.getRestFrequency();
        ReceiverBand receiverBand = this.getReceiverBand(frequency);
        spectralSpec.setReceiverType(receiverBand.getType());
        spectralSpec.setName("Setup for " + frequencySetup.getTransitionName());
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        double d = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
        double d3 = this.correxp.calcSubscanDuration(d2, d, null);
    }

    private ReceiverBand getReceiverBand(Frequency frequency) {
        ReceiverBand receiverBand = null;
        try {
            receiverBand = this.setupParameters.getReceiverBand();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.warning(null, illegalArgumentException.getMessage());
            throw new WizardSBGenerationException(illegalArgumentException.getMessage());
        }
        if (receiverBand == null) {
            GUIUtilities.warning(null, "Unable to determine the receiver band");
            throw new WizardSBGenerationException("Unable to determine the receiver band");
        }
        return receiverBand;
    }

    private void configure(FrequencySetup frequencySetup) {
        Object object;
        Frequency frequency = null;
        String string = this.setupParameters.getType();
        if (string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            throw new RuntimeException("Spectral Window Type is not supported : " + string);
        }
        ScienceSpectralWindow scienceSpectralWindow = this.setupParameters.getScienceSpectralWindow(0);
        frequency = scienceSpectralWindow.getCenterFrequency();
        if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            object = scienceSpectralWindow.getTransitionName();
            frequencySetup.setTransitionName((String)object);
        }
        if ((object = this.setupParameters.getReceiverBand()) == null) {
            throw new WizardSBGenerationException("Unable to determine receiver band");
        }
        frequencySetup.setReceiverBand(((ReceiverBand)object).getName());
        frequencySetup.setRestFrequency(frequency.deepCopy());
    }

    public void configure(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        if (this.setupParameters.isSingleContinuum()) {
            this.setupSingleContinuumBasebands(abstractCorrelatorConfiguration);
        } else {
            this.setupBasebands(abstractCorrelatorConfiguration);
        }
        BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
        Time time = Time.createTime((double)this.correxp.calcDumpDurationInmsecs(), (String)Time.UNIT_MS);
        bLCorrelatorConfiguration.setDumpDuration(time);
        double d = bLCorrelatorConfiguration.getDumpDuration().getContentInUnits(Time.UNIT_MS);
        double d2 = bLCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_MS);
        double d3 = Math.ceil(d2 / d) * d;
        Time time2 = Time.createTime((double)d3, (String)Time.UNIT_MS);
        bLCorrelatorConfiguration.setIntegrationDuration(time2);
        double d4 = bLCorrelatorConfiguration.getChannelAverageDuration().getContentInUnits(Time.UNIT_MS);
        int n = (int)Math.ceil(d4 / d);
        if (n % 2 != 0) {
            ++n;
        }
        Time time3 = Time.createTime((double)((double)n * d), (String)Time.UNIT_MS);
        bLCorrelatorConfiguration.setChannelAverageDuration(time3);
    }

    protected void setupSingleContinuumBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) throws IllegalArgumentException {
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(this.setupParameters.getCorrPolarization());
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(this.setupParameters.getSoleFrequency(), Velocity.createVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY);
        Range<Frequency>[] rangeArray = singleContinuumExpert.calculateSingleContinuumBasebands(true);
        for (int i = 0; i < 4; ++i) {
            Frequency frequency = rangeArray[i].mid();
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency);
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.publishCorrConfigMode();
        }
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        spectralSpec.calculateCorrelatorSetup(this.setupParameters.getSourceVelocity());
        spectralSpec.getCorrelatorConfiguration().updateSideband();
    }

    protected void setupBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        int n;
        Object object;
        Object object2;
        Velocity velocity = this.setupParameters.getSourceVelocity();
        try {
            object2 = new BaseBandDeployer(this.setupParameters);
            Frequency[] frequencyArray = ((BaseBandDeployer)object2).getAdjustedBaseBandCenterFrequenciesRest();
            object = BaseBandSpecification.getKnownBaseBandNameList();
            for (n = 0; n < frequencyArray.length; ++n) {
                if (frequencyArray[n].isEqual((AbstractDoubleWithUnit)BaseBandDeployer.dummyFrequency)) continue;
                AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
                abstractBaseBandConfig.setCenterFrequency(frequencyArray[n]);
                abstractBaseBandConfig.setBaseBandName((String)object[n]);
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new WizardSBGenerationException(baseBandNotDeployableException);
        }
        try {
            object2 = this.setupParameters.getGroupIndexSet();
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            invalidGroupIndexException.printStackTrace();
            throw new WizardSBGenerationException(invalidGroupIndexException);
        }
        object = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        ((SpectralSpec)object).calculateCorrelatorSetup(velocity);
        n = 0;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            ScienceSpectralWindow[] scienceSpectralWindowArray;
            int n2 = (Integer)iterator.next();
            for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray = this.setupParameters.getScienceSpectralWindowGroup(n2)) {
                AbstractSpectralWindow abstractSpectralWindow = this.addNewSpectralWindow(abstractCorrelatorConfiguration.getBaseBandConfig(n), scienceSpectralWindow);
                abstractSpectralWindow.setCorrConfigMode(scienceSpectralWindow.getCorrConfigMode());
                abstractSpectralWindow.publishCorrConfigMode();
            }
            ++n;
        }
    }

    private AbstractBaseBandConfig addNewBaseBandConfig(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        SpectralSpec spectralSpec = abstractCorrelatorConfiguration.getSpectralSpec();
        AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.addNewBaseBand().getBaseBandConfig();
        this.configure(abstractBaseBandConfig);
        return abstractBaseBandConfig;
    }

    private void configure(AbstractBaseBandConfig abstractBaseBandConfig) {
        abstractBaseBandConfig.setDataProducts(AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractBaseBandConfig.setSwitchingType(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
    }

    protected AbstractSpectralWindow addNewSpectralWindow(AbstractBaseBandConfig abstractBaseBandConfig, ScienceSpectralWindow scienceSpectralWindow) {
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        abstractSpectralWindow.setEffectiveBandwidth(frequency);
        abstractSpectralWindow.setEffectiveNumberOfChannels(7680);
        abstractSpectralWindow.setAssociatedSpectralWindowNumberInPair(0);
        String string = this.setupParameters.getPolarisation();
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(string);
        abstractSpectralWindow.setPolnProducts(corrPolarization.polnProducts);
        String string2 = this.setupParameters.getType();
        Velocity velocity = this.setupParameters.getSourceVelocity();
        Frequency[] frequencyArray = abstractSpectralWindow.getBaseBandConfig().getLOFrequencies();
        Frequency frequency2 = frequencyArray[0];
        Frequency frequency3 = frequencyArray[1];
        Frequency frequency4 = scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity);
        NetSideBand netSideBand = frequency4.compareTo((AbstractDoubleWithUnit)frequency2) > 0 ? NetSideBand.USB : NetSideBand.LSB;
        abstractSpectralWindow.setSideBand(netSideBand.toString());
        Frequency frequency5 = netSideBand.getBaseBandFrequency(frequency4, frequency2, frequency3);
        abstractSpectralWindow.getCenterFrequency().setContentInMHz(frequency5.getContentInMHz());
        abstractSpectralWindow.setBandParameters((Frequency)((Object)scienceSpectralWindow.getBandWidth()), scienceSpectralWindow.getNumberOfChannels(), SpectralWindowBand.ChannelType.NOMINAL);
        ((BLSpectralWindow)((Object)abstractSpectralWindow)).setCorrelationBits(BLSpectralWindow.CORRELATIONBITS_BITS_2X2);
        return abstractSpectralWindow;
    }

    protected void setupChannelAverageRegion(AbstractSpectralWindow abstractSpectralWindow, String string) {
        for (ChannelAverageRegion channelAverageRegion : this.correxp.calcChannelAverageRegions(abstractSpectralWindow, string)) {
            abstractSpectralWindow.addChannelAverageRegion(channelAverageRegion);
        }
    }

    public static void main(String[] stringArray) throws IOException, MarshalException, ValidationException {
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        spectralSetupParameters.getSourceVelocity().setCenterVelocity(Speed.createSpeed());
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        spectralSetupParameters.setType(SpectralSetupParameters.TYPE_CONTINUUM);
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.addScienceSpectralWindow(-1, 0);
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(230.0);
        ObservatoryGoal observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
        observatoryGoal.setSpectralSetupParameters(spectralSetupParameters);
        observatoryGoal.setIntegrationTime(Time.createTimeSec(10.0));
        ObservatoryGoalSpectralSpecWorker observatoryGoalSpectralSpecWorker = new ObservatoryGoalSpectralSpecWorker(spectralSetupParameters, observatoryGoal.getIntegrationTime());
        SpectralSpec spectralSpec = observatoryGoalSpectralSpecWorker.getSpectralSpec();
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = new Marshaller((Writer)stringWriter);
        marshaller.setValidation(false);
        marshaller.marshal((Object)spectralSpec.getCastorObject());
        System.out.println(stringWriter.toString());
    }
}

