/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.timings.CorrelatorType;
import alma.observatorycharacteristics.timings.DivisionModeType;
import alma.observatorycharacteristics.timings.SchedBlockTimingExpert;
import alma.observatorycharacteristics.timings.SchedBlockTimingsXMLReader;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.ACASpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.BLSpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.TotalPowerSpectralSpecFactory;
import alma.obsprep.services.generator.refactored.spectralspec.Walsh90DegConfiguratorFactory;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

public class SpectralSpecFactory {
    public static final String TDM_PHASE = "TDMPhase";
    static final String DELAY = "DELAY";
    private static final String TDMATM = "TDMATM";
    static final String FOCUS = "FOCUS";
    static final String SCIENCE = "SCIENCE";
    static final String POINTING = "POINTING";
    private SBGenerationContext sbContext = null;
    public static final String DGC_REF_BWSW = "DGC_BWSW";
    public static final String DGC_REF_B2B = "DGC_B2B";
    private final TotalPowerSpectralSpecFactory totalPowerSpectralSpecFactory = new TotalPowerSpectralSpecFactory();
    private DGCExpert.DGCTypeEnum DGCCalibratorReturnType = DGCExpert.DGCTypeEnum.None;

    public SpectralSpecFactory(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.sbContext = sBGenerationContext;
    }

    public SpectralSpec getSpectralSpec(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Velocity velocity, @NonNull TargetWithIntent targetWithIntent) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.getSpectralSpec(spectralSetupParameters, velocity, targetWithIntent.getObsType(), Optional.of(targetWithIntent));
    }

    public SpectralSpec getSpectralSpec(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Velocity velocity, @NonNull ObsType obsType, Optional<TargetWithIntent> optional) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("obsType is marked non-null but is null");
        }
        return this.getSpectralSpecFromMap(this.getSpectralSpecWorker(spectralSetupParameters, velocity).getSpectralSpecGroup(), obsType, spectralSetupParameters, optional);
    }

    private SpectralSpec getSpectralSpecFromMap(Map<String, SpectralSpec> map, @NonNull ObsType obsType, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Optional<TargetWithIntent> optional) {
        boolean bl;
        if (obsType == null) {
            throw new NullPointerException("obsType is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        RequestedArray requestedArray = this.sbContext.getArray();
        boolean bl2 = spectralSetupParameters.isSingleContinuum();
        if (!bl2 || obsType.equals((Object)ObsType.DGCREFERENCE)) {
            return this.getSpectralSpec(map, obsType, false, spectralSetupParameters, optional);
        }
        boolean bl3 = bl = bl2 && spectralSetupParameters.getSingleContinuumCorrelatorMode().equals(SpectralSetupParameters.SINGLECONTINUUMCORRELATORMODE_HIGHRES);
        if (bl) {
            return this.getSpectralSpec(map, obsType, false, spectralSetupParameters, optional);
        }
        return this.getTDMSpectralSpec(map, obsType, requestedArray, spectralSetupParameters, optional);
    }

    private SpectralSpec getSpectralSpec(@NonNull Map<String, SpectralSpec> map, @NonNull ObsType obsType, boolean bl, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Optional<TargetWithIntent> optional) {
        SpectralSpec spectralSpec;
        if (map == null) {
            throw new NullPointerException("spectralSpecMap is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("obsType is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        @NonNull RequestedArray requestedArray = this.sbContext.getArray();
        boolean bl2 = RequestedArray.TP.equals((Object)requestedArray);
        if (ObsType.DELAY.equals((Object)obsType) && bl2) {
            spectralSpec = map.get(DELAY);
            SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
        } else {
            switch (obsType) {
                case AMPLITUDE: 
                case BANDPASS: 
                case PHASE: {
                    spectralSpec = this.getCalibratorSpectralSpec(map, bl, obsType, requestedArray, true);
                    break;
                }
                case DGCREFERENCE: {
                    spectralSpec = this.getDGCReferenceSpectralSpec(map, spectralSetupParameters);
                    break;
                }
                case ATMOSPHERIC: {
                    spectralSpec = map.get(TDMATM);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
                    break;
                }
                case FOCUS: {
                    spectralSpec = map.get(bl2 ? FOCUS : POINTING);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
                    break;
                }
                case POINTING: {
                    spectralSpec = map.get(POINTING);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(false, spectralSpec, this.sbContext);
                    break;
                }
                default: {
                    spectralSpec = map.get(SCIENCE);
                    if (bl) {
                        SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
                        break;
                    }
                    this.calculateFDMTimeAndDurations(true, spectralSpec);
                }
            }
        }
        if (bl2) {
            this.totalPowerSpectralSpecFactory.configureTPSpectralSpec(spectralSpec, obsType, spectralSetupParameters, optional);
        }
        return spectralSpec;
    }

    private SpectralSpec getDGCReferenceSpectralSpec(@NonNull Map<String, SpectralSpec> map, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (map == null) {
            throw new NullPointerException("spectralSpecMap is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        SpectralSpec spectralSpec = null;
        if (this.DGCCalibratorReturnType.equals((Object)DGCExpert.DGCTypeEnum.None)) {
            @NonNull ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
            Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert(this.sbContext.isTM2SB()).dgcObservingStrategiesRequired(scienceGoal, false);
            if (set.contains((Object)DGCExpert.DGCTypeEnum.None)) {
                throw new WizardSBGenerationException("The DGC reference calibrator strategy should be either B2B|BWSW");
            }
            String string = set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand) ? DGC_REF_B2B : DGC_REF_BWSW;
            spectralSpec = map.get(string);
        } else {
            spectralSpec = map.get(this.DGCCalibratorReturnType.equals((Object)DGCExpert.DGCTypeEnum.DGCBandToBand) ? DGC_REF_B2B : DGC_REF_BWSW);
        }
        assert (spectralSpec != null);
        return spectralSpec;
    }

    private void optimiseIntegrationTimeForLongBaselineSpectralSpecs(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        if (this.sbContext.getArray().isTM()) {
            Configuration configuration = this.sbContext.getConfiguration();
            if (configuration == null) {
                Log.logger(SpectralSpecFactory.class).warning("A valid configuration should be specified for the 12-m array");
                throw new WizardSBGenerationException("A valid configuration should be specified for the 12-m array");
            }
            if (!configuration.isLongBaselineConfiguration()) {
                return;
            }
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
            DataRate dataRate = spectralSpec.getInstantaneousDataRate();
            double d = AlmaPolicies.getInstance().getWarning12mDataRateMBPS();
            DataRate dataRate2 = DataRate.createDataRate((double)d, (String)DataRate.UNIT_MB_S);
            assert (dataRate.isGreaterThan((AbstractDoubleWithUnit)DataRate.createDataRate()));
            assert (d > 0.0);
            if (!(abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration)) {
                throw new WizardSBGenerationException("Expected a BL correlator configuration when optimising the integration duration");
            }
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            double d2 = bLCorrelatorConfiguration.getChannelAverageDuration().getContentInUnits(Time.UNIT_S);
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
            double d3 = correlatorExpert.calcIntegrationDurationInsecs(2.016, d2);
            bLCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
            bLCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
            dataRate = spectralSpec.getInstantaneousDataRate();
            if (dataRate.isGreaterThan((AbstractDoubleWithUnit)dataRate2)) {
                d3 = correlatorExpert.calcIntegrationDurationInsecs(3.024, d2);
                bLCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
                bLCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
            }
        }
    }

    static SpectralSpec convertToTopo(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("restSS is marked non-null but is null");
        }
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        spectralSpec2.setSourceVelocity(spectralSpec.getSourceVelocity().deepCopy());
        Velocity velocity = spectralSpec.getSourceVelocity();
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec2.getBaseBandConfig()) {
            Frequency frequency = velocity.dopplerShift(abstractBaseBandConfig.getCenterFrequency());
            abstractBaseBandConfig.setCenterFrequency(frequency);
        }
        FrequencySetup frequencySetup = spectralSpec2.getFrequencySetup();
        frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        spectralSpec2.setName(spectralSpec2.getName() + " (topo)");
        spectralSpec2.calculateCorrelatorSetup(Velocity.createVelocity());
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    public static void calculateTDMTimeAndDurations(boolean bl, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) throws WizardSBGenerationException {
        boolean bl2;
        boolean bl3 = spectralSpec.isBLSpectralSpec();
        SchedBlockTimingExpert.SchedBlockTimingExpertBuilder schedBlockTimingExpertBuilder = SchedBlockTimingExpert.builder();
        schedBlockTimingExpertBuilder.correlatorType(bl3 ? CorrelatorType.BL : CorrelatorType.ACA).divisionMode(DivisionModeType.TDM).isWalshEnabled(Optional.of(false)).isVLBI(Optional.of(sBGenerationContext.isVLBI()));
        boolean bl4 = SpectralSpecFactory.isACAWithSingleContinuumWithFDMAndFullPolarizationFlag(sBGenerationContext, spectralSpec.isBLSpectralSpec());
        schedBlockTimingExpertBuilder.isSingleContinuumFDMHiRes(Optional.of(bl4));
        SchedBlockTimingExpert.CorrelatorTimings correlatorTimings = null;
        try {
            correlatorTimings = schedBlockTimingExpertBuilder.build().findCorrelatorTimings();
        }
        catch (SchedBlockTimingExpert.UnableToDetermineTimingsException | SchedBlockTimingsXMLReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new WizardSBGenerationException(throwable);
        }
        SpectralSpecFactory.setCorrelatorTimings(spectralSpec, correlatorTimings.dumpDuration().getms(), correlatorTimings.channelAverage().getSecs(), correlatorTimings.integrationDuration().getSecs());
        if (bl && (bl2 = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching())) {
            Walsh90DegConfiguratorFactory.getConfigurator(spectralSpec.getAbstractCorrelatorConfiguration()).configureSpectralSpec(sBGenerationContext, spectralSpec);
        }
    }

    private static boolean isACAWithSingleContinuumWithFDMAndFullPolarizationFlag(@NonNull SBGenerationContext sBGenerationContext, boolean bl) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        return !bl && scienceGoal.isSingleContinuum() && !scienceGoal.getSpectralSetupParameters().isSingleContinuumTDM() && scienceGoal.isFullPolarization();
    }

    private void calculateFDMTimeAndDurations(boolean bl, SpectralSpec spectralSpec) throws WizardSBGenerationException {
        boolean bl2 = this.sbContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
        if (spectralSpec.isBLSpectralSpec()) {
            if (spectralSpec.isPureTDM()) {
                SpectralSpecFactory.calculateTDMTimeAndDurations(bl, spectralSpec, this.sbContext);
            } else {
                this.setBLCorrelatorNo90DWSFDMTimes(spectralSpec);
            }
        } else {
            this.setACACorrelatorFDMTimes(spectralSpec);
        }
        if (bl2 && bl) {
            Walsh90DegConfiguratorFactory.getConfigurator(spectralSpec.getAbstractCorrelatorConfiguration()).configureSpectralSpec(this.sbContext, spectralSpec);
        }
    }

    private void setACACorrelatorFDMTimes(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("spectralSpec is marked non-null but is null");
        }
        SchedBlockTimingExpert.SchedBlockTimingExpertBuilder schedBlockTimingExpertBuilder = SchedBlockTimingExpert.builder();
        schedBlockTimingExpertBuilder.correlatorType(CorrelatorType.ACA).divisionMode(DivisionModeType.FDM).isWalshEnabled(Optional.of(false)).isVLBI(Optional.of(this.sbContext.isVLBI()));
        if (spectralSpec.isPureTDM()) {
            schedBlockTimingExpertBuilder.divisionMode(DivisionModeType.TDM);
        }
        boolean bl = SpectralSpecFactory.isACAWithSingleContinuumWithFDMAndFullPolarizationFlag(this.sbContext, spectralSpec.isBLSpectralSpec());
        schedBlockTimingExpertBuilder.isSingleContinuumFDMHiRes(Optional.of(bl));
        try {
            SchedBlockTimingExpert.CorrelatorTimings correlatorTimings = schedBlockTimingExpertBuilder.build().findCorrelatorTimings();
            SpectralSpecFactory.setCorrelatorTimings(spectralSpec, correlatorTimings.dumpDuration().getms(), correlatorTimings.channelAverage().getSecs(), correlatorTimings.integrationDuration().getSecs());
        }
        catch (SchedBlockTimingExpert.UnableToDetermineTimingsException | SchedBlockTimingsXMLReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new WizardSBGenerationException(throwable);
        }
    }

    private void setBLCorrelatorNo90DWSFDMTimes(@NonNull SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        SchedBlockTimingExpert.SchedBlockTimingExpertBuilder schedBlockTimingExpertBuilder = SchedBlockTimingExpert.builder();
        schedBlockTimingExpertBuilder.correlatorType(CorrelatorType.BL).divisionMode(DivisionModeType.FDM).isWalshEnabled(Optional.of(false)).isVLBI(Optional.of(this.sbContext.isVLBI()));
        SchedBlockTimingExpert.CorrelatorTimings correlatorTimings = null;
        try {
            correlatorTimings = schedBlockTimingExpertBuilder.build().findCorrelatorTimings();
        }
        catch (SchedBlockTimingExpert.UnableToDetermineTimingsException | SchedBlockTimingsXMLReader.InvalidOTCOnfigurationException | JAXBException throwable) {
            throw new WizardSBGenerationException(throwable);
        }
        SpectralSpecFactory.setCorrelatorTimings(spectralSpec, correlatorTimings.dumpDuration().getms(), correlatorTimings.channelAverage().getSecs(), correlatorTimings.integrationDuration().getSecs());
        this.optimiseIntegrationTimeForLongBaselineSpectralSpecs(spectralSpec);
    }

    private SpectralSpec getCalibratorSpectralSpec(Map<String, SpectralSpec> map, boolean bl, ObsType obsType, RequestedArray requestedArray, boolean bl2) {
        SpectralSpec spectralSpec;
        SpectralSpec spectralSpec2 = spectralSpec = bl ? map.get(TDM_PHASE) : map.get(SCIENCE);
        if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)obsType)) {
            SpectralSpecFactory.setCorrelatorTimings(spectralSpec, 1000.0, 0.1, 0.1);
            spectralSpec = SpectralSpecFactory.convertToTopo(spectralSpec);
        }
        if (bl) {
            SpectralSpecFactory.calculateTDMTimeAndDurations(bl2, spectralSpec, this.sbContext);
        } else {
            this.calculateFDMTimeAndDurations(bl2, spectralSpec);
        }
        return spectralSpec;
    }

    private SpectralSpec getTDMSpectralSpec(@NonNull Map<String, SpectralSpec> map, @NonNull ObsType obsType, @NonNull RequestedArray requestedArray, SpectralSetupParameters spectralSetupParameters, @NonNull Optional<TargetWithIntent> optional) {
        SpectralSpec spectralSpec;
        if (map == null) {
            throw new NullPointerException("ssHash is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("obsType is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        boolean bl = true;
        switch (obsType) {
            case POINTING: {
                spectralSpec = map.get(POINTING);
                bl = false;
                break;
            }
            case FOCUS: {
                bl = false;
                if (RequestedArray.TP.equals((Object)requestedArray)) {
                    spectralSpec = map.get(FOCUS);
                    break;
                }
                spectralSpec = map.get(POINTING);
                break;
            }
            default: {
                spectralSpec = obsType.equals((Object)ObsType.DELAY) && RequestedArray.TP.equals((Object)requestedArray) ? map.get(DELAY) : map.get(SCIENCE);
            }
        }
        SpectralSpecFactory.calculateTDMTimeAndDurations(bl, spectralSpec, this.sbContext);
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            this.totalPowerSpectralSpecFactory.configureTPSpectralSpec(spectralSpec, obsType, spectralSetupParameters, optional);
        }
        return spectralSpec;
    }

    private SpectralSpecWorker getSpectralSpecWorker(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Velocity velocity) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (this.sbContext.getArray() == RequestedArray.TP) {
            if (System.getProperty("UseBLCorrForAca", "false").equalsIgnoreCase("false")) {
                return new ACASpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
            }
            return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
        }
        return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
    }

    private static void setCorrelatorTimings(SpectralSpec spectralSpec, double d, double d2, double d3) throws WizardSBGenerationException {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
        double d4 = correlatorExpert.calcDumpDurationInmsecs(d) / 1000.0;
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            bLCorrelatorConfiguration.setDumpDuration(Time.createTimeSec(d4));
        }
        double d5 = correlatorExpert.calcChannelAverageDurationInsecs(d2, d4);
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(d5));
        double d6 = correlatorExpert.calcIntegrationDurationInsecs(d3, d5);
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d6, (String)Time.UNIT_S));
    }

    public SpectralSpec getTDMPhaseSpectralSpec(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull Velocity velocity) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        SpectralSpecWorker spectralSpecWorker = this.getSpectralSpecWorker(spectralSetupParameters, velocity);
        return spectralSpecWorker.getSpectralSpecGroup().get(TDM_PHASE);
    }

    public DGCExpert.DGCTypeEnum getDGCCalibratorReturnType() {
        return this.DGCCalibratorReturnType;
    }

    public void setDGCCalibratorReturnType(DGCExpert.DGCTypeEnum dGCTypeEnum) {
        this.DGCCalibratorReturnType = dGCTypeEnum;
    }
}

