/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.SourcePropertiesInfo;
import alma.valuetypes.Flux;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import javax.swing.table.AbstractTableModel;

public class SourcePropertiesTableModel
extends AbstractTableModel {
    private ScienceGoalSummaryParameters document;
    private final String[] longValues = new String[]{"  Continuum  ", " 00.004 uJy ", "  312.0 km/s ", " 99 % ", "  999.9  ", " xxx km/s ", " 0000.00 Jy 0000.00 K ", "    00000.00  "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return SourcePropertiesCols.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        SourcePropertiesCols sourcePropertiesCols = SourcePropertiesCols.getColumnDescriptor(n);
        return sourcePropertiesCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        if (scienceGoalSummaryParameters == null || scienceGoalSummaryParameters.targetInfoLists == null) {
            return null;
        }
        SourcePropertiesInfo sourcePropertiesInfo = scienceGoalSummaryParameters.sourcePropertiesInfo;
        SourcePropertiesCols sourcePropertiesCols = SourcePropertiesCols.getColumnDescriptor(n2);
        switch (sourcePropertiesCols) {
            case LABEL: {
                return n == 0 ? "Line" : "Continuum";
            }
            case PEAKFLUX: {
                return n == 0 ? sourcePropertiesInfo.fluxLine : sourcePropertiesInfo.fluxCont;
            }
            case SNR: {
                return n == 0 ? sourcePropertiesInfo.snrLine : sourcePropertiesInfo.snrCont;
            }
            case LINEWIDTH: {
                return n == 0 ? sourcePropertiesInfo.linewidth : null;
            }
            case POLARIZATION: {
                return n == 0 ? sourcePropertiesInfo.polarizationLine : sourcePropertiesInfo.polarizationCont;
            }
            case POLSNR: {
                return n == 0 ? sourcePropertiesInfo.polSnrLine : sourcePropertiesInfo.polSnrCont;
            }
            case REQLINERMS: {
                return n == 1 || sourcePropertiesInfo.linewidth.isZero() ? null : sourcePropertiesInfo.reqLineRMS;
            }
            case WIDTHRATIO: {
                return n == 1 || sourcePropertiesInfo.linewidth.isZero() ? null : sourcePropertiesInfo.lineWidthRatio;
            }
        }
        String string = "Invalid column index : " + n2 + "(descriptor = " + sourcePropertiesCols + ")";
        throw new IllegalArgumentException(string);
    }

    public ScienceGoalSummaryParameters getParameters() {
        return this.document;
    }

    public void setDocument(ScienceGoalSummaryParameters scienceGoalSummaryParameters) {
        this.document = scienceGoalSummaryParameters;
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum SourcePropertiesCols {
        LABEL("<html>&nbsp;<br>&nbsp;</html>", String.class),
        PEAKFLUX("<html> Peak Flux <br></html> ", Flux.class),
        SNR("<html> SNR <br></html>", Double.class),
        LINEWIDTH("<html>Linewidth<br></html> ", Speed.class),
        REQLINERMS("<html><center>RMS<br>(over 1/3 linewidth)</center></html>", Sensitivity.class),
        WIDTHRATIO("<html>linewidth / bandwidth<br>used for sensitivity</html>", Double.class),
        POLARIZATION("<html>Pol.<br></html> ", Double.class),
        POLSNR("<html>Pol. <br>SNR </html>", Double.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return SourcePropertiesCols.values().length;
        }

        protected static SourcePropertiesCols getColumnDescriptor(int n) {
            return SourcePropertiesCols.values()[n];
        }

        private SourcePropertiesCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

