/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.DataRate;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeReference;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import java.util.HashSet;

public final class UnitMapConfigurator {
    private static final double TWO_TEN = 1024.0;
    private static final double TWO_TWENTY = 1048576.0;

    private UnitMapConfigurator() {
    }

    public static synchronized void configureUnitMaps() {
        UnitMapConfigurator.configureAngleUnits();
        UnitMapConfigurator.configureDataRateUnits();
        UnitMapConfigurator.configureFrequencyUnits();
        UnitMapConfigurator.configureIntTimeReferenceUnits();
        UnitMapConfigurator.configureIntTimeSourceUnits();
        UnitMapConfigurator.configureLatitudeUnits();
        UnitMapConfigurator.configureLengthUnits();
        UnitMapConfigurator.configureLongitudeUnits();
        UnitMapConfigurator.configureRotationUnits();
        UnitMapConfigurator.configureSensitivityUnits();
        UnitMapConfigurator.configureSpeedUnits();
        UnitMapConfigurator.configureStorageVolumeUnits();
        UnitMapConfigurator.configureTemperatureUnits();
        UnitMapConfigurator.configureTimeUnits();
        UnitMapConfigurator.configureBasicTimeUnits();
        UnitMapConfigurator.configureAngularVelocityUnits();
        UnitMapConfigurator.configureFluxUnits();
    }

    private static void checkForCompleteness(ValueUnitPair<?> valueUnitPair, String[] stringArray) {
        String string = valueUnitPair.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        UnitMapConfigurator.checkForCompleteness(string, valueUnitPair.unitMap(), stringArray, valueUnitPair.defaultUnit());
    }

    private static boolean checkForCompleteness(String string, UnitMap unitMap, String[] stringArray, String string2) {
        boolean bl = true;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : stringArray) {
            if (!unitMap.containsKey((Object)string3)) {
                Log.logger(UnitMapConfigurator.class).severe("Unit " + string3 + " not added to " + string + " UnitMap");
                bl = false;
            }
            hashSet.add(string3);
        }
        for (Object e : unitMap.keySet()) {
            if (hashSet.contains(e)) continue;
            Log.logger(UnitMapConfigurator.class).severe("Unit " + e + " unexpectedly added to " + string + " UnitMap");
            bl = false;
        }
        String string4 = unitMap.getDefaultUnit();
        if (string4 == null) {
            Log.logger(UnitMapConfigurator.class).severe("no default unit specified for " + string);
            bl = false;
        } else if (string4 != string2) {
            Log.logger(UnitMapConfigurator.class).severe(string + " class and UnitMap disagree on default unit (" + string2 + " vs " + string4 + ")");
        }
        return bl;
    }

    private static void configureAngleUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Angle.UNIT_DEG, (Object)60.0);
        unitMap.put((Object)Angle.UNIT_ARCMIN, (Object)1.0);
        unitMap.put((Object)Angle.UNIT_RAD, (Object)3437.7467707849396);
        unitMap.put((Object)Angle.UNIT_ARCSEC, (Object)0.016666666666666666);
        unitMap.put((Object)Angle.UNIT_MAS, (Object)1.6666666666666667E-5);
        unitMap.setDefaultUnit(Angle.UNIT_DEG);
        UnitMap.addUnits((String)"Angle", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Angle.createAngle(), Angle.getKnownUnitList());
    }

    private static void configureAngularVelocityUnits() {
        UnitMap.addUnits((String)"AngularVelocity", (UnitMap)UnitMap.getRotationUnits());
        UnitMapConfigurator.checkForCompleteness(AngularVelocity.createAngularVelocity(), AngularVelocity.getKnownUnitList());
    }

    private static void configureDataRateUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)DataRate.UNIT_B_S, (Object)9.5367431640625E-7);
        unitMap.put((Object)DataRate.UNIT_KB_S, (Object)9.765625E-4);
        unitMap.put((Object)DataRate.UNIT_MB_S, (Object)1.0);
        unitMap.put((Object)DataRate.UNIT_GB_S, (Object)1024.0);
        unitMap.put((Object)DataRate.UNIT_TB_S, (Object)1048576.0);
        unitMap.setDefaultUnit(DataRate.staticDefaultUnit());
        UnitMap.addUnits((String)"DataRate", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(DataRate.createDataRate(), DataRate.getKnownUnitList());
    }

    private static void configureFluxUnits() {
        UnitMap.addUnits((String)"Flux", (UnitMap)UnitMap.getSensitivityUnits());
        UnitMapConfigurator.checkForCompleteness(Flux.createFlux(), Flux.getKnownUnitList());
    }

    private static void configureFrequencyUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Frequency.UNIT_GHZ, (Object)1.0);
        unitMap.put((Object)Frequency.UNIT_MHZ, (Object)0.001);
        unitMap.put((Object)Frequency.UNIT_KHZ, (Object)1.0E-6);
        unitMap.put((Object)Frequency.UNIT_HZ, (Object)1.0E-9);
        unitMap.setDefaultUnit(Frequency.UNIT_GHZ);
        UnitMap.addUnits((String)"Frequency", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Frequency.createFrequency(), Frequency.getKnownUnitList());
    }

    private static void configureIntTimeReferenceUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)IntTimeReference.UNIT_D, (Object)86400.0);
        unitMap.put((Object)IntTimeReference.UNIT_H, (Object)3600.0);
        unitMap.put((Object)IntTimeReference.UNIT_MIN, (Object)60.0);
        unitMap.put((Object)IntTimeReference.UNIT_S, (Object)1.0);
        unitMap.put((Object)IntTimeReference.UNIT_MS, (Object)0.001);
        unitMap.put((Object)IntTimeReference.UNIT_US, (Object)1.0E-6);
        unitMap.put((Object)IntTimeReference.UNIT_NS, (Object)1.0E-9);
        unitMap.setDefaultUnit(IntTimeReference.UNIT_S);
        UnitMap.addUnits((String)"IntTimeReference", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(IntTimeReference.createIntTimeReference(), IntTimeReference.getKnownUnitList());
    }

    private static void configureIntTimeSourceUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)IntTimeSource.UNIT_D, (Object)86400.0);
        unitMap.put((Object)IntTimeSource.UNIT_H, (Object)3600.0);
        unitMap.put((Object)IntTimeSource.UNIT_MIN, (Object)60.0);
        unitMap.put((Object)IntTimeSource.UNIT_S, (Object)1.0);
        unitMap.put((Object)IntTimeSource.UNIT_MS, (Object)0.001);
        unitMap.put((Object)IntTimeSource.UNIT_US, (Object)1.0E-6);
        unitMap.put((Object)IntTimeSource.UNIT_NS, (Object)1.0E-9);
        unitMap.setDefaultUnit(IntTimeSource.UNIT_S);
        UnitMap.addUnits((String)"IntTimeSource", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(IntTimeSource.createIntTimeSource(), IntTimeSource.getKnownUnitList());
    }

    private static void configureLatitudeUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Latitude.UNIT_ARCMIN, (Object)0.016666666666666666);
        unitMap.put((Object)Latitude.UNIT_ARCSEC, (Object)2.777777777777778E-4);
        unitMap.put((Object)Latitude.UNIT_MAS, (Object)2.7777777777777776E-7);
        unitMap.put((Object)Latitude.UNIT_RAD, (Object)57.29577951308232);
        unitMap.put((Object)Latitude.UNIT_DEG, (Object)1.0);
        unitMap.setDefaultUnit(Latitude.UNIT_DEG);
        UnitMap.addUnits((String)"Latitude", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Latitude.createLatitude(), Latitude.getKnownUnitList());
    }

    private static void configureLengthUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Length.UNIT_MM, (Object)1.0);
        unitMap.put((Object)Length.UNIT_CM, (Object)10.0);
        unitMap.put((Object)Length.UNIT_M, (Object)1000.0);
        unitMap.put((Object)Length.UNIT_KM, (Object)1000000.0);
        unitMap.put((Object)Length.UNIT_PC, (Object)3.0951E19);
        unitMap.setDefaultUnit(Length.UNIT_MM);
        UnitMap.addUnits((String)"Length", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Length.createLength(), Length.getKnownUnitList());
    }

    private static void configureLongitudeUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Longitude.UNIT_ARCMIN, (Object)0.016666666666666666);
        unitMap.put((Object)Longitude.UNIT_ARCSEC, (Object)2.777777777777778E-4);
        unitMap.put((Object)Latitude.UNIT_MAS, (Object)2.7777777777777776E-7);
        unitMap.put((Object)Longitude.UNIT_RAD, (Object)57.29577951308232);
        unitMap.put((Object)Longitude.UNIT_DEG, (Object)1.0);
        unitMap.setDefaultUnit(Longitude.UNIT_DEG);
        UnitMap.addUnits((String)"Longitude", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Longitude.createLongitude(), Longitude.getKnownUnitList());
    }

    private static void configureRotationUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)AngularVelocity.UNIT_ARCSEC_S, (Object)1.0);
        unitMap.put((Object)AngularVelocity.UNIT_ARCMIN_S, (Object)60.0);
        unitMap.put((Object)AngularVelocity.UNIT_DEG_S, (Object)3600.0);
        unitMap.put((Object)AngularVelocity.UNIT_MAS_YR, (Object)3.1709791983764586E-11);
        unitMap.setDefaultUnit(AngularVelocity.UNIT_DEG_S);
        UnitMap.addUnits((String)"Rotation", (UnitMap)unitMap);
    }

    private static void configureSensitivityUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Sensitivity.UNIT_JY, (Object)1.0);
        unitMap.put((Object)Sensitivity.UNIT_MJY, (Object)0.001);
        unitMap.setDefaultUnit(Sensitivity.UNIT_JY);
        UnitMap.addUnits((String)"Sensitivity", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Sensitivity.createSensitivity(), Sensitivity.getKnownUnitList());
    }

    private static void configureSpeedUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Speed.UNIT_KM_S, (Object)1.0);
        unitMap.put((Object)Speed.UNIT_M_S, (Object)0.001);
        unitMap.setDefaultUnit(Speed.UNIT_KM_S);
        UnitMap.addUnits((String)"Speed", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Speed.createSpeed(), Speed.getKnownUnitList());
    }

    private static void configureStorageVolumeUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)StorageVolume.UNIT_B, (Object)9.5367431640625E-7);
        unitMap.put((Object)StorageVolume.UNIT_KB, (Object)9.765625E-4);
        unitMap.put((Object)StorageVolume.UNIT_MB, (Object)1.0);
        unitMap.put((Object)StorageVolume.UNIT_GB, (Object)1024.0);
        unitMap.put((Object)StorageVolume.UNIT_TB, (Object)1048576.0);
        unitMap.setDefaultUnit(StorageVolume.staticDefaultUnit());
        UnitMap.addUnits((String)"StorageVolume", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(StorageVolume.createStorageVolume(), StorageVolume.getKnownUnitList());
    }

    private static void configureTemperatureUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Temperature.UNIT_K, (Object)1.0);
        unitMap.put((Object)Temperature.UNIT_MK, (Object)0.001);
        unitMap.setDefaultUnit(Temperature.UNIT_K);
        UnitMap.addUnits((String)"Temperature", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Temperature.createTemperature(), Temperature.getKnownUnitList());
    }

    private static void configureTimeUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Time.UNIT_D, (Object)86400.0);
        unitMap.put((Object)Time.UNIT_H, (Object)3600.0);
        unitMap.put((Object)Time.UNIT_MIN, (Object)60.0);
        unitMap.put((Object)Time.UNIT_S, (Object)1.0);
        unitMap.put((Object)Time.UNIT_NS, (Object)1.0E-9);
        unitMap.put((Object)Time.UNIT_US, (Object)1.0E-6);
        unitMap.put((Object)Time.UNIT_MS, (Object)0.001);
        unitMap.setDefaultUnit(Time.UNIT_S);
        UnitMap.addUnits((String)"Time", (UnitMap)unitMap);
        UnitMapConfigurator.checkForCompleteness(Time.createTime(), Time.getKnownUnitList());
    }

    private static void configureBasicTimeUnits() {
        UnitMap unitMap = new UnitMap();
        unitMap.put((Object)Time.UNIT_D, (Object)86400.0);
        unitMap.put((Object)Time.UNIT_H, (Object)3600.0);
        unitMap.put((Object)Time.UNIT_MIN, (Object)60.0);
        unitMap.setDefaultUnit(Time.UNIT_MIN);
        UnitMap.addUnits((String)"BasicTime", (UnitMap)unitMap);
    }
}

