/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.ArrayType;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.util.FrequencyDependentUnitMap;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Temperature;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.UserUnitValueUnitPair;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserSensitivityUnitMap
extends FrequencyDependentUnitMap {
    private ArrayType arrayType = ArrayType.INTERFEROMETRY;
    private Antenna antenna = Antenna.ANTENNA_12M;
    private Angle beamsize;
    private final Set<String> frequencyDependingUnits = new HashSet<String>();
    private static UnitMap independentUserUnitMap = new UnitMap();

    public UserSensitivityUnitMap(UserUnitValueUnitPair userUnitValueUnitPair) {
        super(userUnitValueUnitPair);
    }

    @Override
    protected boolean isDependeeChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        return !(object != this.observingFrequency && object != this.beamsize || !string.endsWith(".content") && !string.endsWith(".unit"));
    }

    @Override
    protected UnitMap getStaticNonModelUnitMap() {
        UnitMap unitMap = new UnitMap();
        UnitMap unitMap2 = UnitMap.getTemperatureUnits();
        unitMap.putAll((Map)unitMap2);
        unitMap.putAll((Map)independentUserUnitMap);
        this.frequencyDependingUnits.addAll(unitMap2.keySet());
        return unitMap;
    }

    @Override
    protected Set<String> getFrequencyDependingUnits() {
        return this.frequencyDependingUnits;
    }

    @Override
    protected void initializeUnitMap() {
        UnitMap unitMap = UnitMap.getUnits((String)"Sensitivity");
        this.putAll((Map)unitMap);
        this.setDefaultUnit(unitMap.getDefaultUnit());
        if (this.nonModelUnitsAccepted) {
            this.addNonModelUnits();
        }
    }

    @Override
    protected void updateNonModelUnitsScale() throws UnitException {
        double d = this.getScale(Sensitivity.UNIT_JY);
        Temperature temperature = Temperature.createTemperature();
        temperature.setContent(1.0);
        Sensitivity sensitivity = this.getFluxDensity(temperature);
        double d2 = sensitivity.getContentInUnits(Sensitivity.UNIT_JY);
        if (Math.abs(d) < 1.0E-5 || Math.abs(d2) < 1.0E-5) {
            return;
        }
        if (this.nonModelUnitsAccepted) {
            UnitMap unitMap = this.getStaticNonModelUnitMap();
            Set<String> set = this.frequencyDependingUnits;
            for (String string : set) {
                double d3 = d * d2 * unitMap.getScale(string);
                this.put(string, d3);
            }
        }
    }

    public void setBeamsize(Angle angle) {
        if (this.beamsize != null) {
            this.beamsize.removePropertyChangeListener(this.unitMapUpdater);
        }
        this.beamsize = angle;
        this.updateUnitMap();
        if (angle != null) {
            angle.addPropertyChangeListener(this.unitMapUpdater);
        }
    }

    public void setAntenna(Antenna antenna) {
        if (this.nonModelUnitsAccepted && antenna == null) {
            throw new NullPointerException("Antenna must not be null when non model units are accepted.");
        }
        this.antenna = antenna;
        this.updateUnitMap();
    }

    public void setArrayType(ArrayType arrayType) {
        if (this.nonModelUnitsAccepted && arrayType == null) {
            throw new NullPointerException("ArrayType must not be null when non model units are accepted.");
        }
        this.arrayType = arrayType;
        this.updateUnitMap();
    }

    private Sensitivity getFluxDensity(Temperature temperature) {
        double d;
        double d2 = temperature.getContentInUnits(Temperature.UNIT_K);
        double d3 = this.getNonZeroObservingFrequency().getContentInGHz();
        if (this.arrayType.isInterferometry()) {
            double d4 = this.beamsize.getContentInUnits(Angle.UNIT_ARCSEC);
            d = ExposureTimeCalculator.toFluxDensity(d2, d3, d4);
        } else {
            this.antenna.getDiameter();
            double d5 = this.antenna.getBeamSize(this.getNonZeroObservingFrequency()).getContentInUnits(Angle.UNIT_ARCSEC);
            d = ExposureTimeCalculator.toFluxDensity(d2, d3, d5);
        }
        return Sensitivity.createSensitivity((double)d, (String)Sensitivity.UNIT_JY);
    }

    @Override
    public double getConversionFactor(String string, String string2) throws UnitException {
        UnitMap unitMap;
        if (this.beamsize == null && ((unitMap = UnitMap.getTemperatureUnits()).containsKey((Object)string) || unitMap.containsKey((Object)string2))) {
            throw new UnitException("beamsize is not set");
        }
        return super.getConversionFactor(string, string2);
    }

    @Override
    public void updateUnitMap() {
        if (this.observingFrequency == null || this.beamsize == null) {
            this.putAll((Map)this.getStaticNonModelUnitMap());
            return;
        }
        super.updateUnitMap();
    }

    static {
        independentUserUnitMap.put((Object)UserSensitivity.USERUNIT_UJY, (Object)1.0E-6);
    }
}

