/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering.visualization;

import com.apporiented.algorithm.clustering.AverageLinkageStrategy;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import com.apporiented.algorithm.clustering.visualization.ClusterComponent;
import com.apporiented.algorithm.clustering.visualization.VCoord;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DendrogramPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final BasicStroke solidStroke = new BasicStroke(1.0f, 0, 1);
    private Cluster model;
    private ClusterComponent component;
    private Color lineColor = Color.BLACK;
    private boolean showDistanceValues = false;
    private boolean showScale = true;
    private int borderTop = 20;
    private int borderLeft = 20;
    private int borderRight = 20;
    private int borderBottom = 20;
    private int scalePadding = 10;
    private int scaleTickLength = 4;
    private int scaleTickLabelPadding = 4;
    private double scaleValueInterval = 0.0;
    private int scaleValueDecimals = 0;
    private double xModelOrigin = 0.0;
    private double yModelOrigin = 0.0;
    private double wModel = 0.0;
    private double hModel = 0.0;

    public boolean isShowDistanceValues() {
        return this.showDistanceValues;
    }

    public void setShowDistances(boolean bl) {
        this.showDistanceValues = bl;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean bl) {
        this.showScale = bl;
    }

    public int getScalePadding() {
        return this.scalePadding;
    }

    public void setScalePadding(int n) {
        this.scalePadding = n;
    }

    public int getScaleTickLength() {
        return this.scaleTickLength;
    }

    public void setScaleTickLength(int n) {
        this.scaleTickLength = n;
    }

    public double getScaleValueInterval() {
        return this.scaleValueInterval;
    }

    public void setScaleValueInterval(double d) {
        this.scaleValueInterval = d;
    }

    public int getScaleValueDecimals() {
        return this.scaleValueDecimals;
    }

    public void setScaleValueDecimals(int n) {
        this.scaleValueDecimals = n;
    }

    public int getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(int n) {
        this.borderTop = n;
    }

    public int getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(int n) {
        this.borderLeft = n;
    }

    public int getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(int n) {
        this.borderRight = n;
    }

    public int getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(int n) {
        this.borderBottom = n;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Cluster getModel() {
        return this.model;
    }

    public void setModel(Cluster cluster) {
        this.model = cluster;
        this.component = this.createComponent(cluster);
        this.updateModelMetrics();
    }

    private void updateModelMetrics() {
        double d = this.component.getRectMinX();
        double d2 = this.component.getRectMaxX();
        double d3 = this.component.getRectMinY();
        double d4 = this.component.getRectMaxY();
        this.xModelOrigin = d;
        this.yModelOrigin = d3;
        this.wModel = d2 - d;
        this.hModel = d4 - d3;
    }

    private ClusterComponent createComponent(Cluster cluster, VCoord vCoord, double d) {
        ClusterComponent clusterComponent = null;
        if (cluster != null) {
            clusterComponent = new ClusterComponent(cluster, cluster.isLeaf(), vCoord);
            double d2 = d / (double)cluster.countLeafs();
            double d3 = vCoord.getY() - d / 2.0;
            double d4 = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
            for (Cluster cluster2 : cluster.getChildren()) {
                int n = cluster2.countLeafs();
                double d5 = (double)n * d2;
                double d6 = cluster2.getDistanceValue() == null ? 0.0 : cluster2.getDistanceValue();
                VCoord vCoord2 = new VCoord(vCoord.getX() + (d4 - d6), d3 + d5 / 2.0);
                d3 += d5;
                ClusterComponent clusterComponent2 = this.createComponent(cluster2, vCoord2, d5);
                clusterComponent2.setLinkPoint(vCoord);
                clusterComponent.getChildren().add(clusterComponent2);
            }
        }
        return clusterComponent;
    }

    private ClusterComponent createComponent(Cluster cluster) {
        double d = 1.0;
        VCoord vCoord = new VCoord(0.0, d / 2.0);
        ClusterComponent clusterComponent = this.createComponent(cluster, vCoord, d);
        clusterComponent.setLinkPoint(vCoord);
        return clusterComponent;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.lineColor);
        graphics2D.setStroke(solidStroke);
        int n = this.getWidth() - this.borderLeft - this.borderRight;
        int n2 = this.getHeight() - this.borderTop - this.borderBottom;
        int n3 = this.borderLeft;
        int n4 = this.borderBottom;
        if (this.component != null) {
            int n5 = this.component.getMaxNameWidth(graphics2D, false) + this.component.getNamePadding();
            n -= n5;
            if (this.showScale) {
                Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds("0", graphics2D);
                int n6 = (int)rectangle2D.getHeight() + this.scalePadding + this.scaleTickLength + this.scaleTickLabelPadding;
                n2 -= n6;
                n4 += n6;
            }
            double d = (double)n / this.wModel;
            double d2 = (double)n2 / this.hModel;
            int n7 = (int)((double)n3 - this.xModelOrigin * d);
            int n8 = (int)((double)n4 - this.yModelOrigin * d2);
            this.component.paint(graphics2D, n7, n8, d, d2, this.showDistanceValues);
            if (this.showScale) {
                int n9 = n3;
                int n10 = n4 - this.scalePadding;
                int n11 = n9 + n;
                int n12 = n10;
                graphics2D.drawLine(n9, n10, n11, n12);
                double d3 = this.component.getCluster().getTotalDistance();
                double d4 = this.scaleValueInterval <= 0.0 ? d3 / 10.0 : this.scaleValueInterval;
                int n13 = n3 + n;
                n10 = n4 - this.scalePadding;
                n12 = n4 - this.scalePadding - this.scaleTickLength;
                double d5 = 0.0;
                double d6 = d4 * d;
                while (n13 >= n3) {
                    graphics2D.drawLine(n13, n10, n13, n12);
                    String string = String.format("%." + this.scaleValueDecimals + "f", d5);
                    Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                    graphics2D.drawString(string, (int)((double)n13 - rectangle2D.getWidth() / 2.0), n12 - this.scaleTickLabelPadding);
                    n13 = (int)((double)n13 - d6);
                    d5 += d4;
                }
            }
        } else {
            String string = "No data";
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            int n14 = (int)((double)n / 2.0 - rectangle2D.getWidth() / 2.0);
            int n15 = (int)((double)n2 / 2.0 - rectangle2D.getHeight() / 2.0);
            graphics2D.drawString(string, n14, n15);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 300);
        jFrame.setLocation(400, 300);
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        DendrogramPanel dendrogramPanel = new DendrogramPanel();
        jFrame.setContentPane(jPanel);
        jPanel.setBackground(Color.red);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)dendrogramPanel, "Center");
        dendrogramPanel.setBackground(Color.WHITE);
        dendrogramPanel.setLineColor(Color.BLACK);
        dendrogramPanel.setScaleValueDecimals(0);
        dendrogramPanel.setScaleValueInterval(1.0);
        dendrogramPanel.setShowDistances(false);
        Cluster cluster = DendrogramPanel.createSampleCluster();
        dendrogramPanel.setModel(cluster);
        jFrame.setVisible(true);
    }

    private static Cluster createSampleCluster() {
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 9.0, 7.0, 11.0, 14.0}, {1.0, 0.0, 4.0, 3.0, 8.0, 10.0}, {9.0, 4.0, 0.0, 9.0, 2.0, 8.0}, {7.0, 3.0, 9.0, 0.0, 6.0, 13.0}, {11.0, 8.0, 2.0, 6.0, 0.0, 10.0}, {14.0, 10.0, 8.0, 13.0, 10.0, 0.0}};
        String[] stringArray = new String[]{"O1", "O2", "O3", "O4", "O5", "O6"};
        DefaultClusteringAlgorithm defaultClusteringAlgorithm = new DefaultClusteringAlgorithm();
        Cluster cluster = defaultClusteringAlgorithm.performClustering(dArrayArray, stringArray, new AverageLinkageStrategy());
        cluster.toConsole(0);
        return cluster;
    }
}

