mkdir -p $HOME/.almaot

# The user should set the following values themselves if they have not been defined on the command line 

#export JAVA_OPTIONS="-Dot.submission.user=youruserid -Dot.submission.pass=yourpassword"

if [ -z "$JAVA_OPTIONS" ] 
then 
	echo '
	Please use an editor to set the JAVA_OPTIONS environment variable at the head of this file to specify your archive logon credentials or, 
	alternatively, set the JAVA_OPTIONS environment variable from the command line using the following and then run this script again: 
	
    export JAVA_OPTIONS='"'"'-Dot.submission.user=youruserid -Dot.submission.pass=yourpassword'"'"
	
	exit -1
fi

## Ensure that the user has specified the name of the XML action file

if [ "$#" -eq 0 ]; then
	echo '
	Usage: batchupdate.sh [-h|--help] [-t|--template] [--nostore] --file <XML file containing actions>
	'
fi 

# Process input arguments

for i in "$@"; do
    case $i in
	-t|--template)
	    TEMPLATE="-t"
	    shift
	    ;;
	-h|--help)
	    HELP="-h"
	    shift
	    ;;
	--nostore)
	    NOSTORE="--nostore"
	    shift
	    ;;
	-f*|--file*)
	    FILE=$2
	    shift
	    shift
	    ;;
	-*|--*)
	    echo "Unknown option: $i"
	    exit 1
	    ;;
	*)
	    ;;
   esac
done


# Locate the java to use

javacmd=java

# An array of the various directories which could hold JREs for the various platforms if a JRE is included with the release  

declare -a jreDirs=("${INSTALLDIR}/../jre/bin/java" "${INSTALLDIR}/jre/bin/java" "${INSTALLDIR}/jre/Contents/home/bin/java" "${INSTALLDIR}/../jre/Contents/home/bin/java" "${INSTALLDIR}/../jre/Contents/Home/jre/bin/java")   

for i in "${jreDirs[@]}"
do
	if [ -e $i ]; then 
		javacmd=$i
		break
	fi 	
done

$javacmd $PROXYSETTINGS -cp $INSTALLDIR/lib/jACSUtil.jar:$INSTALLDIR/lib/*  --add-opens java.xml/com.sun.org.apache.xml.internal.serialize=ALL-UNNAMED -Dacs.system.classpath.jardirs=$INSTALLDIR/lib  -Djava.util.logging.config.class=alma.obsprep.util.LoggingSetup -Dalma.obsprep.PrintStackTrace=true -DTelescope=Cycle11 -Dot.submission.host="https://cycle-11.asa.alma.cl/" ${JAVA_OPTIONS} -Xmx${HEAPSPACE}g  alma.obsprep.ot.scripting.P2GBatchProcessor ${TEMPLATE} ${HELP} ${NOSTORE} -f ${FILE} 2>$HOME/.almaot/ot.log 
