/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class GreyscaleFilter
extends RGBImageFilter {
    public GreyscaleFilter() {
        this.canFilterIndexColorModel = true;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        return rgb;
    }

    @Override
    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        int index = off;
        for (int cy = 0; cy < h; ++cy) {
            for (int cx = 0; cx < w; ++cx) {
                int red = (pixels[index] & 0xFF0000) >> 16;
                int green = (pixels[index] & 0xFF00) >> 8;
                int blue = pixels[index] & 0xFF;
                if (red != green || green != blue) {
                    int grey = (int)Math.round((double)(red + green + blue) / 3.0);
                    pixels[index] = pixels[index] & 0xFF000000 | grey << 16 | grey << 8 | grey;
                }
                ++index;
            }
            index += scansize - w;
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
    }
}

