/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class AbstractSite
implements Site {
    protected double _normal = 0.0;
    protected boolean _hasNormal = false;

    public abstract Figure getFigure();

    public abstract int getID();

    public double getNormal() {
        return this._normal;
    }

    public Point2D getPoint() {
        return this.getPoint(this.getNormal());
    }

    public Point2D getPoint(TransformContext tc) {
        return this.getTransformContext().getTransform(tc).transform(this.getPoint(), null);
    }

    public Point2D getPoint(double normal) {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public Point2D getPoint(TransformContext tc, double normal) {
        AffineTransform transform = this.getTransformContext().getTransform(tc);
        Point2D point = this.getPoint(normal);
        return transform.transform(point, point);
    }

    public TransformContext getTransformContext() {
        return this.getFigure().getParent().getTransformContext();
    }

    public abstract double getX();

    public abstract double getY();

    public boolean hasNormal() {
        return this._hasNormal;
    }

    public boolean isNormal(int direction) {
        return false;
    }

    public void setNormal(double normal) {
        this._hasNormal = true;
        this._normal = CanvasUtilities.moduloAngle(normal);
    }

    public void translate(double x, double y) {
    }
}

