/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasUtilities;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.AbstractConnector;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class StraightConnector
extends AbstractConnector {
    private Point2D _headPt;
    private Point2D _tailPt;

    public StraightConnector(Site tail, Site head) {
        super(tail, head);
        this.setShape(new Line2D.Double());
        this.route();
    }

    public void repositionLabel() {
        if (this.getLabelFigure() != null) {
            Point2D.Double pt = new Point2D.Double((this._headPt.getX() + this._tailPt.getX()) / 2.0, (this._headPt.getY() + this._tailPt.getY()) / 2.0);
            this.getLabelFigure().translateTo(pt);
            this.getLabelFigure().autoAnchor(this.getShape());
        }
    }

    public void route() {
        Point2D headPt;
        Point2D tailPt;
        TransformContext currentContext = this.getTransformContext();
        Site headSite = this.getHeadSite();
        Site tailSite = this.getTailSite();
        this.repaint();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        Point2D tailCenter = tailSite.getFigure() != null ? CanvasUtilities.getCenterPoint(tailSite.getFigure(), currentContext) : tailPt;
        Point2D headCenter = headSite.getFigure() != null ? CanvasUtilities.getCenterPoint(headSite.getFigure(), currentContext) : headPt;
        double x = headCenter.getX() - tailCenter.getX();
        double y = headCenter.getY() - tailCenter.getY();
        double angle = Math.atan2(y, x);
        tailSite.setNormal(angle);
        headSite.setNormal(angle - Math.PI);
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        this._headPt = headPt;
        this._tailPt = tailPt;
        x = headPt.getX() - tailPt.getX();
        y = headPt.getY() - tailPt.getY();
        angle = Math.atan2(y, x);
        if (this.getHeadEnd() != null) {
            this.getHeadEnd().setNormal(angle + Math.PI);
            this.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
            this.getHeadEnd().getConnection(headPt);
        }
        if (this.getTailEnd() != null) {
            this.getTailEnd().setNormal(angle);
            this.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
            this.getTailEnd().getConnection(tailPt);
        }
        ((Line2D)this.getShape()).setLine(tailPt, headPt);
        this.repositionLabel();
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        Line2D line = (Line2D)this.getShape();
        line.setLine(line.getX1() + x, line.getY1() + y, line.getX2() + x, line.getY2() + y);
        if (this.getLabelFigure() != null) {
            this.getLabelFigure().translate(x, y);
        }
        this.repaint();
    }
}

