/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.interactor.PointConstraint;
import java.awt.geom.Point2D;

public class QuadrantConstraint
implements PointConstraint {
    private Point2D _origin;
    private double _originX;
    private double _originY;
    private int _quadrant;

    public QuadrantConstraint(Point2D origin, int quadrant) {
        this.setOrigin(origin);
        this.setQuadrant(quadrant);
    }

    public void constrain(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        switch (this._quadrant) {
            case 2: 
            case 4: {
                if (!(x < this._originX)) break;
                x = this._originX;
                break;
            }
            case 6: 
            case 8: {
                if (!(x > this._originX)) break;
                x = this._originX;
            }
        }
        switch (this._quadrant) {
            case 2: 
            case 8: {
                if (!(y > this._originY)) break;
                y = this._originY;
                break;
            }
            case 4: 
            case 6: {
                if (!(y < this._originY)) break;
                y = this._originY;
            }
        }
        point.setLocation(x, y);
    }

    public Point2D getOrigin() {
        return this._origin;
    }

    public int getQuadrant() {
        return this._quadrant;
    }

    public void setOrigin(Point2D origin) {
        this._origin = origin;
        this._originX = origin.getX();
        this._originY = origin.getY();
    }

    public void setQuadrant(int quadrant) {
        if (quadrant < 2 || quadrant > 6) {
            throw new IllegalArgumentException("Quadrant " + quadrant + " not legal");
        }
        this._quadrant = quadrant;
    }

    public boolean snapped() {
        return false;
    }
}

