/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.util.java2d.PaintedImage;
import diva.util.java2d.PaintedList;
import diva.util.java2d.PaintedObject;
import diva.util.java2d.PaintedPath;
import diva.util.java2d.PaintedShape;
import diva.util.java2d.PaintedString;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import diva.util.xml.XmlElement;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SVGParser {
    private static Class _refClass = null;

    public static String[] colorNames() {
        String[] result = new String[]{"black", "blue", "cyan", "darkgray", "gray", "green", "lightgray", "magenta", "orange", "pink", "red", "white", "yellow"};
        return result;
    }

    public static PaintedObject createPaintedObject(String type, String attributes, String content) {
        HashMap hm = new HashMap();
        SVGParser.hashAttributes(attributes, hm);
        return SVGParser.createPaintedObject(type, hm, content);
    }

    public static PaintedObject createPaintedObject(String type, Map attributes, String content) {
        if (type.equals("rect")) {
            double x = SVGParser._getDouble(attributes, "x", 0.0);
            double y = SVGParser._getDouble(attributes, "y", 0.0);
            double width = SVGParser._getDouble(attributes, "width");
            double height = SVGParser._getDouble(attributes, "height");
            PaintedShape ps = new PaintedShape(new Rectangle2D.Double(x, y, width, height));
            SVGParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("circle")) {
            double cx = SVGParser._getDouble(attributes, "cx", 0.0);
            double cy = SVGParser._getDouble(attributes, "cy", 0.0);
            double r = SVGParser._getDouble(attributes, "r");
            PaintedShape ps = new PaintedShape(new Ellipse2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r));
            SVGParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("ellipse")) {
            double cx = SVGParser._getDouble(attributes, "cx", 0.0);
            double cy = SVGParser._getDouble(attributes, "cy", 0.0);
            double rx = SVGParser._getDouble(attributes, "rx");
            double ry = SVGParser._getDouble(attributes, "ry");
            PaintedShape ps = new PaintedShape(new Ellipse2D.Double(cx - rx, cy - ry, 2.0 * rx, 2.0 * ry));
            SVGParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("line")) {
            double x1 = SVGParser._getDouble(attributes, "x1", 0.0);
            double y1 = SVGParser._getDouble(attributes, "y1", 0.0);
            double x2 = SVGParser._getDouble(attributes, "x2", 0.0);
            double y2 = SVGParser._getDouble(attributes, "y2", 0.0);
            Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            PaintedPath pp = new PaintedPath(line);
            SVGParser.processPaintedPathAttributes(pp, attributes);
            return pp;
        }
        if (type.equals("polyline")) {
            double[] coords = SVGParser.parseCoordString((String)attributes.get("points"));
            Polyline2D.Double poly = new Polyline2D.Double();
            ((Polyline2D)poly).moveTo(coords[0], coords[1]);
            for (int i = 2; i < coords.length; i += 2) {
                ((Polyline2D)poly).lineTo(coords[i], coords[i + 1]);
            }
            PaintedPath pp = new PaintedPath(poly);
            SVGParser.processPaintedPathAttributes(pp, attributes);
            return pp;
        }
        if (type.equals("polygon")) {
            double[] coords = SVGParser.parseCoordString((String)attributes.get("points"));
            Polygon2D.Double poly = new Polygon2D.Double();
            ((Polygon2D)poly).moveTo(coords[0], coords[1]);
            for (int i = 2; i < coords.length; i += 2) {
                ((Polygon2D)poly).lineTo(coords[i], coords[i + 1]);
            }
            poly.closePath();
            PaintedShape ps = new PaintedShape(poly);
            SVGParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("text")) {
            double x = SVGParser._getDouble(attributes, "x", 0.0);
            double y = SVGParser._getDouble(attributes, "y", 0.0);
            PaintedString string = new PaintedString(content);
            SVGParser.processPaintedStringAttributes(string, attributes);
            string.translate(x, y);
            return string;
        }
        if (type.equals("image")) {
            double x = SVGParser._getDouble(attributes, "x", 0.0);
            double y = SVGParser._getDouble(attributes, "y", 0.0);
            double width = SVGParser._getDouble(attributes, "width");
            double height = SVGParser._getDouble(attributes, "height");
            Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, width, height);
            String link = (String)attributes.get("xlink:href");
            URL url = ClassLoader.getSystemResource(link);
            try {
                if (url == null) {
                    if (_refClass == null) {
                        try {
                            _refClass = Class.forName("diva.canvas.toolbox.SVGParser");
                        }
                        catch (ClassNotFoundException ex) {
                            throw new RuntimeException("Could not find diva.canvas.toolbox.SVGParser");
                        }
                    }
                    url = _refClass.getClassLoader().getResource(link);
                }
                if (url == null) {
                    url = new URL(link);
                }
                Toolkit tk = Toolkit.getDefaultToolkit();
                Image img = tk.getImage(url);
                PaintedImage image = new PaintedImage(img, bounds);
                while (!tk.prepareImage(img, -1, -1, image)) {
                    int bitflags = tk.checkImage(img, -1, -1, image);
                    if ((bitflags & 0xC0) != 0) {
                        return null;
                    }
                    Thread.yield();
                }
                return image;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    public static PaintedObject createPaintedObject(String type, Map attributes) {
        return SVGParser.createPaintedObject(type, attributes, null);
    }

    public static void hashAttributes(String s, Map map) {
        StreamTokenizer t = new StreamTokenizer(new StringReader(s));
        t.whitespaceChars(61, 61);
        t.ordinaryChars(48, 57);
        t.ordinaryChar(46);
        String key = "Unknown";
        String val = "Unknown";
        while (true) {
            int ttype = 0;
            try {
                ttype = t.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ttype == -1) break;
            switch (ttype) {
                case -3: {
                    key = t.sval;
                }
            }
            try {
                ttype = t.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ttype == -1) break;
            switch (ttype) {
                case -3: {
                    val = t.sval;
                }
            }
            map.put(key, val);
        }
    }

    private static Color lookupColor(String color) {
        String s = color.toLowerCase();
        if (s.equals("black")) {
            return Color.black;
        }
        if (s.equals("blue")) {
            return Color.blue;
        }
        if (s.equals("cyan")) {
            return Color.cyan;
        }
        if (s.equals("darkgray")) {
            return Color.darkGray;
        }
        if (s.equals("darkgrey")) {
            return Color.darkGray;
        }
        if (s.equals("gray")) {
            return Color.gray;
        }
        if (s.equals("grey")) {
            return Color.gray;
        }
        if (s.equals("green")) {
            return Color.green;
        }
        if (s.equals("lightgray")) {
            return Color.lightGray;
        }
        if (s.equals("lightgrey")) {
            return Color.lightGray;
        }
        if (s.equals("magenta")) {
            return Color.magenta;
        }
        if (s.equals("orange")) {
            return Color.orange;
        }
        if (s.equals("pink")) {
            return Color.pink;
        }
        if (s.equals("red")) {
            return Color.red;
        }
        if (s.equals("white")) {
            return Color.white;
        }
        if (s.equals("yellow")) {
            return Color.yellow;
        }
        Color c = Color.getColor(s);
        if (c == null) {
            try {
                c = Color.decode(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            c = Color.black;
        }
        return c;
    }

    private static double[] parseCoordString(String s) {
        double[] result = new double[4];
        int i = 0;
        StringTokenizer t = new StringTokenizer(s, " ,");
        while (t.hasMoreTokens()) {
            String string = t.nextToken();
            if (string.equals("")) continue;
            result[i++] = Double.parseDouble(string);
            if (i != result.length) continue;
            double[] temp = new double[2 * result.length];
            System.arraycopy(result, 0, temp, 0, result.length);
            result = temp;
        }
        double[] temp = new double[i];
        System.arraycopy(result, 0, temp, 0, i);
        result = temp;
        return result;
    }

    private static void processPaintedShapeAttributes(PaintedShape ps, Map attributes) {
        String style = (String)attributes.get("style");
        if (style != null) {
            StringTokenizer t = new StringTokenizer(style, ";");
            while (t.hasMoreTokens()) {
                String string = t.nextToken().trim();
                int index = string.indexOf(":");
                String name = string.substring(0, index);
                String value = string.substring(index + 1);
                if (name.equals("fill")) {
                    ps.fillPaint = SVGParser.lookupColor(value);
                    continue;
                }
                if (name.equals("stroke")) {
                    ps.strokePaint = SVGParser.lookupColor(value);
                    continue;
                }
                if (!name.equals("stroke-width")) continue;
                ps.setLineWidth(Float.parseFloat(value));
            }
        }
    }

    private static void processPaintedPathAttributes(PaintedPath pp, Map attributes) {
        String style = (String)attributes.get("style");
        if (style != null) {
            StringTokenizer t = new StringTokenizer(style, ";");
            while (t.hasMoreTokens()) {
                String string = t.nextToken().trim();
                int index = string.indexOf(":");
                String name = string.substring(0, index);
                String value = string.substring(index + 1);
                if (name.equals("stroke")) {
                    pp.strokePaint = SVGParser.lookupColor(value);
                    continue;
                }
                if (!name.equals("stroke-width")) continue;
                pp.setLineWidth(Float.parseFloat(value));
            }
        }
    }

    private static void processPaintedStringAttributes(PaintedString pp, Map attributes) {
        String style = (String)attributes.get("style");
        if (style != null) {
            StringTokenizer t = new StringTokenizer(style, ";");
            while (t.hasMoreTokens()) {
                String string = t.nextToken().trim();
                int index = string.indexOf(":");
                String name = string.substring(0, index);
                String value = string.substring(index + 1);
                if (name.equals("font-family")) {
                    pp.setFontName(value);
                    continue;
                }
                if (name.equals("font-size")) {
                    pp.setSize(Integer.parseInt(value));
                    continue;
                }
                if (!name.equals("fill")) continue;
                pp.setFillPaint(SVGParser.lookupColor(value));
            }
        }
    }

    public static PaintedList createPaintedList(XmlElement root) {
        PaintedList list = new PaintedList();
        String name = root.getType();
        if (!name.equals("svg")) {
            throw new IllegalArgumentException("Input XML has a rootname which is '" + name + "' instead of 'svg':" + root);
        }
        Iterator children = root.elements();
        while (children.hasNext()) {
            XmlElement child = (XmlElement)children.next();
            PaintedObject object = SVGParser.createPaintedObject(child.getType(), child.getAttributeMap(), child.getPCData());
            if (object == null) continue;
            list.add(object);
        }
        return list;
    }

    private static double _getDouble(Map map, String name, double def) {
        if (map.containsKey(name)) {
            return Double.parseDouble((String)map.get(name));
        }
        return def;
    }

    private static double _getDouble(Map map, String name) {
        return Double.parseDouble((String)map.get(name));
    }
}

