/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.AbstractStoragePolicy;
import diva.gui.Application;
import diva.gui.Document;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;

public class BasicStoragePolicy
extends AbstractStoragePolicy {
    public boolean close(Document d) {
        if (d != null) {
            try {
                d.close();
            }
            catch (Exception e) {
                d.getApplication().showError("close", e);
                return false;
            }
        }
        return true;
    }

    public Document open(Application app) {
        String dir = this.getDirectory();
        JFileChooser fc = new JFileChooser(dir);
        int result = fc.showOpenDialog(app.getAppContext().makeComponent());
        if (result == 0) {
            Document doc;
            try {
                doc = this.open(fc.getSelectedFile(), app);
            }
            catch (Exception e) {
                app.showError("open", e);
                return null;
            }
            return doc;
        }
        return null;
    }

    public Document open(File file, Application app) {
        Document doc;
        try {
            this.setDirectory(file);
            doc = app.getDocumentFactory().createDocument(app, file);
            doc.open();
        }
        catch (Exception e) {
            app.showError("open", e);
            return null;
        }
        return doc;
    }

    public Document open(URL url, Application app) {
        Document doc;
        try {
            doc = app.getDocumentFactory().createDocument(app, url);
            doc.open();
        }
        catch (Exception e) {
            app.showError("open", e);
            return null;
        }
        return doc;
    }

    public boolean save(Document d) {
        if (d != null) {
            try {
                d.save();
            }
            catch (Exception e) {
                d.getApplication().showError("saveAs", e);
                return false;
            }
        }
        return true;
    }

    public boolean saveAs(Document d) {
        if (d != null) {
            Application app;
            String dir = this.getDirectory();
            JFileChooser fc = new JFileChooser(dir);
            int result = fc.showOpenDialog((app = d.getApplication()).getAppContext().makeComponent());
            if (result == 0) {
                try {
                    d.saveAs(fc.getSelectedFile());
                    this.setDirectory(fc.getSelectedFile());
                }
                catch (Exception e) {
                    d.getApplication().showError("saveAs", e);
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

