/*
 * Decompiled with CFR 0.152.
 */
package diva.gui.toolbox;

import diva.gui.BasicFrame;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreePane
extends JSplitPane {
    private String _selectedTitle = "";
    private JPanel _defaultPanel;
    private JTree _tree;
    private JScrollPane _scrollPane;
    private Dimension _scrollPaneSize = new Dimension(200, 200);

    public JTreePane() {
        this("TreePane");
    }

    public JTreePane(String name) {
        super(0);
        this._defaultPanel = new JPanel();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new Entry(this, null, name, this._defaultPanel));
        DefaultTreeModel model = new DefaultTreeModel(node);
        this._tree = new JTree(model);
        Object[] nodePath = node.getPath();
        TreePath path = new TreePath(nodePath);
        this._tree.expandPath(path);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)JTreePane.this._tree.getLastSelectedPathComponent();
                if (treeNode == null) {
                    return;
                }
                Entry entry = (Entry)treeNode.getUserObject();
                JTreePane.this.setSelectedTitle(entry._title);
                JTreePane.this.refresh();
            }
        });
        this._scrollPane = new JScrollPane(this._tree);
        this.setTopComponent(this._scrollPane);
        this.setBottomComponent(this._defaultPanel);
        this.setContinuousLayout(true);
        this._scrollPane.setPreferredSize(this._scrollPaneSize);
        this.refresh();
    }

    public void addEntry(String parent, String title, JComponent entry) {
        this.addEntry(parent, title, null, entry);
    }

    public void addEntry(String parent, String title, Icon icon, JComponent entry) {
        this.insertEntry(parent, title, icon, entry, null);
    }

    public void addEntry(String parent, String title, Icon icon, JComponent entry, String tip) {
        this.insertEntry(parent, title, icon, entry, tip);
    }

    public String getSelectedTitle() {
        return this._selectedTitle;
    }

    public Icon getIconAt(String title) {
        return this._findEntry((String)title)._icon;
    }

    public Icon getDisabledIconAt(String title) {
        return this._findEntry((String)title)._icon;
    }

    public JTree getTree() {
        return this._tree;
    }

    public JSplitPane getSplitPane() {
        return this;
    }

    public boolean isEnabledAt(String title) {
        return this._findEntry((String)title)._enabled;
    }

    public JComponent getComponentAt(String title) {
        return this._findEntry((String)title)._component;
    }

    public void insertEntry(String parent, String title, Icon icon, JComponent component, String tip) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
        newNode.setUserObject(new Entry(this, icon, title, component));
        DefaultMutableTreeNode parentNode = this._findNode(parent);
        if (parentNode == null) {
            System.out.println("parent == null");
            throw new RuntimeException("Parent not found!");
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.insertNodeInto(newNode, parentNode, 0);
        this.refresh();
    }

    protected void refresh() {
        this._scrollPane.getSize(this._scrollPaneSize);
        this._scrollPane.setPreferredSize(this._scrollPaneSize);
        System.out.println("title = " + this._selectedTitle + " size = " + this._scrollPaneSize);
        Entry entry = this._findEntry(this._selectedTitle);
        if (entry == null || entry._component == null) {
            this.setBottomComponent(this._defaultPanel);
        } else {
            this.setBottomComponent(entry._component);
            if (entry._component != null) {
                entry._component.validate();
            }
        }
        this.validate();
        this.repaint();
    }

    public void removeAll() {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        this.refresh();
    }

    public void removeEntry(String title) {
        this._findEntry(title);
        this.refresh();
    }

    public void setDisabledIconAt(String title, Icon icon) {
        this._findEntry(title);
    }

    public void setEnabledAt(String title, boolean enabled) {
        Entry p = this._findEntry(title);
        p._enabled = enabled;
    }

    public void setIconAt(String title, Icon icon) {
        Entry p = this._findEntry(title);
        p._icon = icon;
    }

    public void setSelectedTitle(String title) {
        if (title.equals(this._selectedTitle)) {
            this._selectedTitle = title;
            System.out.println("SELECTING: " + this._selectedTitle);
            DefaultMutableTreeNode node = this._findNode(title);
            Object[] nodePath = node.getPath();
            TreePath path = new TreePath(nodePath);
            this._tree.setSelectionPath(path);
            this.refresh();
        }
    }

    public void setTitleAt(String title, String newTitle) {
        Entry p = this._findEntry(title);
        p._title = newTitle;
    }

    private Entry _findEntry(String title) {
        DefaultMutableTreeNode node = this._findNode(title);
        if (node == null) {
            return null;
        }
        return (Entry)this._findNode(title).getUserObject();
    }

    private DefaultMutableTreeNode _findNode(String title) {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        if (title == null) {
            return root;
        }
        Enumeration<TreeNode> nodes = root.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Entry entry = (Entry)node.getUserObject();
            if (entry == null || !entry._title.equals(title)) continue;
            return node;
        }
        return null;
    }

    public static void main(String[] argv) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        JTreePane sp = new JTreePane();
                        sp.addEntry(null, "Foo", new JLabel("foo's component"));
                        sp.addEntry(null, "Bar", new JLabel("bar's component"));
                        sp.addEntry(null, "Baz", new JLabel("baz's component"));
                        sp.addEntry(null, "Moo", new JLabel("moo's component"));
                        BasicFrame f = new BasicFrame("Entry test");
                        f.getContentPane().add("Center", sp);
                        f.setSize(600, 400);
                        ((Window)f).setVisible(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private static class Entry {
        JTreePane _parent;
        Icon _icon;
        String _title;
        JComponent _component;
        boolean _enabled;

        Entry(JTreePane parent, Icon icon, String title, JComponent component) {
            this._icon = icon;
            this._title = title;
            this._parent = parent;
            this._component = component;
            this._enabled = true;
        }

        public String toString() {
            return this._title;
        }
    }
}

