/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PaintedObject;
import diva.util.java2d.ShapeUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PaintedString
implements PaintedObject {
    private String _string;
    private static Font _defaultFont = new Font("Serif", 0, 16);
    private Font _font;
    private Paint _fillPaint = Color.black;
    private AffineTransform _transform = new AffineTransform();
    private List _shapes = new ArrayList();
    private Rectangle2D _bounds;

    public PaintedString() {
        this("");
    }

    public PaintedString(String s) {
        this._string = s;
        this._font = _defaultFont;
        this._update();
    }

    public PaintedString(String s, Font f) {
        this._string = s;
        this._font = f;
        this._update();
    }

    public PaintedString(String s, String face, int style, int size) {
        this._string = s;
        this._font = new Font(face, style, size);
        this._update();
    }

    public Rectangle2D getBounds() {
        if (this._bounds == null) {
            this._update();
        }
        return this._bounds;
    }

    public Font getFont() {
        return this._font;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    public String getFontName() {
        return this._font.getFontName();
    }

    public int getStyle() {
        return this._font.getStyle();
    }

    public int getSize() {
        return this._font.getSize();
    }

    public Shape getShape() {
        if (this._bounds == null) {
            this._update();
        }
        return this._bounds;
    }

    public String getString() {
        return this._string;
    }

    public void paint(Graphics2D g) {
        if (this._bounds == null) {
            this._update();
        }
        if (this.getString() != null) {
            g.setPaint(this._fillPaint);
            for (Shape shape : this._shapes) {
                g.fill(shape);
            }
        }
    }

    public void setFillPaint(Paint p) {
        this._fillPaint = p;
    }

    public void setFont(Font f) {
        this._font = f;
        this._bounds = null;
    }

    public void setFontName(String s) {
        this.setFont(new Font(s, this._font.getStyle(), this._font.getSize()));
    }

    public void setStyle(int style) {
        this.setFont(new Font(this._font.getFontName(), style, this._font.getSize()));
    }

    public void setSize(int size) {
        this.setFont(new Font(this._font.getFontName(), this._font.getStyle(), size));
    }

    public void setString(String s) {
        this._string = s;
        this._bounds = null;
    }

    public void setTransform(AffineTransform at) {
        this._transform = at;
        this._bounds = null;
    }

    public void transform(AffineTransform at) {
        this._transform.preConcatenate(at);
        this._bounds = null;
    }

    public void translate(double x, double y) {
        this._transform.translate(x, y);
        this._bounds = null;
    }

    private void _update() {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        StringTokenizer lines = new StringTokenizer(this._string, "\n", true);
        double dy = this._font.getMaxCharBounds(frc).getHeight();
        double x = 0.0;
        double y = 0.0;
        this._bounds = null;
        this._shapes.clear();
        while (lines.hasMoreElements()) {
            String line = lines.nextToken();
            if (line.equals("\n")) {
                y += dy;
                continue;
            }
            GlyphVector gv = this._font.createGlyphVector(frc, line);
            Shape s = gv.getOutline();
            s = this._transform.createTransformedShape(s);
            Rectangle2D b = s.getBounds2D();
            if (this._bounds == null) {
                this._bounds = b;
                this._shapes.add(s);
                continue;
            }
            Rectangle2D.union(this._bounds, (Rectangle2D)ShapeUtilities.translateModify(b, x, y), this._bounds);
            this._shapes.add(ShapeUtilities.translateModify(s, x, y));
        }
    }
}

