/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.Polygon2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class PolygonIterator
implements PathIterator {
    private double[] _coords;
    private int _index = 0;
    private boolean _done = false;

    public PolygonIterator(Polygon2D pl, AffineTransform at) {
        int count = pl.getVertexCount() * 2;
        this._coords = new double[count];
        if (pl instanceof Polygon2D.Float) {
            Polygon2D.Float f = (Polygon2D.Float)pl;
            if (at == null || at.isIdentity()) {
                for (int i = 0; i < count; ++i) {
                    this._coords[i] = f._coords[i];
                }
            } else {
                at.transform(f._coords, 0, this._coords, 0, count / 2);
            }
        } else {
            Polygon2D.Double d = (Polygon2D.Double)pl;
            if (at == null || at.isIdentity()) {
                System.arraycopy(d._coords, 0, this._coords, 0, count);
            } else {
                at.transform(d._coords, 0, this._coords, 0, count / 2);
            }
        }
    }

    public int currentSegment(double[] coords) {
        if (this._index == this._coords.length) {
            if (this._done) {
                return 4;
            }
            coords[0] = this._coords[0];
            coords[1] = this._coords[1];
            return 1;
        }
        coords[0] = this._coords[this._index];
        coords[1] = this._coords[this._index + 1];
        if (this._index == 0) {
            return 0;
        }
        return 1;
    }

    public int currentSegment(float[] coords) {
        if (this._index == this._coords.length) {
            if (this._done) {
                return 4;
            }
            coords[0] = (float)this._coords[0];
            coords[1] = (float)this._coords[1];
            return 1;
        }
        coords[0] = (float)this._coords[this._index];
        coords[1] = (float)this._coords[this._index + 1];
        if (this._index == 0) {
            return 0;
        }
        return 1;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this._done;
    }

    public void next() {
        if (this._index == this._coords.length) {
            this._done = true;
        } else {
            this._index += 2;
        }
    }
}

