/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.exceptions;

import alma.ACSErr.ErrorTrace;
import alma.ACSErr.NameValue;
import java.util.Properties;

public class ErrorTraceManipulator {
    public static Properties getProperties(ErrorTrace et) {
        Properties props = new Properties();
        if (et.data != null) {
            for (int i = 0; i < et.data.length; ++i) {
                NameValue nv = et.data[i];
                if (nv.name == null) continue;
                props.setProperty(nv.name, nv.value);
            }
        }
        return props;
    }

    public static String getProperty(ErrorTrace et, String key) {
        String value = null;
        if (et.data != null) {
            for (int i = 0; i < et.data.length; ++i) {
                NameValue nv = et.data[i];
                if (!nv.name.equals(key)) continue;
                value = nv.value;
                break;
            }
        }
        return value;
    }

    public static String setProperty(ErrorTrace et, String key, String value) {
        String oldValue = null;
        boolean alreadyThere = false;
        if (et.data != null) {
            for (int i = 0; i < et.data.length; ++i) {
                NameValue nv = et.data[i];
                if (!nv.name.equals(key)) continue;
                alreadyThere = true;
                oldValue = nv.value;
                nv.value = value;
                break;
            }
        }
        if (!alreadyThere) {
            NameValue[] oldNVs = et.data;
            int oldLength = 0;
            if (oldNVs == null) {
                et.data = new NameValue[1];
            } else {
                oldLength = oldNVs.length;
                et.data = new NameValue[oldLength + 1];
                System.arraycopy(oldNVs, 0, et.data, 0, oldLength);
            }
            et.data[oldLength] = new NameValue(key, value);
        }
        return oldValue;
    }
}

