/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.ArrayList;
import jsky.catalog.AbstractSearchCondition;
import jsky.catalog.ArraySearchCondition;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryArgs;
import jsky.catalog.RangeSearchCondition;
import jsky.catalog.SearchCondition;
import jsky.catalog.ValueRange;
import jsky.catalog.ValueSearchCondition;
import jsky.coords.CoordinateRadius;

public class BasicQueryArgs
implements QueryArgs {
    private Catalog _catalog;
    private Object[] _values;
    private int _maxRows;
    private String _id;
    private CoordinateRadius _region;
    private String _queryType;

    public BasicQueryArgs(Catalog catalog) {
        this._catalog = catalog;
        int n = this._catalog.getNumParams();
        if (n != 0) {
            this._values = new Object[n];
            for (int i = 0; i < n; ++i) {
                FieldDesc param = this._catalog.getParamDesc(i);
                this._values[i] = param != null ? param.getDefaultValue() : null;
            }
        }
    }

    @Override
    public void setParamValue(int i, Object value) {
        this._values[i] = value;
    }

    @Override
    public void setParamValue(String label, Object value) {
        int n = this._catalog.getNumParams();
        for (int i = 0; i < n; ++i) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param == null) continue;
            String name = param.getName();
            String id = param.getId();
            if ((id == null || !id.equalsIgnoreCase(label)) && (name == null || !name.equalsIgnoreCase(label))) continue;
            this.setParamValue(i, value);
            return;
        }
    }

    @Override
    public void setParamValueRange(String label, Object minValue, Object maxValue) {
        int n = this._catalog.getNumParams();
        for (int i = 0; i < n; ++i) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param == null) continue;
            String name = param.getName();
            String id = param.getId();
            if ((id == null || !id.equalsIgnoreCase(label)) && (name == null || !name.equalsIgnoreCase(label))) continue;
            if (param.isMin()) {
                this.setParamValue(i, minValue);
                continue;
            }
            if (!param.isMax()) continue;
            this.setParamValue(i, maxValue);
        }
    }

    @Override
    public void setParamValue(String label, int value) {
        this.setParamValue(label, (Object)new Integer(value));
    }

    @Override
    public void setParamValueRange(String label, double minValue, double maxValue) {
        this.setParamValueRange(label, new Double(minValue), new Double(maxValue));
    }

    @Override
    public void setParamValue(String label, double value) {
        this.setParamValue(label, (Object)new Double(value));
    }

    @Override
    public void setParamValues(Object[] values) {
        this._values = values;
    }

    @Override
    public Object getParamValue(int i) {
        return this._values != null ? this._values[i] : null;
    }

    @Override
    public Object getParamValue(String label) {
        int n = this._catalog.getNumParams();
        for (int i = 0; i < n; ++i) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param == null) continue;
            String name = param.getName();
            String id = param.getId();
            if ((id == null || !id.equalsIgnoreCase(label)) && (name == null || !name.equalsIgnoreCase(label))) continue;
            return this.getParamValue(i);
        }
        return null;
    }

    @Override
    public int getParamValueAsInt(String label, int defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return defaultValue;
    }

    @Override
    public double getParamValueAsDouble(String label, double defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        return defaultValue;
    }

    @Override
    public String getParamValueAsString(String label, String defaultValue) {
        Object o = this.getParamValue(label);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public CoordinateRadius getRegion() {
        return this._region;
    }

    @Override
    public void setRegion(CoordinateRadius region) {
        this._region = region;
    }

    @Override
    public Catalog getCatalog() {
        return this._catalog;
    }

    @Override
    public SearchCondition[] getConditions() {
        if (this._values == null) {
            return null;
        }
        int n = this._catalog.getNumParams();
        ArrayList<AbstractSearchCondition> v = new ArrayList<AbstractSearchCondition>(n);
        for (int i = 0; i < n; ++i) {
            if (this._values[i] == null) continue;
            FieldDesc p = this._catalog.getParamDesc(i);
            FieldDesc nextP = null;
            if (i + 1 < n) {
                nextP = this._catalog.getParamDesc(i + 1);
            }
            if (p == null) continue;
            if (this._values[i] instanceof ValueRange) {
                ValueRange r = (ValueRange)this._values[i];
                v.add(new RangeSearchCondition(p, r.getMinValue(), r.isMinInclusive(), r.getMaxValue(), r.isMaxInclusive()));
                continue;
            }
            if (this._values[i] instanceof Comparable) {
                if (p.isMin()) {
                    if (nextP != null && nextP.isMax() && nextP.getId().equals(p.getId())) {
                        v.add(new RangeSearchCondition(p, (Comparable)this._values[i], (Comparable)this._values[i + 1]));
                        ++i;
                        continue;
                    }
                    v.add(new RangeSearchCondition(p, (Comparable)this._values[i], null));
                    continue;
                }
                if (p.isMax()) {
                    v.add(new RangeSearchCondition(p, null, (Comparable)this._values[i]));
                    continue;
                }
                v.add(new ValueSearchCondition(p, (Comparable)this._values[i]));
                continue;
            }
            if (!(this._values[i] instanceof Object[])) continue;
            v.add(new ArraySearchCondition(p, (Object[])this._values[i]));
        }
        n = v.size();
        if (n == 0) {
            return null;
        }
        SearchCondition[] sc = new SearchCondition[n];
        v.toArray(sc);
        return sc;
    }

    @Override
    public int getMaxRows() {
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    @Override
    public String getQueryType() {
        return this._queryType;
    }

    @Override
    public void setQueryType(String queryType) {
        this._queryType = queryType;
    }

    public String toString() {
        SearchCondition[] sc = this.getConditions();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sc.length; ++i) {
            sb.append(sc[i].toString());
            if (i >= sc.length - 1) continue;
            sb.append("&");
        }
        return sb.toString();
    }
}

