/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jsky.catalog.gui.html.HTMLViewerHistoryItem;
import jsky.catalog.gui.html.HTMLViewerMenuBar;
import jsky.util.FileUtil;
import jsky.util.Preferences;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GenericToolBarTarget;
import jsky.util.gui.SwingUtil;

public class HTMLViewer
extends JPanel
implements GenericToolBarTarget {
    protected JEditorPane html;
    protected URL url;
    protected static JFileChooser fileChooser;
    protected EventListenerList listenerList = new EventListenerList();
    protected Stack<HTMLViewerHistoryItem> backStack = new Stack();
    protected Stack<HTMLViewerHistoryItem> forwStack = new Stack();
    protected boolean noStack = false;
    protected LinkedList<HTMLViewerHistoryItem> historyList;
    protected static final String HISTORY_LIST_NAME = "htmlViewerHistoryList";
    protected int maxHistoryItems = 20;
    protected AbstractAction openAction = new AbstractAction("Open"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.open();
        }
    };
    protected AbstractAction backAction = new AbstractAction("Back"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.back();
        }
    };
    protected AbstractAction forwAction = new AbstractAction("Forward"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.forward();
        }
    };
    protected AbstractAction saveAsAction = new AbstractAction("Save As"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.saveAs();
        }
    };
    protected AbstractAction printAction = new AbstractAction("Print..."){

        @Override
        public void actionPerformed(ActionEvent evt) {
            HTMLViewer.this.print();
        }
    };

    public HTMLViewer() {
        this.html = new JEditorPane();
        this.html.setEditable(false);
        this.html.setContentType("text/html");
        this.html.addHyperlinkListener(this.createHyperLinkListener());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.html), "Center");
        this.loadHistory();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HTMLViewer.this.saveHistory(true);
            }
        });
        this.backAction.setEnabled(false);
        this.forwAction.setEnabled(false);
    }

    public HTMLViewer(URL url) {
        this();
        this.setPage(url);
    }

    public JEditorPane getEditorPane() {
        return this.html;
    }

    public void setPage(final URL url) {
        if (url == null) {
            return;
        }
        this.addToHistory();
        this.url = url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HTMLViewer.this.html.setPage(url);
                    HTMLViewer.this.fireChange(new ChangeEvent(this));
                }
                catch (Exception ex) {
                    DialogUtil.error(ex);
                }
            }
        });
    }

    public void setText(String text) {
        try {
            this.addToHistory();
            this.html.setText(text);
            this.url = null;
            this.fireChange(new ChangeEvent(this));
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    protected HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HTMLViewer.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        HTMLViewer.this.setPage(e.getURL());
                    }
                }
            }
        };
    }

    public void open() {
        int option;
        if (fileChooser == null) {
            fileChooser = this.makeFileChooser();
        }
        if ((option = fileChooser.showOpenDialog(this)) == 0 && fileChooser.getSelectedFile() != null) {
            this.open(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected JFileChooser makeFileChooser() {
        return new JFileChooser(new File("."));
    }

    public void open(String fileOrUrl) {
        URL url = FileUtil.makeURL(null, fileOrUrl);
        this.setPage(url);
    }

    public void openURL() {
        String urlStr = DialogUtil.input("Enter the World Wide Web location (URL) to display:");
        if (urlStr != null) {
            URL url;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error(e);
                return;
            }
            this.setPage(url);
        }
    }

    public void close() {
        JFrame parent = SwingUtil.getFrame(this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }

    public void back() {
        if (this.backStack.size() == 0) {
            return;
        }
        if (this.url != null) {
            this.forwStack.push(this.makeHTMLViewerHistoryItem());
            this.forwAction.setEnabled(true);
        }
        HTMLViewerHistoryItem historyItem = this.backStack.pop();
        if (this.backStack.size() == 0) {
            this.backAction.setEnabled(false);
        }
        HTMLViewerMenuBar.setCurrentHTMLViewer(this);
        this.noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this.noStack = false;
    }

    public void forward() {
        if (this.forwStack.size() == 0) {
            return;
        }
        if (this.url != null) {
            this.backStack.push(this.makeHTMLViewerHistoryItem());
            this.backAction.setEnabled(true);
        }
        HTMLViewerHistoryItem historyItem = this.forwStack.pop();
        if (this.forwStack.size() == 0) {
            this.forwAction.setEnabled(false);
        }
        HTMLViewerMenuBar.setCurrentHTMLViewer(this);
        this.noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this.noStack = false;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange(ChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    protected void addToHistory() {
        if (this.url == null) {
            return;
        }
        HTMLViewerHistoryItem historyItem = this.makeHTMLViewerHistoryItem();
        if (historyItem == null) {
            return;
        }
        if (!this.noStack) {
            this.backStack.push(historyItem);
            this.backAction.setEnabled(true);
            if (this.forwStack.size() != 0) {
                this.forwStack.clear();
                this.forwAction.setEnabled(false);
            }
        }
        this.addToHistory(historyItem);
    }

    protected void addToHistory(HTMLViewerHistoryItem historyItem) {
        ListIterator it = ((LinkedList)this.historyList.clone()).listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            HTMLViewerHistoryItem item = (HTMLViewerHistoryItem)it.next();
            if (item.title.equals(historyItem.title)) {
                this.historyList.remove(i);
            }
            ++i;
        }
        this.historyList.addFirst(historyItem);
        if (this.historyList.size() > this.maxHistoryItems) {
            this.historyList.removeLast();
        }
    }

    protected HTMLViewerHistoryItem makeHTMLViewerHistoryItem() {
        String title = this.url.toString();
        if (title != null) {
            return new HTMLViewerHistoryItem(title, this.url);
        }
        return null;
    }

    public int getMaxHistoryItems() {
        return this.maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this.maxHistoryItems = n;
    }

    public void addHistoryMenuItems(JMenu menu) {
        ListIterator<HTMLViewerHistoryItem> it = this.historyList.listIterator(0);
        while (it.hasNext()) {
            menu.add(it.next());
        }
    }

    protected void cleanupHistoryList() {
        ListIterator<HTMLViewerHistoryItem> it = this.historyList.listIterator(0);
        while (it.hasNext()) {
            HTMLViewerHistoryItem item = it.next();
            if (item.getURLStr() != null) continue;
            it.remove();
        }
    }

    protected LinkedList mergeHistoryList() {
        LinkedList<HTMLViewerHistoryItem> savedHistory = this.historyList;
        this.loadHistory();
        ListIterator<HTMLViewerHistoryItem> it = savedHistory.listIterator(savedHistory.size());
        while (it.hasPrevious()) {
            this.addToHistory(it.previous());
        }
        return this.historyList;
    }

    public void clearHistory() {
        this.historyList = new LinkedList();
        this.backAction.setEnabled(false);
        this.backStack.clear();
        this.forwAction.setEnabled(false);
        this.forwStack.clear();
        this.saveHistory(false);
    }

    protected void saveHistory(boolean merge) {
        try {
            LinkedList<HTMLViewerHistoryItem> l = merge ? this.mergeHistoryList() : this.historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadHistory() {
        try {
            this.historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
            this.cleanupHistoryList();
        }
        catch (Exception e) {
            this.historyList = new LinkedList();
        }
    }

    public void saveAs() {
    }

    public void print() {
    }

    @Override
    public AbstractAction getOpenAction() {
        return this.openAction;
    }

    public AbstractAction getSaveAsAction() {
        return this.saveAsAction;
    }

    public AbstractAction getPrintAction() {
        return this.printAction;
    }

    @Override
    public AbstractAction getBackAction() {
        return this.backAction;
    }

    @Override
    public AbstractAction getForwAction() {
        return this.forwAction;
    }
}

