/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.vo;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.catalog.vo.VoTable;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoords;
import jsky.util.NameValue;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.vo.ConeSearch;
import uk.ac.starlink.vo.DalQuery;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;

public class VoCatalog
implements PlotableCatalog,
Serializable {
    private static final long serialVersionUID = 1L;
    private URL _url;
    private String _name;
    private String _description;
    private URL _docURL;
    private String _id;
    private String _standardId;
    private transient CatalogDirectory _parent;
    private transient FieldDesc[] _fieldDesc;
    private transient ProgressPanel _progressPanel;
    private transient TablePlotSymbol[] _symbols;
    private transient boolean _symbolsEdited = false;
    private transient VoTable _voTable;

    public VoCatalog(RegResource resource, RegCapabilityInterface capability, CatalogDirectory parent) {
        this._parent = parent;
        this._name = resource.getTitle();
        if (this._name == null) {
            this._name = resource.getShortName();
        }
        if (this._name == null) {
            this._name = "unknown";
        }
        try {
            this._url = new URL(capability.getAccessUrl());
        }
        catch (Exception e) {
            throw new RuntimeException("Error in access URL for: " + this._name, e);
        }
        this.initQueryArgs();
        this._description = resource.getPublisher();
        if (resource.getReferenceUrl() != null && resource.getReferenceUrl().length() != 0) {
            try {
                this._docURL = new URL(resource.getReferenceUrl());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._id = resource.getIdentifier();
        this._standardId = capability.getStandardId();
    }

    public VoCatalog(VoTable voTable) throws IOException {
        this._voTable = voTable;
        this._voTable.setCatalog(this);
        this.setName(voTable.getName());
        this.initQueryArgs();
    }

    void initQueryArgs() {
        FieldDescAdapter p;
        ArrayList<FieldDescAdapter> params = new ArrayList<FieldDescAdapter>();
        if (this._voTable == null || this._voTable.hasCoordinates()) {
            p = new FieldDescAdapter("Object");
            p.setDescription("Enter the name of the object");
            params.add(p);
            p = new FieldDescAdapter("Name Server");
            p.setDescription("Select the name server to use to resolve the object name");
            List<Catalog> l = SkycatConfigFile.getConfigFile().getNameServers();
            NameValue[] ar = new NameValue[l.size()];
            for (int i = 0; i < ar.length; ++i) {
                Catalog cat = l.get(i);
                ar[i] = new NameValue(cat.getName(), cat);
            }
            p.setOptions(ar);
            params.add(p);
            p = new FieldDescAdapter("RA");
            p.setIsRA(true);
            p.setDescription("Right Ascension in the selected equinox, format: hh:mm:ss.sss");
            params.add(p);
            p = new FieldDescAdapter("Dec");
            p.setDescription("Declination in the selected equinox, format: dd:mm:ss.sss");
            p.setIsDec(true);
            params.add(p);
            p = new FieldDescAdapter("Equinox");
            p.setDescription("Equinox of RA and Dec");
            p.setOptions(SkycatConfigEntry.getEquinoxOptions());
            params.add(p);
            p = new FieldDescAdapter("Max Radius");
            p.setDescription("The search radius from the center coordinates in arcmin");
            p.setFieldClass(Double.class);
            p.setUnits("arcmin");
            params.add(p);
        }
        p = new FieldDescAdapter("Max Objects");
        p.setDescription("The maximum number of objects to return");
        p.setFieldClass(Integer.class);
        p.setDefaultValue(1000);
        params.add(p);
        FieldDescAdapter[] fd = new FieldDescAdapter[params.size()];
        params.toArray(fd);
        this._fieldDesc = fd;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public URL getDocURL() {
        return this._docURL;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumParams() {
        return this._fieldDesc.length;
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        return this._fieldDesc[i];
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        for (FieldDesc fd : this._fieldDesc) {
            if (!fd.getName().equals(name)) continue;
            return fd;
        }
        return null;
    }

    @Override
    public CatalogDirectory getParent() {
        return this._parent;
    }

    @Override
    public Catalog[] getPath() {
        CatalogDirectory parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath(this);
    }

    @Override
    public String getTitle() {
        return this._name;
    }

    @Override
    public String getType() {
        if (this._voTable != null) {
            return "local";
        }
        if ("ivo://ivoa.net/std/ConeSearch".equals(this._standardId)) {
            return "catalog";
        }
        return "archive";
    }

    @Override
    public boolean isImageServer() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return this._voTable != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        this._setRegion(queryArgs);
        this._setMaxRows(queryArgs);
        int maxRows = queryArgs.getMaxRows();
        if (this._voTable != null) {
            if (!this._voTable.hasCoordinates() && queryArgs.getMaxRows() >= this._voTable.getRowCount()) {
                return this._voTable;
            }
            QueryResult result = this._voTable.query(queryArgs);
            if (result instanceof TableQueryResult) {
                ((TableQueryResult)result).setCatalog(this);
            }
            return result;
        }
        CoordinateRadius cr = queryArgs.getRegion();
        if (cr == null) {
            cr = new CoordinateRadius(new WorldCoords(), 15.0);
        }
        Coordinates coords = cr.getCenterPosition();
        double ra = coords.getX();
        double dec = coords.getY();
        double radius = cr.getMaxRadius();
        this._progressPanel = this._getProgressPanel("Downloading query results");
        this._progressPanel.start();
        try {
            DalQuery sq;
            StarTableFactory factory = new StarTableFactory();
            StarTable starTable = null;
            if ("ivo://ivoa.net/std/SIA".equals(this._standardId)) {
                this._progressPanel.setText("Performing SIAP query: " + this._url);
                sq = new DalQuery(this._url.toString(), ra, dec, radius / 60.0);
                starTable = sq.execute(factory);
            } else if ("ivo://ivoa.net/std/ConeSearch".equals(this._standardId)) {
                this._progressPanel.setText("Performing cone search: " + this._url);
                ConeSearch cs = new ConeSearch(this._url.toString());
                starTable = cs.performSearch(ra, dec, radius / 60.0, 0, factory);
            } else if ("ivo://ivoa.net/std/SSA".equals(this._standardId)) {
                this._progressPanel.setText("Performing SSA query: " + this._url);
                sq = new DalQuery(this._url.toString(), ra, dec, radius / 60.0);
                sq.addArgument("REQUEST", "queryData");
                starTable = sq.execute(factory);
            }
            if (this._progressPanel.isInterrupted()) {
                throw new ProgressException("Interrupted");
            }
            if (starTable == null) {
                throw new RuntimeException("Catalog type not supported: " + this._standardId);
            }
            VoTable voTable = VoTable.createVoTable(starTable, this, maxRows);
            return voTable;
        }
        finally {
            this._progressPanel.stop();
        }
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setParent(CatalogDirectory parent) {
        this._parent = parent;
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
        Coordinates coords = region.getCenterPosition();
        WorldCoords pos = (WorldCoords)coords;
        String[] radec = pos.format();
        queryArgs.setParamValue("RA", (Object)radec[0]);
        queryArgs.setParamValue("Dec", (Object)radec[1]);
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        queryArgs.setParamValue("Equinox", (Object)equinoxStr);
        queryArgs.setParamValue("Max Radius", region.getMaxRadius());
        queryArgs.setParamValue("Width", region.getWidth());
        queryArgs.setParamValue("Height", region.getHeight());
    }

    private void _setRegion(QueryArgs queryArgs) throws IOException {
        WorldCoords wcs;
        String objectName = (String)queryArgs.getParamValue("Object");
        if (objectName == null || objectName.length() == 0) {
            String raStr = (String)queryArgs.getParamValue("RA");
            String decStr = (String)queryArgs.getParamValue("Dec");
            if (raStr == null || decStr == null) {
                return;
            }
            double equinox = this._getEquinox(queryArgs);
            wcs = new WorldCoords(raStr, decStr, equinox, true);
        } else {
            Object o = queryArgs.getParamValue("Name Server");
            if (!(o instanceof Catalog)) {
                throw new RuntimeException("No name server was specified");
            }
            wcs = this._resolveObjectName(objectName, (Catalog)o);
            queryArgs.setParamValue("RA", (Object)wcs.getRA().toString());
            queryArgs.setParamValue("Dec", (Object)wcs.getDec().toString());
            queryArgs.setParamValue("Equinox", (Object)"2000");
        }
        double radius = queryArgs.getParamValueAsDouble("Max Radius", 10.0);
        queryArgs.setRegion(new CoordinateRadius(wcs, radius));
    }

    protected void _setMaxRows(QueryArgs queryArgs) {
        if (queryArgs.getMaxRows() != 0) {
            return;
        }
        Integer maxObjects = (Integer)queryArgs.getParamValue("Max Objects");
        if (maxObjects != null) {
            queryArgs.setMaxRows(maxObjects);
        }
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        double equinox = 2000.0;
        if (equinoxStr != null && equinoxStr.endsWith("1950")) {
            equinox = 1950.0;
        }
        return equinox;
    }

    private WorldCoords _resolveObjectName(String objectName, Catalog cat) throws IOException {
        Coordinates coords;
        BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
        queryArgs.setId(objectName);
        QueryResult r = cat.query(queryArgs);
        if (r instanceof TableQueryResult && (coords = ((TableQueryResult)r).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coords;
        }
        throw new RuntimeException("Unexpected result from " + cat.toString());
    }

    protected ProgressPanel _getProgressPanel(String title) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel(title);
        } else {
            this._progressPanel.setTitle(title);
        }
        return this._progressPanel;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setSymbols(TablePlotSymbol[] symbols) {
        this._symbols = symbols;
    }

    @Override
    public void setSymbolsEdited(boolean edited) {
        this._symbolsEdited = edited;
    }

    @Override
    public boolean isSymbolsEdited() {
        return this._symbolsEdited;
    }

    @Override
    public void saveSymbolConfig() {
        AstroCatConfig.getConfigFile().save();
    }

    @Override
    public int getNumSymbols() {
        return this.getSymbols().length;
    }

    @Override
    public TablePlotSymbol getSymbolDesc(int i) {
        return this.getSymbols()[i];
    }

    @Override
    public TablePlotSymbol[] getSymbols() {
        if (this._symbols == null) {
            this._symbols = new TablePlotSymbol[]{new TablePlotSymbol(null, "", "square yellow", "4")};
        }
        return this._symbols;
    }

    public VoTable getVoTable() {
        return this._voTable;
    }

    @Override
    public Catalog reload() {
        return this;
    }
}

