/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;

public class slasubs {
    private static final double TINY = 1.0E-6;
    public static final double D2PI = Math.PI * 2;

    public static double[] slaDcs2c(double a, double b) {
        double cosb = Math.cos(b);
        double[] v = new double[]{Math.cos(a) * cosb, Math.sin(a) * cosb, Math.sin(b)};
        return v;
    }

    public static double[] slaDmxv(double[][] dm, double[] va) {
        int j;
        double[] vw = new double[3];
        double[] vb = new double[3];
        for (j = 0; j < 3; ++j) {
            double w = 0.0;
            for (int i = 0; i < 3; ++i) {
                w += dm[j][i] * va[i];
            }
            vw[j] = w;
        }
        for (j = 0; j < 3; ++j) {
            vb[j] = vw[j];
        }
        return vb;
    }

    public static Point2D.Double slaDcc2s(double[] v) {
        double x = v[0];
        double y = v[1];
        double z = v[2];
        double r = Math.sqrt(x * x + y * y);
        Point2D.Double result = new Point2D.Double();
        result.x = r != 0.0 ? Math.atan2(y, x) : 0.0;
        result.y = z != 0.0 ? Math.atan2(z, r) : 0.0;
        return result;
    }

    public static double slaDranrm(double angle) {
        double w = Math.IEEEremainder(angle, Math.PI * 2);
        return w >= 0.0 ? w : w + Math.PI * 2;
    }

    public static double[][] slaDeuler(String order, double phi, double theta, double psi) {
        int i;
        int j;
        double[][] result = new double[3][3];
        double[][] rotn = new double[3][3];
        double[][] wm = new double[3][3];
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 3; ++i) {
                result[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        int l = order.length();
        for (int n = 0; n < 3; ++n) {
            double angle;
            if (n > l) continue;
            for (j = 0; j < 3; ++j) {
                for (i = 0; i < 3; ++i) {
                    rotn[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            switch (n) {
                default: {
                    angle = phi;
                    break;
                }
                case 1: {
                    angle = theta;
                    break;
                }
                case 2: {
                    angle = psi;
                }
            }
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            char axis = order.charAt(n);
            if (axis == 'X' || axis == 'x' || axis == '1') {
                rotn[1][1] = c;
                rotn[1][2] = s;
                rotn[2][1] = -s;
                rotn[2][2] = c;
            } else if (axis == 'Y' || axis == 'y' || axis == '2') {
                rotn[0][0] = c;
                rotn[0][2] = -s;
                rotn[2][0] = s;
                rotn[2][2] = c;
            } else if (axis == 'Z' || axis == 'z' || axis == '3') {
                rotn[0][0] = c;
                rotn[0][1] = s;
                rotn[1][0] = -s;
                rotn[1][1] = c;
            } else {
                l = 0;
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    double w = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        w += rotn[i][k] * result[k][j];
                    }
                    wm[i][j] = w;
                }
            }
            for (j = 0; j < 3; ++j) {
                for (i = 0; i < 3; ++i) {
                    result[i][j] = wm[i][j];
                }
            }
        }
        return result;
    }

    public static double[] slDE2H(double HA, double DEC, double PHI) {
        double[] AZEL = new double[2];
        double SH = Math.sin(HA);
        double CH = Math.cos(HA);
        double SD = Math.sin(DEC);
        double CD = Math.cos(DEC);
        double SP = Math.sin(PHI);
        double CP = Math.cos(PHI);
        double X = -CH * CD * SP + SD * CP;
        double Y = -SH * CD;
        double Z = CH * CD * CP + SD * SP;
        double R = Math.sqrt(X * X + Y * Y);
        double A = R == 0.0 ? 0.0 : Math.atan2(Y, X);
        if (A < 0.0) {
            A += Math.PI * 2;
        }
        AZEL[0] = A;
        AZEL[1] = Math.atan2(Z, R);
        return AZEL;
    }

    public static double[] slDVTP(double[] V, double[] V0) {
        int J;
        double W;
        double D;
        double X = V[0];
        double Y = V[1];
        double Z = V[2];
        double X0 = V0[0];
        double Y0 = V0[1];
        double Z0 = V0[2];
        double R2 = X0 * X0 + Y0 * Y0;
        double R = Math.sqrt(R2);
        if (R == 0.0) {
            X0 = R = 1.0E-20;
        }
        if ((D = (W = X * X0 + Y * Y0) + Z * Z0) > 1.0E-6) {
            J = 0;
        } else if (D >= 0.0) {
            J = 1;
            D = 1.0E-6;
        } else if (D > -1.0E-6) {
            J = 2;
            D = -1.0E-6;
        } else {
            J = 3;
        }
        double XI = (Y * X0 - X * Y0) / (D *= R);
        double ETA = (Z * R2 - Z0 * W) / D;
        if (J != 0) {
            System.out.println("ERROR: From slDVTP, J = " + J);
        }
        return new double[]{XI, ETA};
    }
}

