/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import javax.swing.event.ChangeEvent;

public class ImageChangeEvent
extends ChangeEvent {
    protected int val;
    protected static final int NEW_IMAGE = 1;
    protected static final int BEFORE = 2;
    protected static final int NEW_SCALE = 4;
    protected static final int NEW_ANGLE = 8;
    protected static final int NEW_ORIGIN = 16;
    protected static final int NEW_COLORMAP = 32;
    protected static final int NEW_CUT_LEVELS = 64;
    protected static final int EDIT_STATE_CHANGED = 128;
    protected static final int IMAGE_DATA_CHANGED = 256;

    public ImageChangeEvent(Object source) {
        super(source);
    }

    public boolean isNewImage() {
        return (this.val & 1) != 0;
    }

    public boolean isBefore() {
        return (this.val & 2) != 0;
    }

    public boolean isNewScale() {
        return (this.val & 4) != 0;
    }

    public boolean isNewAngle() {
        return (this.val & 8) != 0;
    }

    public boolean isNewOrigin() {
        return (this.val & 0x10) != 0;
    }

    public boolean isNewColormap() {
        return (this.val & 0x20) != 0;
    }

    public boolean isNewCutLevels() {
        return (this.val & 0x40) != 0;
    }

    public boolean isEditStateChanged() {
        return (this.val & 0x80) != 0;
    }

    public boolean isImageDataChanged() {
        return (this.val & 0x100) != 0;
    }

    public void setNewImage(boolean b) {
        this.val = b ? (this.val |= 1) : (this.val &= 0xFFFFFFFE);
    }

    public void setBefore(boolean b) {
        this.val = b ? (this.val |= 2) : (this.val &= 0xFFFFFFFD);
    }

    public void setNewScale(boolean b) {
        this.val = b ? (this.val |= 4) : (this.val &= 0xFFFFFFFB);
    }

    public void setNewAngle(boolean b) {
        this.val = b ? (this.val |= 8) : (this.val &= 0xFFFFFFF7);
    }

    public void setNewOrigin(boolean b) {
        this.val = b ? (this.val |= 0x10) : (this.val &= 0xFFFFFFEF);
    }

    public void setNewColormap(boolean b) {
        this.val = b ? (this.val |= 0x20) : (this.val &= 0xFFFFFFDF);
    }

    public void setNewCutLevels(boolean b) {
        this.val = b ? (this.val |= 0x40) : (this.val &= 0xFFFFFFBF);
    }

    public void setEditStateChanged(boolean b) {
        this.val = b ? (this.val |= 0x80) : (this.val &= 0xFFFFFF7F);
    }

    public void setImageDataChanged(boolean b) {
        this.val = b ? (this.val |= 0x100) : (this.val &= 0xFFFFFEFF);
    }

    public void reset() {
        this.val = 0;
    }
}

