/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CompositeFigure;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.event.EventLayer;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.Polyline2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Locale;
import javax.media.jai.JAI;
import javax.swing.JFrame;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.graphics.ShapeUtil;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.util.gui.BasicWindowMonitor;

public class MeasureBand
extends DragInteractor {
    private static final int PAD = 5;
    protected DivaGraphicsImageDisplay imageDisplay;
    CoordinateConverter coordinateConverter;
    protected FigureLayer figureLayer;
    protected EventLayer eventLayer;
    protected CompositeFigure mband = null;
    protected BasicFigure mbandLine;
    protected BasicFigure mbandAngle;
    protected BasicFigure mbandWidthRect;
    protected BasicFigure mbandHeightRect;
    protected BasicFigure mbandDiagRect;
    protected LabelFigure mbandWidthText;
    protected LabelFigure mbandHeightText;
    protected LabelFigure mbandDiagText;
    protected double originX;
    protected double originY;
    protected MouseFilter dragFilter;
    protected NumberFormat nf;

    public MeasureBand(DivaGraphicsImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.coordinateConverter = imageDisplay.getCoordinateConverter();
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setMinimumIntegerDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setMaximumFractionDigits(2);
        this.mband = new CompositeFigure();
        this.mbandLine = new BasicFigure((Shape)new GeneralPath(), 1.0f);
        this.mbandLine.setStrokePaint(Color.white);
        this.mband.add(this.mbandLine);
        this.mbandAngle = new BasicFigure((Shape)new Polyline2D.Double(), 1.0f);
        this.mbandAngle.setStrokePaint(Color.white);
        this.mbandAngle.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f));
        this.mband.add(this.mbandAngle);
        this.mbandWidthRect = new BasicFigure((Shape)new Rectangle2D.Double(), Color.yellow);
        this.mband.add(this.mbandWidthRect);
        this.mbandHeightRect = new BasicFigure((Shape)new Rectangle2D.Double(), Color.yellow);
        this.mband.add(this.mbandHeightRect);
        this.mbandDiagRect = new BasicFigure((Shape)new Rectangle2D.Double(), Color.yellow);
        this.mband.add(this.mbandDiagRect);
        this.mbandWidthText = new LabelFigure(" ");
        this.mbandWidthText.setFillPaint(Color.blue);
        Font font = new Font("SansSerif", 1, 13);
        this.mbandWidthText.setFont(font);
        this.mband.add(this.mbandWidthText);
        this.mbandHeightText = new LabelFigure(" ");
        this.mbandHeightText.setFillPaint(Color.blue);
        this.mbandHeightText.setFont(font);
        this.mband.add(this.mbandHeightText);
        this.mbandDiagText = new LabelFigure(" ");
        this.mbandDiagText.setFillPaint(Color.blue);
        this.mbandDiagText.setFont(font);
        this.mband.add(this.mbandDiagText);
        GraphicsPane gpane = (GraphicsPane)imageDisplay.getCanvasPane();
        this.setFigureLayer(gpane.getForegroundLayer());
        this.setEventLayer(gpane.getBackgroundEventLayer());
        this.dragFilter = new MouseFilter(12, 0, 0);
    }

    public FigureLayer getFigureLayer() {
        return this.figureLayer;
    }

    public EventLayer getEventLayer() {
        return this.eventLayer;
    }

    public void setFigureLayer(FigureLayer l) {
        this.figureLayer = l;
    }

    public void setEventLayer(EventLayer l) {
        if (this.eventLayer != null) {
            this.eventLayer.removeLayerListener(this);
        }
        this.eventLayer = l;
        this.eventLayer.addLayerListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.eventLayer != null) {
            this.eventLayer.removeLayerListener(this);
            if (enabled) {
                this.eventLayer.addLayerListener(this);
            }
        }
    }

    @Override
    public void mousePressed(LayerEvent event) {
        if (!this.isEnabled() || !this.dragFilter.accept(event)) {
            return;
        }
        this.originX = event.getLayerX();
        this.originY = event.getLayerY();
        boolean showAngle = !event.isShiftDown() && !event.isControlDown();
        this.updateMBand(this.originX, this.originY, this.originX, this.originY, showAngle);
        this.figureLayer.add(this.mband);
        this.figureLayer.repaint(this.mband.getBounds());
    }

    @Override
    public void mouseDragged(LayerEvent event) {
        if (!this.isEnabled() || !this.dragFilter.accept(event)) {
            return;
        }
        this.figureLayer.repaint(this.mband.getBounds());
        boolean showAngle = !event.isShiftDown() && !event.isControlDown();
        this.updateMBand(this.originX, this.originY, event.getLayerX(), event.getLayerY(), showAngle);
        this.figureLayer.repaint(this.mband.getBounds());
    }

    @Override
    public void mouseReleased(LayerEvent event) {
        if (!this.isEnabled() || !this.dragFilter.accept(event)) {
            return;
        }
        this.figureLayer.repaint(this.mband.getBounds());
        this.figureLayer.remove(this.mband);
    }

    public String formatHM(double val) {
        int sign = 1;
        if (val < 0.0) {
            sign = -1;
            val = -val;
        }
        double dd = val + 1.0E-10;
        double md = dd / 60.0;
        int min = (int)md;
        double sec = (md - (double)min) * 60.0;
        if ((double)min != 0.0) {
            return Integer.toString(min * sign) + ":" + this.nf.format(sec);
        }
        return this.nf.format(sec * (double)sign);
    }

    protected void updateMBand(double x0, double y0, double x1, double y1, boolean showAngle) {
        if (!this.imageDisplay.isWCS()) {
            return;
        }
        Point2D.Double p0 = new Point2D.Double(x0, y0);
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x1, y0);
        try {
            this.coordinateConverter.screenToWorldCoords(p0, false);
            this.coordinateConverter.screenToWorldCoords(p1, false);
            this.coordinateConverter.screenToWorldCoords(p2, false);
        }
        catch (Exception e) {
            return;
        }
        double dist = WorldCoords.dist(p0.x, p0.y, p1.x, p1.y) * 60.0;
        String distStr = this.formatHM(dist);
        String widthStr = null;
        String heightStr = null;
        if (showAngle) {
            double width = WorldCoords.dist(p0.x, p0.y, p2.x, p2.y) * 60.0;
            widthStr = this.formatHM(width);
            double height = WorldCoords.dist(p2.x, p2.y, p1.x, p1.y) * 60.0;
            heightStr = this.formatHM(height);
        }
        double mx = (x0 + x1) / 2.0;
        double my = (y0 + y1) / 2.0;
        int offset = 10;
        int diagAnchor = 0;
        int widthAnchor = 0;
        int heightAnchor = 0;
        int diagXOffset = 0;
        int diagYOffset = 0;
        int widthYOffset = 0;
        int heightXOffset = 0;
        if (Math.abs(y0 - y1) < 5.0) {
            diagAnchor = 5;
            diagYOffset = offset;
            showAngle = false;
        } else if (y0 < y1) {
            widthAnchor = 5;
            widthYOffset = -offset;
        } else {
            widthAnchor = 1;
            widthYOffset = offset;
        }
        if (Math.abs(x0 - x1) < 5.0) {
            diagAnchor = 7;
            diagXOffset = offset;
            diagYOffset = 0;
            showAngle = false;
        } else if (x0 < x1) {
            diagAnchor = 4;
            diagXOffset = -offset;
            diagYOffset = offset;
            heightAnchor = 7;
            heightXOffset = offset;
        } else {
            diagAnchor = 8;
            diagXOffset = offset;
            diagYOffset = -offset;
            heightAnchor = 3;
            heightXOffset = -offset;
        }
        GeneralPath path = new GeneralPath();
        ShapeUtil.addArrowLine(path, new Point2D.Double(x0, y0), new Point2D.Double(x1, y1));
        this.mbandLine.setShape(path);
        this.mbandDiagText.translateTo(mx + (double)diagXOffset, my + (double)diagYOffset);
        this.mbandDiagText.setString(distStr);
        this.mbandDiagText.setAnchor(diagAnchor);
        this.mbandDiagRect.setShape(this.getBoundsWithPadding(this.mbandDiagText));
        if (showAngle) {
            this.mbandAngle.setVisible(true);
            this.mbandWidthText.setVisible(true);
            this.mbandWidthRect.setVisible(true);
            this.mbandHeightText.setVisible(true);
            this.mbandHeightRect.setVisible(true);
            Polyline2D.Double pl = new Polyline2D.Double(x0, y0, x1, y0);
            pl.lineTo(x1, y1);
            this.mbandAngle.setShape(pl);
            this.mbandWidthText.translateTo(mx, y0 + (double)widthYOffset);
            this.mbandWidthText.setString(widthStr);
            this.mbandWidthText.setAnchor(widthAnchor);
            this.mbandWidthRect.setShape(this.getBoundsWithPadding(this.mbandWidthText));
            this.mbandHeightText.translateTo(x1 + (double)heightXOffset, my);
            this.mbandHeightText.setString(heightStr);
            this.mbandHeightText.setAnchor(heightAnchor);
            this.mbandHeightRect.setShape(this.getBoundsWithPadding(this.mbandHeightText));
        } else {
            this.mbandAngle.setVisible(false);
            this.mbandWidthText.setString(" ");
            this.mbandWidthText.setVisible(false);
            this.mbandWidthRect.setVisible(false);
            this.mbandHeightText.setString(" ");
            this.mbandHeightText.setVisible(false);
            this.mbandHeightRect.setVisible(false);
        }
    }

    protected Rectangle2D getBoundsWithPadding(LabelFigure fig) {
        Rectangle2D bounds = fig.getBounds();
        bounds.setFrame(bounds.getX() - 5.0, bounds.getY() - 5.0, bounds.getWidth() + 10.0, bounds.getHeight() + 10.0);
        return bounds;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("GraphicsImageDisplay");
        DivaGraphicsImageDisplay imageDisplay = new DivaGraphicsImageDisplay();
        if (args.length > 0) {
            try {
                imageDisplay.setImage(JAI.create("fileload", args[0]));
            }
            catch (Exception e) {
                System.out.println("error: " + e.toString());
                System.exit(1);
            }
        } else {
            imageDisplay.blankImage(0.0, 0.0);
        }
        new MeasureBand(imageDisplay);
        frame.getContentPane().add((Component)imageDisplay, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

