/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.toolbox.BasicRectangle;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RectangleGrabHandle
extends BasicRectangle
implements GrabHandle {
    private Site _site;
    private double _x = 0.0;
    private double _y = 0.0;
    private float _size = 4.0f;

    public RectangleGrabHandle(Site s) {
        this(s, Color.blue);
    }

    public RectangleGrabHandle(Site s, Color c) {
        super(0.0, 0.0, 0.0, 0.0, c);
        this.setSize(this._size);
        this._site = s;
    }

    @Override
    public Site getSite() {
        return this._site;
    }

    @Override
    public float getSize() {
        return this._size;
    }

    @Override
    public void relocate() {
        TransformContext tc = this.getTransformContext();
        Point2D p = this._site.getPoint(tc);
        double x = p.getX();
        double y = p.getY();
        if (x != this._x || y != this._y) {
            this._x = x;
            this._y = y;
            ((Rectangle2D)this.getShape()).setFrame(x - (double)this._size, y - (double)this._size, this._size * 2.0f, this._size * 2.0f);
        }
    }

    @Override
    public void setSite(Site s) {
        this._site = s;
        this.relocate();
    }

    @Override
    public void setSize(float size) {
        this._size = size;
        ((Rectangle2D)this.getShape()).setFrame(this._x - (double)this._size, this._y - (double)this._size, this._size * 2.0f, this._size * 2.0f);
    }

    @Override
    public void translate(double x, double y) {
        this._site.translate(x, y);
    }
}

