/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jsky.util.Preferences;
import jsky.util.Resources;
import org.astrogrid.samp.gui.GuiHubConnector;

public class SampFrame
extends JFrame {
    private JPanel contentPane = null;
    private GuiHubConnector hubConnector;
    protected JPanel actionBar = new JPanel();

    public SampFrame(GuiHubConnector hubConnector) {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.hubConnector = hubConnector;
        this.initUI();
        this.initFrame();
    }

    private void initUI() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        this.contentPane.add((Component)this.hubConnector.createMonitorPanel(), "Center");
        this.contentPane.add((Component)this.actionBar, "South");
        Icon connectIcon = Resources.getIcon("connect.gif");
        Action connectAction = this.hubConnector.createRegisterOrHubAction(this, null);
        connectAction.putValue("SmallIcon", connectIcon);
        this.actionBar.add(new JButton(connectAction));
        Icon closeIcon = Resources.getIcon("close.gif");
        CloseAction closeAction = new CloseAction("Close", closeIcon);
        fileMenu.add(closeAction).setMnemonic(67);
        JButton closeButton = new JButton(closeAction);
        this.actionBar.add(closeButton);
    }

    private void initFrame() {
        this.setTitle("SAMP Status");
        this.setDefaultCloseOperation(1);
        this.setIconImage(new ImageIcon(Resources.getResource("images/samp.gif")).getImage());
        this.pack();
        Preferences.manageLocation(this);
        Preferences.manageSize(this.contentPane, new Dimension(550, 600), "sampStatus");
        this.setVisible(true);
    }

    protected void closeWindowEvent() {
        this.dispose();
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction(String name, Icon icon) {
            super(name, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control W"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SampFrame.this.closeWindowEvent();
        }
    }
}

