/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import jsky.catalog.gui.BasicTablePlotter;
import jsky.catalog.gui.CatalogTree;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorMenuBar;
import jsky.navigator.NavigatorToolBar;
import jsky.util.Preferences;
import jsky.util.Resources;

public class NavigatorFrame
extends JFrame {
    protected Navigator navigator;
    private boolean firstTime = true;

    public NavigatorFrame(MainImageDisplay imageDisplay) {
        super("Catalog Navigator");
        this.setIconImage(new ImageIcon(Resources.getResource("images/Catalog24.gif")).getImage());
        CatalogTree catalogTree = new CatalogTree();
        BasicTablePlotter plotter = new BasicTablePlotter();
        this.navigator = new Navigator(catalogTree, plotter, imageDisplay);
        NavigatorToolBar toolbar = new NavigatorToolBar(this.navigator);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.navigator, "Center");
        this.setJMenuBar(new NavigatorMenuBar(this.navigator, toolbar));
        Preferences.manageSize(this.navigator, new Dimension(800, 700));
        Preferences.manageLocation(this);
        this.setDefaultCloseOperation(1);
    }

    public NavigatorFrame() {
        this((MainImageDisplay)null);
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.firstTime) {
            this.firstTime = false;
            this.pack();
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        NavigatorFrame f = new NavigatorFrame();
        f.setVisible(true);
    }
}

