/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.util.ArrayList;

public class TclUtil {
    public static String[] splitList(String tclList) {
        int i;
        if (tclList == null || tclList.length() == 0) {
            return null;
        }
        tclList = tclList.trim();
        ArrayList<String> v = new ArrayList<String>();
        char[] ar = tclList.toCharArray();
        int len = ar.length;
        int depth = 0;
        int start = 0;
        boolean ignoreWhitespace = false;
        boolean inQuote = false;
        for (i = 0; i < len; ++i) {
            char c = ar[i];
            if (c == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (c == '{' || c == '\"' && inQuote) {
                if (depth++ != 0) continue;
                ignoreWhitespace = true;
                start = i + 1;
                continue;
            }
            if (c == '}' || c == '\"' && !inQuote) {
                if (--depth != 0) continue;
                ignoreWhitespace = true;
                if (start == i) {
                    v.add("");
                    continue;
                }
                v.add(new String(ar, start, i - start).trim());
                continue;
            }
            if (depth != 0) continue;
            if (Character.isWhitespace(c)) {
                if (ignoreWhitespace) continue;
                ignoreWhitespace = true;
                if (start == i) {
                    v.add("");
                    continue;
                }
                v.add(new String(ar, start, i - start).trim());
                continue;
            }
            if (ignoreWhitespace) {
                start = i;
            }
            ignoreWhitespace = false;
        }
        if (!ignoreWhitespace) {
            if (start == i) {
                v.add("");
            } else {
                v.add(new String(ar, start, i - start).trim());
            }
        }
        int n = v.size();
        String[] result = new String[n];
        for (i = 0; i < n; ++i) {
            result[i] = (String)v.get(i);
        }
        return result;
    }

    public static String makeList(String[] ar) {
        if (ar == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ar.length; ++i) {
            sb.append('{');
            sb.append(ar[i]);
            sb.append('}');
            if (i + 1 >= ar.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String makeList(Object[] ar) {
        if (ar == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ar.length; ++i) {
            sb.append('{');
            sb.append(ar[i].toString());
            sb.append('}');
            if (i + 1 >= ar.length) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String s = "first {second item} \"third item\" last";
        System.out.println("Test list: " + s);
        String[] ar = TclUtil.splitList(s);
        System.out.println("length: " + ar.length);
        for (int i = 0; i < ar.length; ++i) {
            System.out.println("list[" + i + "] = " + ar[i]);
        }
        System.out.println("makeList(ar) returns: " + TclUtil.makeList(ar));
    }
}

