/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.lang.reflect.Array;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ArrayTableCellRenderer
extends DefaultTableCellRenderer {
    public ArrayTableCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int n;
        Class<?> c;
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null && (c = value.getClass()).isArray() && (n = Array.getLength(value)) > 0) {
            StringBuffer sb = new StringBuffer("(");
            for (int i = 0; i < n; ++i) {
                sb.append(Array.get(value, i).toString());
                if (i == 2 && n > 3) {
                    sb.append(", ...");
                    break;
                }
                if (i >= n - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            ((JLabel)component).setText(sb.toString());
        }
        return component;
    }
}

