/*
 * Decompiled with CFR 0.152.
 */
package alma.Control.LOSolutions;

import alma.BasebandNameMod.BasebandName;
import alma.Control.DSBbasebandSpec;
import alma.Control.LO2Parameters;
import alma.Control.LOSolutions.Band;
import alma.Control.LOSolutions.BasebandInfo;
import alma.Control.LOSolutions.FreqBBindex;
import alma.Control.LOSolutions.FreqRange;
import alma.Control.LOSolutions.LOSolutionsInterface;
import alma.Control.LOSolutions.LOrange;
import alma.Control.LOSolutions.SB;
import alma.Control.LOSolutions.SSBbasebandInfo;
import alma.Control.LOSolutions.SidebandSelect;
import alma.Control.SSBbasebandSpec;
import alma.Control.SkyFreqSideband;
import alma.Control.TuningParameters;
import alma.ReceiverBandMod.ReceiverBand;
import alma.acs.logging.AcsLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LOSolutions
implements LOSolutionsInterface {
    List<TuningParameters> tuningSolutions = new ArrayList<TuningParameters>();
    private int preferredSolution = -1;
    static final int nFTS2Avoidance = 6;
    static final double[] fts2AvoidanceRange = new double[6];
    static final double[] fts2AvoidanceFrequency = new double[6];
    static final double DigitizerFreq = 4.0E9;
    static final double FTS1headroom = 2000000.0;
    static final double FTS2headroom = 1000000.0;
    static final double FTS1HwLowFreq = 2.0E7;
    static final double FTS1HwHighFreq = 4.5E7;
    static final double FTS2HwLowFreq = 2.0E7;
    static final double FTS2HwHighFreq = 4.25E7;
    static final double FTS1HighFreq = 4.3E7;
    static final double FTS1LowFreq = 2.2E7;
    static final double FTS2HighFreq = 4.15E7;
    static final double FTS2LowFreq = 2.1E7;
    static final double FTS2CenterFreq = 3.125E7;
    static final double LO2CombSpacing = 1.25E8;
    static final double DYTOLowFreq = 8.0E9;
    static final double DYTOHighFreq = 1.4E10;
    static final double Use12GHzFilterThreshold = 1.05E10;
    private static final double FLOOGLowFreq = 2.2E7;
    private static final double FLOOGHighFreq = 4.3E7;
    private static final double FLOOGCenterFreq = 3.25E7;
    private static final double MaxEarthVel = 30.8;
    private double MaxDopFac = 1.0;
    private static final double dsbLOsearchSpan = 4.0E8;
    private static final double scoreA = 5.0;
    private static final double scoreB = 1.0;
    private static final double scoreC = 3.0;
    private static final double wErrNormSSB = 2.5E7;
    private static final double wErrNormDSB = 2.0E8;
    private static final double scoreScale = 10.0;
    protected AcsLogger logger;
    private BasebandInfo[] basebandInfo = new BasebandInfo[4];
    private List<BasebandInfo> baseband = new ArrayList<BasebandInfo>();
    static final double BasebandBW = 2.0E9;
    static final double BandOffsetFudge = 0.1;
    static final double BandOffset = 9.999999999E8;
    static final double LSOffsetFreq = -1.25E8;

    public LOSolutions() {
        this.constructorInitialization(null, false);
    }

    public LOSolutions(Logger logger) {
        this.constructorInitialization(logger, false);
    }

    public LOSolutions(Logger logger, boolean addMarginForEarthsMotion) {
        this.constructorInitialization(logger, addMarginForEarthsMotion);
    }

    public short numberOfSolutions() {
        return new Integer(this.tuningSolutions.size()).shortValue();
    }

    public short preferredTuningSolution() {
        return new Integer(this.preferredSolution).shortValue();
    }

    public TuningParameters getTuningSolution(short soln) throws Exception {
        short nSols = this.numberOfSolutions();
        if (nSols <= 0) {
            String errMsg = "There are no tuning solutions! Have you called computeSolutions()?";
            this.logger.severe(errMsg);
            throw new Exception(errMsg);
        }
        if (soln < 0 || soln >= nSols) {
            String errMsg = "Only solutions in the range 0 - " + (nSols - 1) + " are available and you have requested solution " + soln;
            this.logger.severe(errMsg);
            throw new Exception(errMsg);
        }
        return this.tuningSolutions.get(soln);
    }

    public List<TuningParameters> getAllTuningSolutions() throws Exception {
        short nSols = this.numberOfSolutions();
        if (nSols <= 0) {
            String errMsg = "There are no tuning solutions! Have you called computeSolutions()?";
            this.logger.severe(errMsg);
            throw new Exception(errMsg);
        }
        return this.tuningSolutions;
    }

    public TuningParameters computeSSBSolution(List<SSBbasebandSpec> bbSpec) throws Exception {
        List<BasebandInfo> bbInfo = BasebandInfo.toBasebandInfoSSB(bbSpec);
        ReceiverBand band = this.selectBand(bbInfo).receiverBand();
        return this.computeSSBSolution(bbSpec, band);
    }

    public TuningParameters computeSSBSolution(List<SSBbasebandSpec> bbSpec, ReceiverBand band) throws Exception {
        List<BasebandInfo> bbInfo = BasebandInfo.toBasebandInfoSSB(bbSpec);
        this.doComputeSolutions(bbInfo, band, false, false);
        short soln = this.preferredTuningSolution();
        return this.getTuningSolution(soln);
    }

    public TuningParameters computeDSBSolution(List<DSBbasebandSpec> bbSpec) throws Exception {
        List<BasebandInfo> bbInfo = BasebandInfo.toBasebandInfoDSB(bbSpec);
        ReceiverBand band = this.selectBand(bbInfo).receiverBand();
        return this.computeDSBSolution(bbSpec, band);
    }

    public TuningParameters computeDSBSolution(List<DSBbasebandSpec> bbSpec, ReceiverBand band) throws Exception {
        List<BasebandInfo> bbInfo = BasebandInfo.toBasebandInfoDSB(bbSpec);
        this.doComputeSolutions(bbInfo, band, false, true);
        short soln = this.preferredTuningSolution();
        TuningParameters tp = this.getTuningSolution(soln);
        for (LO2Parameters lo2 : tp.LO2) {
            lo2.skyFreqSideband = SkyFreqSideband.DSB;
        }
        return tp;
    }

    public String getHardwareParameters() {
        return this.hardwareParameterString();
    }

    public double averageSkyFrequency() {
        double tot = 0.0;
        int count = 0;
        for (BasebandInfo b : this.baseband) {
            for (SSBbasebandInfo s : b.sb) {
                if (s == null) continue;
                tot += s.skyFreqHz;
                ++count;
            }
        }
        return tot / (double)count;
    }

    public static double getLSOffsetFreq() {
        return -1.25E8;
    }

    public static double LO2CombSpacing() {
        return 1.25E8;
    }

    public static short getColdMultiplier(ReceiverBand receiverBand) throws Exception {
        Band b = Band.band(receiverBand);
        return b.coldMultiplier();
    }

    public static double LSfreqFromLO1(ReceiverBand rb, double lo1, double floog, boolean tuneHigh) throws Exception {
        double coldX = Band.band(rb).coldMultiplier();
        double ls = 0.0;
        ls = tuneHigh ? lo1 / coldX - floog : lo1 / coldX + floog;
        return ls;
    }

    public static boolean tuneHighFromLO2(ReceiverBand b, double lo2) throws Exception {
        double IFlow;
        double IFhigh = Band.band(b).IFhighFreq();
        double IFmid = (IFhigh + (IFlow = Band.band(b).IFlowFreq())) / 2.0;
        return lo2 > IFmid;
    }

    public static double getLO2Freq(LO2Parameters parameters) {
        return parameters.DYTOFrequency;
    }

    public static double actualSkyFreq(TuningParameters t, int bbIndex, SidebandSelect sb) {
        int sbsign = sb == SidebandSelect.Upper ? 1 : -1;
        double lo2 = LOSolutions.getLO2Freq(t.LO2[bbIndex]);
        double fI = lo2 - 3.0E9;
        double skyFreq = LOSolutions.LO1Frequency(t) + (double)sbsign * fI;
        return skyFreq;
    }

    public Map<BasebandName, Double> actualSkyFreq(TuningParameters t) {
        HashMap<BasebandName, Double> freqs = new HashMap<BasebandName, Double>(t.LO2.length);
        for (int bbIndex = 0; bbIndex < t.LO2.length; ++bbIndex) {
            SidebandSelect sb = SidebandSelect.Upper;
            if (t.LO2[bbIndex].skyFreqSideband == SkyFreqSideband.LSB) {
                sb = SidebandSelect.Lower;
            }
            double f = LOSolutions.actualSkyFreq(t, bbIndex, sb);
            freqs.put(BasebandName.from_int((int)(bbIndex + 1)), f);
        }
        return freqs;
    }

    public double LO1Freq(TuningParameters parameters) {
        return LOSolutions.LO1Frequency(parameters);
    }

    public static double LO1Frequency(TuningParameters parameters) {
        double ls = LOSolutions.laserSynth(parameters);
        double nc = parameters.coldMultiplier;
        double lo1 = 0.0;
        lo1 = parameters.tuneHigh ? (ls + parameters.FLOOGFrequency) * nc : (ls - parameters.FLOOGFrequency) * nc;
        return lo1;
    }

    public static double laserSynth(TuningParameters p) {
        return p.LSFrequency;
    }

    static double LOdriver(TuningParameters p) {
        double sign = p.tuneHigh ? 1.0 : -1.0;
        return LOSolutions.laserSynth(p) + sign * p.FLOOGFrequency;
    }

    public static double getUSBhighFreq(TuningParameters t) throws Exception {
        Band band = Band.band(t.receiverBand);
        if (band.sb() == SB.LSB) {
            return 0.0;
        }
        double f = LOSolutions.LO1Frequency(t) + band.IFhighFreq();
        if (f > band.bandHighFreq()) {
            return band.bandHighFreq();
        }
        return f;
    }

    public static double getUSBlowFreq(TuningParameters t) throws Exception {
        Band band = Band.band(t.receiverBand);
        if (band.sb() == SB.LSB) {
            return 0.0;
        }
        double f = LOSolutions.LO1Frequency(t) + band.IFlowFreq();
        if (f > band.bandHighFreq()) {
            return band.bandHighFreq();
        }
        return f;
    }

    public static double getLSBhighFreq(TuningParameters t) throws Exception {
        Band band = Band.band(t.receiverBand);
        if (band.sb() == SB.USB) {
            return 0.0;
        }
        double f = LOSolutions.LO1Frequency(t) - band.IFlowFreq();
        if (f < band.bandLowFreq()) {
            return band.bandLowFreq();
        }
        return f;
    }

    public static double getLSBlowFreq(TuningParameters t) throws Exception {
        Band band = Band.band(t.receiverBand);
        if (band.sb() == SB.USB) {
            return 0.0;
        }
        double f = LOSolutions.LO1Frequency(t) - band.IFhighFreq();
        if (f < band.bandLowFreq()) {
            return band.bandLowFreq();
        }
        return f;
    }

    private short doComputeSolutions(List<BasebandInfo> bbinfo, ReceiverBand rb, boolean verbose, boolean dumpBasebands) throws Exception {
        LOrange[] loRanges;
        this.tuningSolutions.clear();
        this.preferredSolution = -1;
        Band band = Band.band(rb);
        this.validateBasebandFreq(bbinfo, band);
        boolean doBothSB = this.assignEitherBasebands(band, bbinfo, verbose);
        if (dumpBasebands) {
            this.dumpBB(band, bbinfo);
        }
        for (LOrange loRange : loRanges = this.validateSidebands(bbinfo, band, doBothSB, verbose)) {
            int nBasebands = bbinfo.size();
            int nCombinations = 1 << nBasebands;
            for (int c = 0; c < nCombinations; ++c) {
                int[] fts2sb = new int[4];
                int i = 0;
                for (BasebandInfo bb : bbinfo) {
                    boolean isZero = (c & 1 << i) == 0;
                    fts2sb[bb.index] = isZero ? -1 : 1;
                    ++i;
                }
                SidebandSelect lo1sb = loRange.sbSelect;
                double loOffset = this.selectLO1offset(bbinfo, fts2sb, lo1sb);
                this.findSolutions(band, bbinfo, loOffset, fts2sb, loRange, this.tuningSolutions, verbose);
            }
        }
        this.editSolutions(bbinfo, verbose);
        this.preferredSolution = this.scoreSolutions(bbinfo, band, verbose);
        this.selectIFprocessors(band);
        this.setTuningParameterIndices();
        this.baseband = bbinfo;
        for (int b = 0; b < 4; ++b) {
            this.basebandInfo[b] = new BasebandInfo(b);
        }
        Iterator<BasebandInfo> b = this.baseband.iterator();
        while (b.hasNext()) {
            BasebandInfo bb;
            this.basebandInfo[bb.index] = bb = b.next();
        }
        int nTunings = this.tuningSolutions.size();
        return (short)nTunings;
    }

    private void validateBasebandFreq(List<BasebandInfo> bbinfo, Band band) throws Exception {
        double lowestFreq = this.bandLowFreq(band) + 9.999999999E8;
        double highestFreq = this.bandHighFreq(band) - 9.999999999E8;
        Object badFreqs = "";
        for (SSBbasebandInfo s : BasebandInfo.asSidebands(bbinfo)) {
            double f = s.skyFreqHz;
            if (!(f < lowestFreq) && !(f > highestFreq)) continue;
            Object fmt = "The 2GHz wide base-band centered at %.6f GHz";
            fmt = (String)fmt + " is not completely within " + String.valueOf(band.receiverBand());
            fmt = (String)fmt + " that extends from %.1f GHz to %.1f GHz.";
            if (((String)badFreqs).length() > 0) {
                badFreqs = (String)badFreqs + "\n";
            }
            badFreqs = (String)badFreqs + String.format((String)fmt, f * 1.0E-9, this.bandLowFreq(band) * 1.0E-9, this.bandHighFreq(band) * 1.0E-9);
        }
        if (((String)badFreqs).length() > 0) {
            this.logger.severe((String)badFreqs);
            throw new Exception((String)badFreqs);
        }
    }

    private Band selectBand(List<BasebandInfo> bbinfo) throws Exception {
        String msg;
        List<Band> candidateBands = Arrays.asList(Band.values());
        Object bbFreqs = "";
        for (FreqBBindex pair : BasebandInfo.freqBBindexVec(bbinfo)) {
            ArrayList<Band> latestBands = new ArrayList<Band>();
            double f = pair.skyFreqHz;
            bbFreqs = (String)bbFreqs + " " + String.format("%.3fGHz", f / 1.0E9);
            for (Band b : Band.values()) {
                if (!(f >= this.bandLowFreq(b) + 9.999999999E8) || !(f <= this.bandHighFreq(b) - 9.999999999E8) || !candidateBands.contains((Object)b)) continue;
                latestBands.add(b);
            }
            candidateBands = latestBands;
        }
        if (candidateBands.size() == 1) {
            Band selectedBand = candidateBands.get(0);
            msg = "Selected " + String.valueOf((Object)selectedBand) + " to use with base-bands centered at" + (String)bbFreqs;
            this.logger.fine(msg);
            return selectedBand;
        }
        String errorReason = "";
        if (candidateBands.size() == 2) {
            Band b0 = candidateBands.get(0);
            Band b1 = candidateBands.get(1);
            if (b0 == Band.Band4 && b1 == Band.Band5 || b0 == Band.Band5 && b1 == Band.Band4) {
                String msg2 = "Choose band 4 to use with base-bands centered at" + (String)bbFreqs;
                this.logger.fine(msg2);
                return Band.Band4;
            }
            if (b0 == Band.Band2 && b1 == Band.Band3 || b0 == Band.Band3 && b1 == Band.Band2) {
                String msg3 = "Choose band 3 to use with base-bands centered at" + (String)bbFreqs;
                this.logger.fine(msg3);
                return Band.Band3;
            }
            errorReason = " two bands are possible and there is no logic to select between them.";
        }
        if (candidateBands.size() > 2) {
            errorReason = " more than two bands are possible and there is no logic to select between them.";
        }
        if (candidateBands.size() == 0) {
            errorReason = " no band covers all the specified frequencies.";
        }
        msg = "Cannot select a suitable observing band with base-bands centered at" + (String)bbFreqs;
        msg = msg + " as" + errorReason;
        this.logger.fine(msg);
        throw new Exception(msg);
    }

    private boolean assignEitherBasebands(Band band, List<BasebandInfo> bbinfo, boolean verbose) throws Exception {
        Object emsg = "";
        boolean error = false;
        for (BasebandInfo b : bbinfo) {
            block0 : switch (band.sb()) {
                case USB: {
                    switch (b.sbSelect) {
                        case Either: {
                            b.removeLSB();
                            break;
                        }
                        case Both: {
                            emsg = (String)emsg + "Baseband" + b.index + " attempts to ";
                            emsg = (String)emsg + "assign a DSB frequency to a ";
                            emsg = (String)emsg + "single sideband (USB) frontend.\n";
                            error = true;
                            break;
                        }
                        case Lower: {
                            emsg = (String)emsg + "Baseband" + b.index + " attempts to ";
                            emsg = (String)emsg + "assign an LSB frequency to ";
                            emsg = (String)emsg + "a USB frontend\n";
                            error = true;
                        }
                    }
                }
                case LSB: {
                    switch (b.sbSelect) {
                        case Either: {
                            b.removeUSB();
                            break block0;
                        }
                        case Both: {
                            emsg = (String)emsg + "Baseband" + b.index + " attempts to ";
                            emsg = (String)emsg + "assign a DSB frequency to a ";
                            emsg = (String)emsg + "single sideband (LSB) frontend.\n";
                            error = true;
                            break block0;
                        }
                        case Lower: {
                            emsg = (String)emsg + "Baseband" + b.index + " attempts to ";
                            emsg = (String)emsg + "assign a USB frequency to ";
                            emsg = (String)emsg + "an LSB frontend\n";
                            error = true;
                        }
                    }
                }
            }
        }
        if (error) {
            emsg = ((String)emsg).substring(0, ((String)emsg).length() - 1);
            throw new Exception((String)emsg);
        }
        boolean lowerSpecified = false;
        boolean upperSpecified = false;
        for (BasebandInfo b : bbinfo) {
            if (b.sbSelect == SidebandSelect.Upper) {
                upperSpecified = true;
            }
            if (b.sbSelect != SidebandSelect.Lower) continue;
            lowerSpecified = true;
        }
        if (lowerSpecified && upperSpecified) {
            Object msg = "Conflict in sideband specification: ";
            msg = (String)msg + " Both Lower and Upper Sideband have ";
            msg = (String)msg + " been specified for different basebands";
            msg = (String)msg + "\nA sideband should only be specified when there is an";
            msg = (String)msg + " ambiguity in the assignment of a sideband for a given";
            msg = (String)msg + " baseband center frequency. If different sidebands are";
            msg = (String)msg + " specified then a conflict may occur,";
            msg = (String)msg + " and is therefore not allowed.";
            throw new Exception((String)msg);
        }
        if (lowerSpecified || upperSpecified) {
            for (BasebandInfo b : bbinfo) {
                if (b.sbSelect != SidebandSelect.Either) continue;
                if (upperSpecified) {
                    b.removeLSB();
                    continue;
                }
                b.removeUSB();
            }
        }
        FreqRange range = this.basebandRange(bbinfo);
        double highFreq = range.high;
        double lowFreq = range.low;
        double fskySpan = highFreq - lowFreq;
        double ifSpan = this.IFhighFreq(band) - this.IFlowFreq(band) - 1.9999999998E9;
        if (fskySpan <= (ifSpan *= this.MaxDopFac)) {
            boolean allAreEither = true;
            for (BasebandInfo b : bbinfo) {
                if (b.sbSelect == SidebandSelect.Either) continue;
                allAreEither = false;
            }
            if (allAreEither) {
                return true;
            }
        }
        FreqRange usbRange = new FreqRange(highFreq - ifSpan, highFreq);
        FreqRange lsbRange = new FreqRange(lowFreq, lowFreq + ifSpan);
        for (BasebandInfo b : bbinfo) {
            if (b.sbSelect != SidebandSelect.Either) continue;
            double f = b.upper.skyFreqHz;
            if (!usbRange.isWithin(f)) {
                b.removeUSB();
            }
            if (!lsbRange.isWithin(f)) {
                b.removeLSB();
            }
            if (b.isUsed) continue;
            Object t = "Baseband%d frequency (%.3fGHz) won't fit in";
            t = (String)t + " a sideband of frontend with frequencies spanning ";
            t = (String)t + "[%.1f, %.1f]GHz";
            String s = String.format((String)t, b.index, 1.0E-9 * f, 1.0E-9 * highFreq, 1.0E-9 * lowFreq);
            throw new Exception(s);
        }
        return false;
    }

    private String rangeRepresentation(double low, double high, int precision) {
        double absdiff = Math.abs(high - low);
        String f = String.format("%%.%dfGHz", precision);
        if (absdiff < 10000.0) {
            return String.format(f, high * 1.0E-9);
        }
        String fmt = String.format("[%s, %s]GHz", f, f);
        return String.format(fmt, 1.0E-9 * low, 1.0E-9 * high);
    }

    private LOrange[] validateSidebands(List<BasebandInfo> bbinfo, Band band, boolean useBothSidebands, boolean verbose) throws Exception {
        FreqRange ifRange = this.ifRange(band);
        double ifSpan = ifRange.span();
        ifSpan *= this.MaxDopFac;
        boolean usbUsed = false;
        boolean lsbUsed = false;
        FreqRange usbRange = new FreqRange();
        FreqRange lsbRange = new FreqRange();
        List<SSBbasebandInfo> sbinfo = BasebandInfo.sidebandVec(bbinfo);
        for (SSBbasebandInfo s : sbinfo) {
            switch (s.sbSelect) {
                case Upper: {
                    usbRange.add(s.skyFreqHz);
                    usbUsed = true;
                    break;
                }
                case Lower: {
                    lsbRange.add(s.skyFreqHz);
                    lsbUsed = true;
                }
            }
        }
        boolean error = false;
        Object emsg = "";
        double usbSpan = usbRange.span();
        double lsbSpan = lsbRange.span();
        Object fmt = "Span of requested %s sky frequencies(%.3fGHz) exceeds";
        fmt = (String)fmt + " usable IF bandwidth(%.1fGHz)";
        if (usbUsed && usbSpan > ifSpan) {
            error = true;
            emsg = (String)emsg + String.format((String)fmt, "USB", 1.0E-9 * usbSpan, 1.0E-9 * ifSpan);
        }
        if (lsbUsed && lsbSpan > ifSpan) {
            error = true;
            emsg = (String)emsg + String.format((String)fmt, "LSB", 1.0E-9 * lsbSpan, 1.0E-9 * ifSpan);
        }
        if (error) {
            throw new Exception((String)emsg);
        }
        ifRange.high *= this.MaxDopFac;
        ifRange.low *= 2.0 - this.MaxDopFac;
        LOrange usbLoRange = new LOrange(usbRange.high - ifRange.high, usbRange.low - ifRange.low);
        usbLoRange.sbSelect = SidebandSelect.Upper;
        LOrange lsbLoRange = new LOrange(lsbRange.high + ifRange.low, lsbRange.low + ifRange.high);
        lsbLoRange.sbSelect = SidebandSelect.Lower;
        if (!lsbUsed || !usbUsed) {
            LOrange[] lor = new LOrange[]{lsbUsed ? lsbLoRange : usbLoRange};
            return lor;
        }
        LOrange loRange = usbLoRange.intersection(lsbLoRange);
        loRange.sbSelect = SidebandSelect.Both;
        boolean singleLOrange = loRange.isValidIntersection();
        if (useBothSidebands) {
            if (singleLOrange) {
                emsg = "Use of both sidebands inconsistent with ";
                emsg = (String)emsg + "a single LO range: programming error!";
                throw new Exception((String)emsg);
            }
        } else if (!singleLOrange) {
            Object f = "All the requested frequencies in the two sidebands ";
            f = (String)f + "covering ranges LSB=%s  USB=%s ";
            f = (String)f + "cannot be placed in the IF range [%.1f, %.1f]GHz ";
            f = (String)f + "at the same time.";
            int SKYFREQ_RANGE_PRECISION = 3;
            int p = 3;
            emsg = String.format((String)f, this.rangeRepresentation(lsbRange.low, lsbRange.high, 3), this.rangeRepresentation(usbRange.low, usbRange.high, 3), 1.0E-9 * ifRange.low, 1.0E-9 * ifRange.high);
            throw new Exception((String)emsg);
        }
        if (!BasebandInfo.isOnlySSB(bbinfo)) {
            for (BasebandInfo bb : bbinfo) {
                if (!bb.isDSB()) continue;
                double loCenter = (bb.upper.skyFreqHz + bb.lower.skyFreqHz) / 2.0;
                double halfSpan = 2.0E8;
                LOrange dsbLOrange = new LOrange(loCenter - 2.0E8, loCenter + 2.0E8);
                loRange = loRange.intersection(dsbLOrange);
                break;
            }
        }
        LOrange[] lor = singleLOrange ? new LOrange[]{loRange} : new LOrange[]{usbLoRange, lsbLoRange};
        if (band.sb() == SB.SB2) {
            SidebandSelect unk = SidebandSelect.Unknown;
            SidebandSelect[] sb = new SidebandSelect[4];
            for (int i = 0; i < 4; ++i) {
                sb[i] = unk;
            }
            for (BasebandInfo b : bbinfo) {
                sb[b.index] = b.sbSelect;
            }
            error = false;
            Object msg0 = "";
            Object msg1 = "";
            if (sb[0] != unk && sb[1] != unk && sb[0] != sb[1]) {
                error = true;
                msg0 = " basebands 0 & 1 use " + String.valueOf((Object)sb[0]) + " and " + String.valueOf((Object)sb[1]);
            }
            if (sb[2] != unk && sb[3] != unk && sb[2] != sb[3]) {
                error = true;
                msg1 = " basebands 2 & 3 use " + String.valueOf((Object)sb[2]) + " and " + String.valueOf((Object)sb[3]);
            }
            if (error) {
                emsg = "Basebands pairs 0/1 and 2/3 must use ";
                emsg = (String)emsg + "the same sideband within the pair, but\n";
                emsg = (String)emsg + (String)msg0;
                if (msg0 != "" && msg1 != "") {
                    emsg = (String)emsg + " and\n";
                }
                emsg = (String)emsg + (String)msg1;
                throw new Exception((String)emsg);
            }
        }
        return lor;
    }

    private double lo2EdgeCorrection(double lo2) {
        if (lo2 < 8.0E9 && lo2 > 7.875E9) {
            return 8.0E9;
        }
        if (lo2 > 1.4E10 && lo2 < 1.4125E10) {
            return 1.4E10;
        }
        return lo2;
    }

    private double fts2Avoidance(double fts2nominal) {
        boolean verbose = false;
        for (int i = 0; i < 6; ++i) {
            double f = fts2AvoidanceFrequency[i];
            double flo = f - fts2AvoidanceRange[i];
            double fhi = f + fts2AvoidanceRange[i];
            if (!(fts2nominal > flo) || !(fts2nominal < fhi)) continue;
            if (fts2nominal >= f) {
                return fhi;
            }
            return flo;
        }
        return fts2nominal;
    }

    private double LO1offset(BasebandInfo bb, int fts2sign) {
        double fts2 = (double)fts2sign * this.fts2Avoidance(3.125E7);
        double loOffset = 0.0;
        if (bb.isDSB()) {
            double LO1 = (bb.upper.skyFreqHz + bb.lower.skyFreqHz) / 2.0;
            double wu = bb.upper.weight;
            double wl = bb.lower.weight;
            double fts2Offset = fts2 * (wl - wu) / (wu + wl);
            loOffset = (LO1 + fts2Offset) % 1.25E8;
        } else {
            int sbSign = 1;
            SSBbasebandInfo sb = bb.sb.get(0);
            sbSign = sb.sbSelect == SidebandSelect.Lower ? -1 : 1;
            double fsky = sb.skyFreqHz;
            loOffset = (fsky - (double)sbSign * fts2) % 1.25E8;
        }
        double loOffsetNorm = this.loOffsetNormalize(loOffset);
        return loOffsetNorm;
    }

    private double selectLO1offset(List<BasebandInfo> bbinfo, int[] fts2sb, SidebandSelect lo1sb) throws Exception {
        List<BasebandInfo> bbs = BasebandInfo.basebandVec(bbinfo, lo1sb);
        int nBB = bbs.size();
        double[] loBBoffset = new double[nBB];
        int bbSBindex = 0;
        Object msg = "LO1 offsets:";
        for (BasebandInfo bb : bbs) {
            int fts2sign = fts2sb[bb.index];
            loBBoffset[bbSBindex] = this.LO1offset(bb, fts2sign);
            msg = (String)msg + " " + String.format("%.3fMHz", loBBoffset[bbSBindex] / 1000000.0) + "/" + String.format("%.0f", bb.weight());
            ++bbSBindex;
        }
        if (bbs.size() == 1) {
            return loBBoffset[0];
        }
        int nBBw100 = 0;
        int iBBw100 = -1;
        for (int bb1 = 0; bb1 < loBBoffset.length; ++bb1) {
            if (bbs.get(bb1).weight() != 100.0) continue;
            ++nBBw100;
            iBBw100 = bb1;
        }
        if (nBBw100 == 1) {
            return loBBoffset[iBBw100];
        }
        OffsetPair biggestSeperation = new OffsetPair(0.0, 0.0);
        for (int bb1 = 0; bb1 < loBBoffset.length - 1; ++bb1) {
            if (bbs.get(bb1).weight() < 100.0) continue;
            for (int bb2 = bb1 + 1; bb2 < loBBoffset.length; ++bb2) {
                OffsetPair thisSeperation;
                if (bbs.get(bb2).weight() < 100.0 || !((thisSeperation = this.computeSeperation(loBBoffset[bb1], bbs.get(bb1).weight(), loBBoffset[bb2], bbs.get(bb2).weight())).seperation() >= biggestSeperation.seperation())) continue;
                biggestSeperation = thisSeperation;
            }
        }
        msg = (String)msg + " LO1 Offset: " + String.format("%.6fMHz", biggestSeperation.mean() / 1000000.0) + " max seperation: " + String.format("%.3fMHz", biggestSeperation.seperation() / 1000000.0 / 2.0);
        return this.loOffsetNormalize(biggestSeperation.mean());
    }

    private OffsetPair computeSeperation(double bb1Offset, double bb1Weight, double bb2Offset, double bb2Weight) {
        double offToRad = 5.026548245743669E-8;
        double bb1x = Math.cos(bb1Offset * 5.026548245743669E-8);
        double bb1y = Math.sin(bb1Offset * 5.026548245743669E-8);
        double bb2x = Math.cos(bb2Offset * 5.026548245743669E-8);
        double bb2y = Math.sin(bb2Offset * 5.026548245743669E-8);
        double dotProduct = bb1x * bb2x + bb1y * bb2y;
        double seperation = Math.acos(dotProduct);
        double mean = (bb1Offset * 5.026548245743669E-8 * bb1Weight + bb2Offset * 5.026548245743669E-8 * bb2Weight) / (bb1Weight + bb2Weight);
        return new OffsetPair(mean / 5.026548245743669E-8, seperation / 5.026548245743669E-8);
    }

    private void findSolutions(Band band, List<BasebandInfo> bbinfo, double lo1Offset, int[] fts2sb, LOrange loRange, List<TuningParameters> sol, boolean verbose) throws Exception {
        double loLow = loRange.low;
        double loHigh = loRange.high;
        if (verbose) {
            this.logger.fine(String.format("****LO1offset: %5.1f", 1.0E-6 * lo1Offset));
        }
        double fstop = lo1Offset + 1.25E8 * Math.ceil(loHigh / 1.25E8);
        double if2 = 3.0E9;
        double floog = 3.25E7;
        ArrayList<TuningParameters> trial = new ArrayList<TuningParameters>();
        for (double flo1 = lo1Offset + 1.25E8 * Math.floor(loLow / 1.25E8); flo1 <= fstop; flo1 += 1.25E8) {
            for (int i = 0; i < 2; ++i) {
                double werr;
                TuningParameters t = new TuningParameters();
                t.LO2 = new LO2Parameters[4];
                for (int lo2 = 0; lo2 < 4; ++lo2) {
                    t.LO2[lo2] = new LO2Parameters();
                }
                int fts1sb = i * 2 - 1;
                boolean fts1Tunehigh = fts1sb == 1;
                short coldX = this.coldMultiplier(band);
                double flodriver = flo1 / (double)coldX;
                t.receiverBand = band.receiverBand();
                t.LSFrequency = flodriver - (double)fts1sb * 3.25E7;
                t.FLOOGFrequency = 3.25E7;
                t.tuneHigh = fts1Tunehigh;
                t.coldMultiplier = coldX;
                double sumW = 0.0;
                double sumWerr = 0.0;
                int sbsign = 1;
                for (BasebandInfo bb : BasebandInfo.dsbBasebandVec(bbinfo)) {
                    int fts2sign = fts2sb[bb.index];
                    LO2Parameters lo2p = t.LO2[bb.index];
                    double wu = bb.upper.weight;
                    double wl = bb.lower.weight;
                    sumW += wu + wl;
                    double lo2u = bb.upper.skyFreqHz - flo1 + 3.0E9;
                    double lo2l = flo1 - bb.lower.skyFreqHz + 3.0E9;
                    double lo2 = (wu * lo2u + wl * lo2l) / (wu + wl);
                    this.loadLO2params(lo2p, lo2, fts2sign, SidebandSelect.Both);
                    double lo2act = LOSolutions.LO2Freq(lo2p);
                    sumWerr += wu * Math.abs(lo2u - lo2act);
                    sumWerr += wl * Math.abs(lo2l - lo2act);
                    if (!verbose) continue;
                    this.logger.fine(String.format("   UpperLO2req:%7.3f LowerLO2req: %7.3f lo2act:%7.3f", 1.0E-9 * lo2u, 1.0E-9 * lo2l, 1.0E-9 * lo2act));
                    Object m = " BB%d: FTS1sb:%2d LO2:%6.3f";
                    m = (String)m + " FskyUpper:%7.3f FskyLower:%7.3f ";
                    m = (String)m + " LO1:%7.3f LO1off:%4.1f";
                    String s = String.format((String)m, bb.index, fts1sb, lo2 * 1.0E-9, 1.0E-9 * bb.upper.skyFreqHz, 1.0E-9 * bb.lower.skyFreqHz, flo1 * 1.0E-9, lo1Offset * 1.0E-6);
                    this.logger.fine(s);
                }
                for (SSBbasebandInfo sb : BasebandInfo.ssbBasebandVec(bbinfo, loRange.sbSelect)) {
                    int bbIndex = sb.bbIndex;
                    int fts2sign = fts2sb[bbIndex];
                    if (verbose) {
                        String s = "SSB loop for BBindex:" + bbIndex;
                        s = s + " sb:" + String.valueOf((Object)sb.sbSelect);
                        s = s + String.format(" lo1:%.3f", 1.0E-9 * flo1);
                        s = s + " loRange:" + loRange.toString(9);
                        s = s + " loRangeSB:" + String.valueOf((Object)loRange.sbSelect);
                        s = s + " FTS2sb:" + fts2sign;
                        this.logger.fine(s);
                    }
                    LO2Parameters lo2p = t.LO2[bbIndex];
                    double w = sb.weight;
                    sumW += w;
                    sbsign = sb.sbSelect == SidebandSelect.Upper ? 1 : -1;
                    double lo2ideal = (double)sbsign * (sb.skyFreqHz - flo1) + 3.0E9;
                    double lo2 = this.lo2EdgeCorrection(lo2ideal);
                    this.loadLO2params(lo2p, lo2, fts2sign, sb.sbSelect);
                    double lo2act = LOSolutions.LO2Freq(lo2p);
                    sumWerr += w * Math.abs(lo2ideal - lo2act);
                }
                t.weightedError = werr = sumWerr / sumW;
                this.fixUnusedBasebands(t, bbinfo);
                trial.add(t);
            }
        }
        for (TuningParameters t : trial) {
            if (!this.legitimateSolution(t, verbose)) continue;
            this.tuningSolutions.add(t);
        }
    }

    protected short scoreSolutions(List<BasebandInfo> bbinfo, Band band, boolean verbose) {
        double maxScore = 0.0;
        int indexMaxScore = 0;
        double LSforMaxScore = 0.0;
        double ifHigh = this.IFhighFreq(band);
        double ifLow = this.IFlowFreq(band);
        double ifErrorNorm = (ifHigh - ifLow) / 2.0;
        double rxbandtop = this.bandHighFreq(band);
        double rxbandbot = this.bandLowFreq(band);
        double IFcenter = (ifLow + ifHigh) / 2.0;
        double wErrNorm = 0.0;
        wErrNorm = BasebandInfo.isOnlySSB(bbinfo) ? 2.5E7 : 2.0E8;
        int index = 0;
        for (TuningParameters t : this.tuningSolutions) {
            double sumW = 0.0;
            double sumWifErr = 0.0;
            for (SSBbasebandInfo b : BasebandInfo.sidebandVec(bbinfo)) {
                if (t.LO2[b.bbIndex].skyFreqSideband == SkyFreqSideband.LSB && b.sbSelect != SidebandSelect.Lower || t.LO2[b.bbIndex].skyFreqSideband != SkyFreqSideband.LSB && b.sbSelect == SidebandSelect.Lower) continue;
                double w = b.weight;
                LO2Parameters lo2p = t.LO2[b.bbIndex];
                double ifFreqReq = b.ifFreqHz;
                if (ifFreqReq < 100.0) {
                    ifFreqReq = IFcenter;
                }
                double ifFreq = LOSolutions.IFfrequency(lo2p);
                double absErr = Math.abs(ifFreqReq - ifFreq);
                double ifError = Math.pow(absErr / ifErrorNorm, 1.1);
                sumW += w;
                sumWifErr += w * ifError;
            }
            double ifErrTerm = 1.0 - sumWifErr / sumW;
            double wErr = t.weightedError;
            if (wErr > wErrNorm) {
                wErr = wErrNorm;
            }
            double wErrTerm = (wErrNorm - wErr) / wErrNorm;
            double lo1f = this.LO1Freq(t);
            double distFromBandEdge = Math.min(rxbandtop - lo1f, lo1f - rxbandbot);
            double possibleExtend = 4.3E7 * (double)t.coldMultiplier;
            double ifEffectiveTop = ifHigh - possibleExtend;
            double lo1OTcompat = 0.0;
            if (distFromBandEdge > ifHigh) {
                lo1OTcompat = 1.0;
            } else if (distFromBandEdge > ifEffectiveTop) {
                lo1OTcompat = 1.0 - 0.5 * (ifHigh - distFromBandEdge) / (ifHigh - ifEffectiveTop);
            }
            double score = 0.0;
            if (BasebandInfo.isOnlySSB(bbinfo)) {
                double scoreComps = 0.0;
                scoreComps += 5.0 * wErrTerm;
                scoreComps += 1.0 * ifErrTerm;
                score = 10.0 * (scoreComps += 3.0 * lo1OTcompat) / 9.0;
            } else {
                score = 10.0 * wErrTerm;
            }
            if (score - maxScore > 1.0E-4) {
                maxScore = score;
                indexMaxScore = index;
                LSforMaxScore = t.LSFrequency;
            } else if (Math.abs(score - maxScore) < 1.0E-4 && t.LSFrequency < LSforMaxScore) {
                maxScore = score;
                indexMaxScore = index;
                LSforMaxScore = t.LSFrequency;
            }
            t.score = score;
            ++index;
        }
        return (short)indexMaxScore;
    }

    protected void editSolutions(List<BasebandInfo> bbinfo, boolean verbose) throws Exception {
    }

    private void setTuningParameterIndices() {
        int solutionIndex = 0;
        for (TuningParameters t : this.tuningSolutions) {
            int n = solutionIndex;
            solutionIndex = (short)(solutionIndex + 1);
            t.index = (short)n;
        }
    }

    private void selectIFprocessors(Band band) {
        for (TuningParameters t : this.tuningSolutions) {
            if (band.sb() == SB.SB2) {
                boolean firstBB = true;
                for (int b = 0; b < 4; ++b) {
                    boolean selUSB;
                    if (t.LO2[b] == null || !t.LO2[b].isUsed) continue;
                    boolean bl = selUSB = t.LO2[b].skyFreqSideband == SkyFreqSideband.USB;
                    if (firstBB) {
                        firstBB = false;
                        t.band0band1selectUSB = selUSB;
                        t.band2band3selectUSB = selUSB;
                        continue;
                    }
                    if (b <= 1) {
                        t.band0band1selectUSB = selUSB;
                        continue;
                    }
                    t.band2band3selectUSB = selUSB;
                }
                continue;
            }
            t.band0band1selectUSB = true;
            t.band2band3selectUSB = true;
        }
    }

    private void fixUnusedBasebands(TuningParameters t, List<BasebandInfo> bbinfo) {
        if (bbinfo.size() == 4) {
            return;
        }
        int g = bbinfo.get((int)0).index;
        LO2Parameters lo2pPair0 = t.LO2[g];
        LO2Parameters lo2pPair1 = t.LO2[g];
        for (BasebandInfo bb : bbinfo) {
            g = bb.index;
            if (g <= 1) {
                lo2pPair0 = t.LO2[g];
            }
            if (g <= 1) continue;
            lo2pPair1 = t.LO2[g];
        }
        for (int b = 0; b < 4; ++b) {
            if (this.basebandIsUsed(bbinfo, b)) continue;
            t.LO2[b] = b <= 1 ? this.cloneLO2Parameters(lo2pPair0) : this.cloneLO2Parameters(lo2pPair1);
            t.LO2[b].isUsed = false;
        }
    }

    private boolean basebandIsUsed(List<BasebandInfo> bbinfo, int bbIndex) {
        for (BasebandInfo b : bbinfo) {
            if (b.index != bbIndex || !b.isUsed) continue;
            return true;
        }
        return false;
    }

    private void dumpBB(Band band, List<BasebandInfo> bbinfo) {
        String st = "================" + String.valueOf((Object)band) + "================\n";
        st = st + "Baseband    Freq   SB  Weight   SBsel\n";
        st = st + "--------  ------- ---  ------  ------\n";
        for (SSBbasebandInfo s : BasebandInfo.sidebandVec(bbinfo)) {
            String fmt = "    %d     %7.3f   %s  %6.2f  %6s\n";
            String str = String.format(fmt, s.bbIndex, 1.0E-9 * s.skyFreqHz, s.sbSelect.toShortString(), s.weight, BasebandInfo.basebandWithIndex(bbinfo, (int)s.bbIndex).sbSelect.toString());
            st = st + str;
        }
        st = st + "=====================================";
        this.logger.logToAudience(Level.FINE, st, "Operator");
    }

    static double LO2Freq(LO2Parameters parameters) {
        return parameters.DYTOFrequency;
    }

    public Map<BasebandName, Double> LO2Freqs(TuningParameters tp) {
        HashMap<BasebandName, Double> freqs = new HashMap<BasebandName, Double>(tp.LO2.length);
        for (int bbIndex = 0; bbIndex < tp.LO2.length; ++bbIndex) {
            freqs.put(BasebandName.from_int((int)bbIndex), LOSolutions.LO2Freq(tp.LO2[bbIndex]));
        }
        return freqs;
    }

    double loOffsetNormalize(double loOffset) {
        double harmonic = loOffset / 1.25E8;
        double normUnity = harmonic % 1.0;
        if (normUnity > 0.5) {
            normUnity -= 1.0;
        } else if (normUnity < -0.5) {
            normUnity += 1.0;
        }
        double newLOoffset = normUnity * 1.25E8;
        return newLOoffset;
    }

    public static double IFfrequency(LO2Parameters lo2p) {
        double lo2 = LOSolutions.LO2Freq(lo2p);
        return lo2 - 4.0E9 + 9.999999999E8;
    }

    private boolean checkIFrange(LO2Parameters lo2p, Band band) {
        double ifCenter = LOSolutions.IFfrequency(lo2p);
        double IFlow = ifCenter - 9.999999999E8;
        double IFhigh = ifCenter + 9.999999999E8;
        boolean accept = IFlow >= this.IFlowFreq(band) && IFhigh <= this.IFhighFreq(band);
        return accept;
    }

    private boolean legitimateSolution(TuningParameters t, boolean verbose) {
        String emsg = "LegitimateSolution test failed: ";
        Band band = Band.Band1;
        try {
            band = Band.band(t.receiverBand);
        }
        catch (Exception e) {
            this.logger.warning("Trouble in legitimateSolution translating receiver band" + e.toString());
            return false;
        }
        double floog = t.FLOOGFrequency;
        if (floog > 4.3E7 || floog < 2.2E7) {
            String f = "FLOOG (%.3f MHz) out of range.";
            if (verbose) {
                this.logger.fine("LegitimateSolution test failed: " + String.format(f, 1.0E-6 * floog));
            }
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            double fts2 = t.LO2[i].FTSFrequency;
            if (fts2 > 4.15E7 || fts2 < 2.1E7) {
                String f = "Baseband%d FTS2(%.3f MHz) out of range.";
                if (verbose) {
                    this.logger.fine("LegitimateSolution test failed: " + String.format(f, i, 1.0E-6 * fts2));
                }
                return false;
            }
            double dyto = t.LO2[i].DYTOFrequency;
            if (!(dyto > 1.4E10) && !(dyto < 8.0E9)) continue;
            String f = "Baseband%d DYTO(%.3f GHz) out of range.";
            if (verbose) {
                this.logger.fine("LegitimateSolution test failed: " + String.format(f, i, 1.0E-9 * dyto));
            }
            return false;
        }
        double loDriverFudge = 2000000.0;
        double loDriver = LOSolutions.LOdriver(t);
        double driverLow = this.lodriverLowFreq(band) - loDriverFudge;
        double driverHigh = this.lodriverHighFreq(band) + loDriverFudge;
        if (loDriver < driverLow || loDriver > driverHigh) {
            String f = "LOdriver (%.3f GHz) out of range (%.3f:%.3f)";
            if (verbose) {
                this.logger.fine("LegitimateSolution test failed: " + String.format("LOdriver (%.3f GHz) out of range (%.3f:%.3f)", 1.0E-9 * loDriver, 1.0E-9 * driverLow, 1.0E-9 * driverHigh));
            }
            return false;
        }
        if (verbose) {
            this.logger.info("Tuning accepted");
        }
        return true;
    }

    String hardwareParameterString(boolean extended) {
        return Band.hardwareParameterString(extended);
    }

    String hardwareParameterString() {
        return this.hardwareParameterString(false);
    }

    void loadLO2params(LO2Parameters lo2p, double lo2, int fts2sign, SidebandSelect sbSelect) {
        double h = (lo2 - (double)fts2sign * 3.125E7) / 1.25E8;
        double combHarm = Math.rint(h);
        double comb = 1.25E8 * combHarm;
        double fts2trial = Math.abs(lo2 - comb);
        double fts2 = fts2trial;
        if (fts2 < 2.1E7) {
            fts2 = 2.1E7;
        } else if (fts2 > 4.15E7) {
            fts2 = 4.15E7;
        }
        fts2 = this.fts2Avoidance(fts2);
        lo2p.DYTOFrequency = comb + (double)fts2sign * fts2;
        lo2p.FTSFrequency = fts2;
        boolean bl = lo2p.tuneHigh = fts2sign == 1;
        if (sbSelect == SidebandSelect.Upper) {
            lo2p.skyFreqSideband = SkyFreqSideband.USB;
        } else if (sbSelect == SidebandSelect.Lower) {
            lo2p.skyFreqSideband = SkyFreqSideband.LSB;
        } else if (sbSelect == SidebandSelect.Both) {
            lo2p.skyFreqSideband = SkyFreqSideband.DSB;
        } else {
            this.logger.info("sbSelect(" + String.valueOf((Object)sbSelect) + ") not supported");
        }
        lo2p.use12GHzFilter = lo2p.DYTOFrequency > 1.05E10;
        lo2p.isUsed = true;
    }

    LO2Parameters cloneLO2Parameters(LO2Parameters lo2p) {
        LO2Parameters l = new LO2Parameters();
        l.DYTOFrequency = lo2p.DYTOFrequency;
        l.FTSFrequency = lo2p.FTSFrequency;
        l.tuneHigh = lo2p.tuneHigh;
        l.skyFreqSideband = lo2p.skyFreqSideband;
        l.use12GHzFilter = lo2p.use12GHzFilter;
        l.isUsed = lo2p.isUsed;
        return l;
    }

    private FreqRange basebandRange(List<BasebandInfo> bbinfo) {
        FreqRange range = new FreqRange();
        for (BasebandInfo b : bbinfo) {
            for (SSBbasebandInfo s : b.sb) {
                if (s == null) continue;
                range.add(s.skyFreqHz);
            }
        }
        return range;
    }

    private String sbToString(int sb) {
        if (sb == 1) {
            return "USB";
        }
        if (sb == -1) {
            return "LSB";
        }
        if (sb == 0) {
            return "2SB";
        }
        return "???";
    }

    private FreqRange ifRange(Band band) {
        double ifLow = this.IFlowFreq(band) + 9.999999999E8;
        double ifHigh = this.IFhighFreq(band) - 9.999999999E8;
        return new FreqRange(ifLow, ifHigh);
    }

    protected short warmMultiplier(Band band) {
        return band.warmMultiplier();
    }

    protected short coldMultiplier(Band band) {
        return band.coldMultiplier();
    }

    protected double bandLowFreq(Band band) {
        return band.bandLowFreq();
    }

    protected double bandHighFreq(Band band) {
        return band.bandHighFreq();
    }

    protected double IFlowFreq(Band band) {
        return band.IFlowFreq();
    }

    protected double IFhighFreq(Band band) {
        return band.IFhighFreq();
    }

    protected double lodriverLowFreq(Band band) {
        return band.lodriverLowFreq();
    }

    protected double lodriverHighFreq(Band band) {
        return band.lodriverHighFreq();
    }

    protected double lo1LowFreq(Band band) {
        return band.lo1LowFreq();
    }

    protected double lo1HighFreq(Band band) {
        return band.lo1HighFreq();
    }

    protected SB sb(Band band) {
        return band.sb();
    }

    private void constructorInitialization(Logger logger, boolean addMarginForEarthsMotion) {
        LOSolutions.fts2AvoidanceFrequency[0] = 3.125E7;
        LOSolutions.fts2AvoidanceFrequency[1] = 2.5E7;
        LOSolutions.fts2AvoidanceFrequency[2] = 3.5714E7;
        LOSolutions.fts2AvoidanceFrequency[3] = 2.0833E7;
        LOSolutions.fts2AvoidanceFrequency[4] = 2.7778E7;
        LOSolutions.fts2AvoidanceFrequency[5] = 3.75E7;
        LOSolutions.fts2AvoidanceRange[0] = 100000.0;
        LOSolutions.fts2AvoidanceRange[1] = 80000.0;
        LOSolutions.fts2AvoidanceRange[2] = 57100.0;
        LOSolutions.fts2AvoidanceRange[3] = 66700.0;
        LOSolutions.fts2AvoidanceRange[4] = 44400.0;
        LOSolutions.fts2AvoidanceRange[5] = 40000.0;
        this.tuningSolutions.clear();
        if (logger == null) {
            logger = Logger.getLogger("global");
        }
        this.logger = AcsLogger.fromJdkLogger((Logger)logger, null);
        if (addMarginForEarthsMotion) {
            this.MaxDopFac = 1.0001027377269278;
            logger.fine("Adding a margin of 30.8km/s to allow for the Earth's motion.");
        } else {
            logger.fine("No margin or the Earth's motion will be used.");
        }
    }

    public List<BasebandInfo> getBaseBandInfo() {
        return this.baseband;
    }

    private class OffsetPair {
        private final double mean;
        private final double seperation;

        public OffsetPair(double mean, double seperation) {
            this.mean = mean;
            this.seperation = seperation;
        }

        public double mean() {
            return this.mean;
        }

        public double seperation() {
            return this.seperation;
        }
    }
}

