/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.CapabilityTableModel;
import uk.ac.starlink.vo.MetaColumnModel;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryException;
import uk.ac.starlink.vo.RegistryQueryFactory;
import uk.ac.starlink.vo.RegistryTable;

public class RegistryPanel
extends JPanel {
    private Thread queryWorker_;
    protected Action submitQueryAction_;
    protected Action cancelQueryAction_;
    protected JScrollPane resScroller_;
    protected RegistryTable regTable_;
    protected final JTable capTable_;
    private final CapabilityTableModel capTableModel_;
    private final RegistryQueryFactory queryFactory_;
    private JComponent workingPanel_;
    private JComponent dataPanel_;
    private List activeItems_;
    private String workingMessage_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RegistryPanel(RegistryQueryFactory queryFactory, boolean showCapabilities) {
        super(new BorderLayout());
        this.queryFactory_ = queryFactory;
        this.activeItems_ = new ArrayList();
        this.cancelQueryAction_ = new AbstractAction("Cancel Query"){

            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.cancelQuery();
            }
        };
        this.submitQueryAction_ = new AbstractAction("Submit Query"){

            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.workingMessage_ = "Searching registry";
                RegistryPanel.this.submitQuery();
            }
        };
        this.activeItems_.add(this.submitQueryAction_);
        this.queryFactory_.addEntryListener(this.submitQueryAction_);
        JComponent queryComponent = queryFactory.getComponent();
        if (queryComponent != null) {
            Box qBox = Box.createVerticalBox();
            this.activeItems_.add(queryComponent);
            qBox.add(queryComponent);
            qBox.add(Box.createVerticalStrut(5));
            Box controlLine = Box.createHorizontalBox();
            controlLine.add(Box.createHorizontalGlue());
            controlLine.add(new JButton(this.cancelQueryAction_));
            controlLine.add(Box.createHorizontalStrut(5));
            controlLine.add(new JButton(this.submitQueryAction_));
            qBox.add(controlLine);
            qBox.add(Box.createVerticalStrut(5));
            this.add((Component)qBox, "North");
        }
        this.resScroller_ = new JScrollPane();
        this.workingPanel_ = new JPanel(new BorderLayout());
        this.regTable_ = new RegistryTable();
        this.regTable_.setColumnSelectionAllowed(false);
        this.regTable_.setRowSelectionAllowed(true);
        this.dataPanel_ = this.regTable_;
        this.setWorking(null);
        if (showCapabilities) {
            this.capTableModel_ = new CapabilityTableModel();
            this.capTable_ = new JTable(this.capTableModel_);
            this.capTable_.setColumnSelectionAllowed(false);
            this.capTable_.setRowSelectionAllowed(true);
            ListSelectionModel regSelModel = this.regTable_.getSelectionModel();
            regSelModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    RegResource[] resources = RegistryPanel.this.getSelectedResources();
                    if (resources.length == 1) {
                        RegCapabilityInterface[] caps = RegistryPanel.this.getCapabilities(resources[0]);
                        RegistryPanel.this.capTableModel_.setCapabilities(caps);
                        if (caps.length > 0) {
                            RegistryPanel.this.capTable_.setRowSelectionInterval(0, 0);
                        }
                    }
                }
            });
        } else {
            this.capTable_ = null;
            this.capTableModel_ = null;
        }
        if (showCapabilities) {
            JSplitPane splitter = new JSplitPane(0);
            splitter.setTopComponent(this.resScroller_);
            splitter.setBottomComponent(new JScrollPane(this.capTable_));
            splitter.setResizeWeight(0.8);
            this.add((Component)splitter, "Center");
        } else {
            this.resScroller_.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)this.resScroller_, "Center");
        }
    }

    public void performAutoQuery(String workingMsg) {
        this.workingMessage_ = workingMsg;
        this.submitQuery();
    }

    protected void gotData(RegResource[] resources) {
    }

    public RegResource[] getResources() {
        return this.regTable_.getData();
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        return resource.getCapabilities();
    }

    public RegResource[] getSelectedResources() {
        ListSelectionModel smodel = this.getResourceSelectionModel();
        ArrayList<RegResource> sres = new ArrayList<RegResource>();
        RegResource[] data = this.getResources();
        for (int i = smodel.getMinSelectionIndex(); i <= smodel.getMaxSelectionIndex(); ++i) {
            if (!smodel.isSelectedIndex(i)) continue;
            sres.add(data[i]);
        }
        return sres.toArray(new RegResource[0]);
    }

    public RegCapabilityInterface[] getSelectedCapabilities() {
        if (this.capTable_ == null) {
            RegResource[] resources = this.getSelectedResources();
            ArrayList<RegCapabilityInterface> capList = new ArrayList<RegCapabilityInterface>();
            if (resources != null) {
                for (int ir = 0; ir < resources.length; ++ir) {
                    RegCapabilityInterface[] caps = this.getCapabilities(resources[ir]);
                    if (caps == null) continue;
                    capList.addAll(Arrays.asList(caps));
                }
            }
            return capList.toArray(new RegCapabilityInterface[0]);
        }
        ListSelectionModel smodel = this.capTable_.getSelectionModel();
        RegCapabilityInterface[] allCaps = this.capTableModel_.getCapabilities();
        ArrayList<RegCapabilityInterface> capList = new ArrayList<RegCapabilityInterface>();
        for (int i = smodel.getMinSelectionIndex(); i <= smodel.getMaxSelectionIndex(); ++i) {
            if (!smodel.isSelectedIndex(i)) continue;
            capList.add(allCaps[i]);
        }
        return capList.toArray(new RegCapabilityInterface[0]);
    }

    public void submitQuery() {
        RegistryQuery query;
        try {
            query = this.queryFactory_.getQuery();
        }
        catch (Exception e) {
            ErrorDialog.showError((Component)this, (String)"Query Error", (Throwable)e);
            return;
        }
        if (query == null || query.getText() == null || query.getText().trim() == null) {
            JOptionPane.showMessageDialog(this, "No query selected", "No Query", 0);
            return;
        }
        this.setWorking(this.workingMessage_);
        Thread worker = new Thread("Registry query"){
            List resourceList;
            String errmsg;
            Thread wk;
            {
                super(x0);
                this.resourceList = new ArrayList();
                this.wk = this;
            }

            public void run() {
                Throwable error = null;
                try {
                    Iterator it = query.getQueryIterator();
                    while (it.hasNext() && !this.isInterrupted()) {
                        this.resourceList.add((RegResource)it.next());
                    }
                    logger_.info("Records found: " + this.resourceList.size());
                    if (this.resourceList.isEmpty()) {
                        this.errmsg = "No resources found for query";
                    }
                }
                catch (RegistryQueryException e) {
                    error = e.getCause() == null ? e : e.getCause();
                }
                catch (Throwable e) {
                    error = e;
                }
                final Throwable error1 = error;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (RegistryPanel.this.queryWorker_ == wk) {
                            if (errmsg != null) {
                                JOptionPane.showMessageDialog(RegistryPanel.this, errmsg, "Query Failed", 0);
                            } else if (error1 != null) {
                                ErrorDialog.showError((Component)RegistryPanel.this, (String)"Query Error", (Throwable)error1);
                            } else {
                                RegResource[] resources = resourceList.toArray(new RegResource[0]);
                                (this).RegistryPanel.this.regTable_.setData(resources);
                                RegistryPanel.this.gotData(resources);
                            }
                            RegistryPanel.this.setWorking(null);
                        }
                    }
                });
            }
        };
        Thread oldWorker = this.queryWorker_;
        if (oldWorker != null) {
            oldWorker.interrupt();
        }
        this.queryWorker_ = worker;
        worker.start();
    }

    public void cancelQuery() {
        if (this.queryWorker_ != null) {
            this.queryWorker_.interrupt();
            this.queryWorker_ = null;
        }
        this.setWorking(null);
    }

    public ListSelectionModel getResourceSelectionModel() {
        return this.regTable_.getSelectionModel();
    }

    public JMenu makeColumnVisibilityMenu(String name) {
        return ((MetaColumnModel)this.regTable_.getColumnModel()).makeCheckBoxMenu(name);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator it = this.activeItems_.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof Action) {
                ((Action)item).setEnabled(enabled);
                continue;
            }
            if (item instanceof Component) {
                ((Component)item).setEnabled(enabled);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private void setWorking(String message) {
        boolean working;
        boolean bl = working = message != null;
        if (!working) {
            this.resScroller_.setViewportView(this.dataPanel_);
        } else {
            this.regTable_.setData(new RegResource[0]);
            if (this.capTableModel_ != null) {
                this.capTableModel_.setCapabilities(new RegCapabilityInterface[0]);
            }
            Box msgLine = Box.createHorizontalBox();
            msgLine.add(Box.createHorizontalGlue());
            msgLine.add(new JLabel(message));
            msgLine.add(Box.createHorizontalGlue());
            Box progLine = Box.createHorizontalBox();
            JProgressBar progBar = new JProgressBar();
            progBar.setIndeterminate(true);
            progLine.add(Box.createHorizontalGlue());
            progLine.add(progBar);
            progLine.add(Box.createHorizontalGlue());
            Box workBox = Box.createVerticalBox();
            workBox.add(Box.createVerticalGlue());
            workBox.add(msgLine);
            workBox.add(Box.createVerticalStrut(5));
            workBox.add(progLine);
            workBox.add(Box.createVerticalGlue());
            this.workingPanel_.removeAll();
            this.workingPanel_.add(workBox);
            this.resScroller_.setViewportView(this.workingPanel_);
        }
        this.setEnabled(!working);
        this.cancelQueryAction_.setEnabled(working);
    }

    static {
        $assertionsDisabled = !RegistryPanel.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.vo");
    }
}

