/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.classloading;

import alma.acs.classloading.JarOrderOptimizer;
import alma.acs.makesupport.AcsJarFileFinder;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class AcsSystemClassLoader
extends URLClassLoader {
    public static final String PROPERTY_JARDIRS = "acs.system.classpath.jardirs";
    public static final String PROPERTY_TOPJARSONLY = "acs.system.classpath.topjarsonly";
    public static final String PROPERTY_CLASSLOADERVERBOSE = "acs.system.classloader.verbose";
    private boolean verbose;
    private final JarOrderOptimizer optimizer;
    private final SecureClassLoader appClassLoader;

    public AcsSystemClassLoader(ClassLoader parent) {
        super(new URL[0], parent.getParent());
        if (!(parent instanceof SecureClassLoader)) {
            throw new IllegalStateException("AcsSystemClassLoader expects parent CL of type SecureClassLoader!");
        }
        this.appClassLoader = (SecureClassLoader)parent;
        this.verbose = Boolean.getBoolean(PROPERTY_CLASSLOADERVERBOSE);
        List<File> jarFileList = new ArrayList<File>();
        this.optimizer = new JarOrderOptimizer(this.verbose);
        String jarDirPath = System.getProperty(PROPERTY_JARDIRS);
        if (jarDirPath != null) {
            File[] jarDirs = this.parseJarDirs(jarDirPath);
            AcsJarFileFinder jarFinder = new AcsJarFileFinder(jarDirs, null);
            jarFileList.addAll(Arrays.asList(jarFinder.getAllFiles()));
            if (Boolean.getBoolean(PROPERTY_TOPJARSONLY)) {
                System.out.println("AcsSystemClassLoader running in test mode: will only use jar files from priority list.");
                jarFileList = this.optimizer.getTopJarsOnly(jarFileList);
            }
            this.optimizer.sortJars(jarFileList);
        } else {
            System.err.println("No jar path given in property acs.system.classpath.jardirs! If that is intended, you should not use AcsSystemClassLoader at all!");
        }
        this.prependCLASSPATHJars(jarFileList);
        for (File cpEntry : jarFileList) {
            try {
                this.addURL(cpEntry.toURI().toURL());
                if (!this.verbose) continue;
                System.out.println("added " + cpEntry.getAbsolutePath() + " to the custom system class loader's path.");
            }
            catch (Exception e) {
                System.err.println("failed to add " + cpEntry.getAbsolutePath() + " to the custom class loader's path." + e.toString());
            }
        }
    }

    private File[] parseJarDirs(String jarDirPath) {
        StringTokenizer tok = new StringTokenizer(jarDirPath, File.pathSeparator);
        File[] jarDirs = new File[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            jarDirs[i] = new File(tok.nextToken());
            ++i;
        }
        return jarDirs;
    }

    private void prependCLASSPATHJars(List<File> jarFileList) {
        if (this.verbose) {
            System.out.print("Will prepend the following entries from the CLASSPATH to AcsSystemClassLoader's entries: ");
        }
        URL[] sysCP = AcsSystemClassLoader.getInternalURLs(this.appClassLoader);
        ArrayList<File> sysCPList = new ArrayList<File>();
        for (int i = 0; i < sysCP.length; ++i) {
            try {
                File entry = new File(sysCP[i].toURI());
                sysCPList.add(entry);
                if (!this.verbose) continue;
                System.out.print(entry.getAbsolutePath() + ", ");
                continue;
            }
            catch (URISyntaxException e) {
                System.err.println("Failed to add CLASSPATH entry '" + sysCP[i] + "' to AcsSystemClassLoader: " + e.toString());
            }
        }
        if (this.verbose) {
            System.out.println();
        }
        jarFileList.addAll(0, sysCPList);
    }

    private static URL[] getInternalURLs(ClassLoader classLoader) {
        URL[] urls = new URL[]{};
        try {
            Class<?> builtinClazzLoader = Class.forName("jdk.internal.loader.BuiltinClassLoader");
            if (builtinClazzLoader != null) {
                Method getURLs;
                Field ucpField = builtinClazzLoader.getDeclaredField("ucp");
                ucpField.setAccessible(true);
                Object ucpObject = ucpField.get(classLoader);
                Class<?> clazz = Class.forName("jdk.internal.loader.URLClassPath");
                if (clazz != null && ucpObject != null && (getURLs = clazz.getMethod("getURLs", new Class[0])) != null) {
                    urls = (URL[])getURLs.invoke(ucpObject, new Object[0]);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("Could not obtain classpath URLs - Exception was:");
            e.printStackTrace();
        }
        return urls;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (this.verbose && ClassLoader.getSystemClassLoader() != this) {
            System.err.println("Warning: AcsSystemClassLoader is not registered as the JVM's system class loader!");
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (name.startsWith("alma.acs.") || name.startsWith("com.cosylab.util")) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = super.loadClass(name, false);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.optimizer.isClassKnownToBeUnavailable(name)) {
            throw new ClassNotFoundException("ACS and application software are not supposed to deliver a class like '" + name + "' and therefore AcsSystemClassLoader won't attempt to load it (for IO optimization).");
        }
        Class<?> clazz = null;
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.verbose) {
                System.err.println(AcsSystemClassLoader.class.getName() + " failed to load class " + name);
                e.printStackTrace();
            }
            throw e;
        }
        return clazz;
    }

    private void appendToClassPathForInstrumentation(String jarPathName) {
        File jarFile = new File(jarPathName);
        try {
            this.addURL(jarFile.toURI().toURL());
            System.out.println("AcsSystemClassLoader#appendToClassPathForInstrumentation called with jar file " + jarPathName);
        }
        catch (MalformedURLException ex) {
            System.err.println("AcsSystemClassLoader#appendToClassPathForInstrumentation failed with MalformedURLException for jar file " + jarPathName);
        }
    }
}

