/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import alma.acs.util.CmdLineOption;
import alma.acs.util.CmdLineRegisteredOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CmdLineArgs {
    private Map m_registeredOptions;
    private LinkedHashMap m_options;

    public CmdLineArgs() {
        this.reset();
    }

    public void reset() {
        this.m_registeredOptions = new HashMap();
        this.m_options = new LinkedHashMap();
    }

    public void registerOption(String name, int minValuesCount) {
        CmdLineRegisteredOption opt = new CmdLineRegisteredOption(name, minValuesCount);
        this.registerOption(opt);
    }

    public void registerOption(CmdLineRegisteredOption opt) {
        if (opt != null) {
            this.m_registeredOptions.put(opt.getName(), opt);
            if (opt.getAlternativeName() != null) {
                this.m_registeredOptions.put(opt.getAlternativeName(), opt);
            }
        }
    }

    public void parseArgs(String[] args) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            CmdLineRegisteredOption regOpt;
            if (!this.isKey(args, i)) {
                System.out.println("stray option value " + args[i] + " found outside of any key.");
                this.m_options.put(args[i], args[i]);
                ++i;
                continue;
            }
            CmdLineOption opt = (CmdLineOption)this.m_registeredOptions.get(args[i]);
            if (opt == null) {
                opt = new CmdLineOption(args[i]);
            }
            ArrayList<String> values = new ArrayList<String>();
            int lastValIndex = i;
            if (opt instanceof CmdLineRegisteredOption && (lastValIndex = i + (regOpt = (CmdLineRegisteredOption)opt).getMinValueCount()) >= args.length) {
                System.out.println("warning: less than the required " + regOpt.getMinValueCount() + " values given for option " + regOpt.getName());
            }
            ++i;
            while (!(i >= args.length || i > lastValIndex && this.isKey(args, i))) {
                values.add(args[i]);
                ++i;
            }
            String[] valueArray = values.toArray(new String[0]);
            this.m_options.put(opt, valueArray);
        }
    }

    public String[] getAllArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.m_options != null) {
            for (Object element : this.m_options.keySet()) {
                if (element instanceof String) {
                    args.add(element);
                    continue;
                }
                CmdLineOption clo = (CmdLineOption)element;
                args.add(clo.getName());
                String[] values = (String[])this.m_options.get(clo);
                args.addAll(Arrays.asList(values));
            }
        }
        String[] argArray = args.toArray(new String[0]);
        return argArray;
    }

    public CmdLineOption[] getRecognizedArgs() {
        ArrayList<CmdLineOption> args = new ArrayList<CmdLineOption>();
        if (this.m_options != null) {
            for (Object element : this.m_options.keySet()) {
                if (!(element instanceof CmdLineOption)) continue;
                CmdLineOption clo = (CmdLineOption)element;
                args.add(clo);
            }
        }
        CmdLineOption[] argArray = args.toArray(new CmdLineOption[0]);
        return argArray;
    }

    public boolean isSpecified(CmdLineRegisteredOption clo) {
        return this.m_options.get(clo) != null;
    }

    public String[] getValues(CmdLineOption clo) {
        return (String[])this.m_options.get(clo);
    }

    private boolean isKey(String[] args, int index) {
        if (this.m_registeredOptions.containsKey(args[index])) {
            return true;
        }
        return args[index].startsWith("-");
    }
}

