/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CircularArrayList<T>
extends AbstractList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = -1794729598452372631L;
    private T[] elementData;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public CircularArrayList() {
        this(10);
    }

    public CircularArrayList(int size) {
        this.elementData = new Object[size];
    }

    public CircularArrayList(Collection<T> c) {
        this.tail = c.size();
        this.elementData = new Object[c.size()];
        c.toArray(this.elementData);
    }

    private int convert(int index) {
        return (index + this.head) % this.elementData.length;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newData = new Object[newCapacity];
            this.toArray(newData);
            this.tail = this.size;
            this.head = 0;
            this.elementData = newData;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.head < this.tail) {
            System.arraycopy(this.elementData, this.head, a, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.elementData, this.head, a, 0, this.elementData.length - this.head);
            System.arraycopy(this.elementData, 0, a, this.elementData.length - this.head, this.tail);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public T get(int index) {
        this.rangeCheck(index);
        return this.elementData[this.convert(index)];
    }

    @Override
    public T set(int index, T element) {
        ++this.modCount;
        this.rangeCheck(index);
        T oldValue = this.elementData[this.convert(index)];
        this.elementData[this.convert((int)index)] = element;
        return oldValue;
    }

    @Override
    public boolean add(T o) {
        ++this.modCount;
        this.ensureCapacity(this.size + 1 + 1);
        this.elementData[this.tail] = o;
        this.tail = (this.tail + 1) % this.elementData.length;
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        ++this.modCount;
        this.rangeCheck(index);
        int pos = this.convert(index);
        try {
            T t = this.elementData[pos];
            return t;
        }
        finally {
            this.elementData[pos] = null;
            if (pos == this.head) {
                this.head = (this.head + 1) % this.elementData.length;
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.elementData, this.head, this.elementData, this.head + 1, pos - this.head);
                this.head = (this.head + 1) % this.elementData.length;
            } else {
                System.arraycopy(this.elementData, pos + 1, this.elementData, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            }
            --this.size;
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        int i = this.head;
        while (i != this.tail) {
            this.elementData[i] = null;
            i = (i + 1) % this.elementData.length;
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        ++this.modCount;
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew + 1);
        Iterator<T> e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            this.elementData[this.tail] = e.next();
            this.tail = (this.tail + 1) % this.elementData.length;
            ++this.size;
        }
        return numNew != 0;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        int i = this.head;
        while (i != this.tail) {
            s.writeObject(this.elementData[i]);
            i = (i + 1) % this.elementData.length;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.head = 0;
        this.size = this.tail = s.readInt();
        this.elementData = new Object[this.tail];
        for (int i = 0; i < this.tail; ++i) {
            this.elementData[i] = s.readObject();
        }
    }
}

