/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.enumerations;

public enum ReceiverType {
    SSB("Single Side Band"),
    TSB("2 Side Band", "2SB"),
    DSB("Double Side Band");

    private String label;
    private String shortLabel;

    private ReceiverType(String label) {
        this.label = label;
        this.shortLabel = this.name();
    }

    private ReceiverType(String label, String shortLabel) {
        this.label = label;
        this.shortLabel = shortLabel;
    }

    public static ReceiverType getReceiverType(String str) {
        for (ReceiverType rt : ReceiverType.values()) {
            if (!rt.name().equals(str) && !rt.label.equals(str) && !rt.shortLabel.equals(str)) continue;
            return rt;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.shortLabel;
    }
}

