/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.HashMap;

public class CGI {
    private HashMap<String, String[]> params = new HashMap();
    private StringBuffer fieldBuffer;
    private String dataBoundary;
    private String fieldName;
    private String fieldFile;

    public CGI() {
        this.parseParams();
    }

    public CGI(String input) {
        if (input != null && input.indexOf(61) < 0 && input.indexOf(37) >= 0) {
            try {
                input = URLDecoder.decode(input, "UTF-8");
            }
            catch (Exception e) {
                System.err.println("Decoding error?? " + e);
            }
        }
        this.parseString(input);
    }

    public HashMap<String, String[]> getParams() {
        return this.params;
    }

    protected void parseParams() {
        String type = System.getenv("REQUEST_METHOD");
        if (type != null) {
            type = type.toUpperCase();
        }
        type = type == null ? (System.getenv("QUERY_STRING") != null ? "GET" : "POST") : type.toUpperCase();
        String queryString = null;
        if (type.equals("GET")) {
            queryString = System.getenv("QUERY_STRING");
        } else {
            String enc = System.getenv("CONTENT_TYPE");
            if (enc != null && enc.startsWith("multipart/form")) {
                this.parseMultipartForm(enc);
                return;
            }
            try {
                BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
                queryString = bf.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read standard input on POST");
            }
        }
        this.parseString(queryString);
    }

    protected void parseString(String queryString) {
        if (queryString != null) {
            String[] fields;
            for (String field : fields = queryString.split("\\&")) {
                this.decodeField(field);
            }
        }
    }

    protected String getField(String key, String line) {
        String[] fields;
        for (String field : fields = line.split(";")) {
            if (!(field = field.trim()).startsWith(key + "=")) continue;
            String value = field.substring(key.length() + 1);
            if (value.length() > 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }

    protected void parseMultipartForm(String type) {
        LineReader lr = new FieldWaiter();
        this.dataBoundary = "--" + this.getField("boundary", type);
        String lastLine = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                char ch = '\u0000';
                if (line.length() > 0) {
                    ch = line.charAt(line.length() - 1);
                }
                char chr = ch;
                lr = lr.processLine(line);
                lastLine = line;
            }
        }
        catch (IOException e) {
            System.err.println("Error reading standard input:" + e);
        }
        if (!(lr instanceof FieldWaiter)) {
            throw new Error("Invalid state at termination of multipart form parse");
        }
    }

    protected void addField() {
        if (this.fieldFile == null && this.fieldBuffer.length() > 0) {
            this.fieldBuffer.setLength(this.fieldBuffer.length() - 1);
        }
        this.addField(this.fieldName, this.fieldBuffer.toString());
    }

    protected void decodeField(String field) {
        String[] elems = field.split("=", 2);
        try {
            if (elems.length == 2) {
                String key = URLDecoder.decode(elems[0], "UTF-8");
                String val = URLDecoder.decode(elems[1], "UTF-8");
                this.addField(key, val);
            }
        }
        catch (Exception e) {
            throw new Error("Unexpected error:" + e);
        }
    }

    protected void addField(String key, String val) {
        if (this.params.containsKey(key)) {
            String[] old = this.params.get(key);
            String[] nw = new String[old.length + 1];
            System.arraycopy(old, 0, nw, 0, old.length);
            nw[old.length] = val;
            this.params.put(key, nw);
        } else {
            this.params.put(key, new String[]{val});
        }
    }

    public String value(String key) {
        if (this.params.containsKey(key)) {
            return this.params.get(key)[0];
        }
        return null;
    }

    public String[] values(String key) {
        return this.params.get(key);
    }

    public int count(String key) {
        if (this.params.containsKey(key)) {
            return this.params.get(key).length;
        }
        return 0;
    }

    public String[] keys() {
        return this.params.keySet().toArray(new String[0]);
    }

    static /* synthetic */ String access$002(CGI x0, String x1) {
        x0.fieldName = x1;
        return x0.fieldName;
    }

    static /* synthetic */ String access$102(CGI x0, String x1) {
        x0.fieldFile = x1;
        return x0.fieldFile;
    }

    static /* synthetic */ StringBuffer access$302(CGI x0, StringBuffer x1) {
        x0.fieldBuffer = x1;
        return x0.fieldBuffer;
    }

    static /* synthetic */ String access$500(CGI x0) {
        return x0.dataBoundary;
    }

    static /* synthetic */ StringBuffer access$300(CGI x0) {
        return x0.fieldBuffer;
    }

    private class DataReader
    implements LineReader {
        private DataReader() {
        }

        @Override
        public LineReader processLine(String string) {
            if (string.equals(CGI.this.dataBoundary)) {
                CGI.this.addField();
                return new FieldWaiter();
            }
            if (string.length() == CGI.this.dataBoundary.length() + 2 && string.equals(CGI.this.dataBoundary + "--")) {
                CGI.this.addField();
                return new FieldWaiter();
            }
            CGI.this.fieldBuffer.append(string);
            CGI.this.fieldBuffer.append('\n');
            return this;
        }
    }

    private class BlankWaiter
    implements LineReader {
        private BlankWaiter() {
        }

        @Override
        public LineReader processLine(String string) {
            if (string.length() == 0) {
                CGI.this.fieldBuffer = new StringBuffer();
                return new DataReader();
            }
            return this;
        }
    }

    private class FieldWaiter
    implements LineReader {
        private FieldWaiter() {
        }

        @Override
        public LineReader processLine(String string) {
            if (string.toLowerCase().startsWith("content-disposition")) {
                CGI.this.fieldName = CGI.this.getField("name", string);
                CGI.this.fieldFile = CGI.this.getField("filename", string);
                return new BlankWaiter();
            }
            return this;
        }
    }

    private static interface LineReader {
        public LineReader processLine(String var1);
    }
}

