/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;

public class Fits {
    private ArrayDataInput dataStr;
    private Vector hduList = new Vector();
    private boolean atEOF;
    private long lastFileOffset = -1L;
    private static String[] urlProtocols = new String[]{"http:", "ftp:", "https:", "file:"};
    private boolean gzipCompress = false;

    public static String version() {
        return "1.040";
    }

    public Fits() {
    }

    public Fits(InputStream str) throws FitsException {
        this.streamInit(str, false);
    }

    public Fits(InputStream str, boolean compressed) throws FitsException {
        this.streamInit(str, false);
    }

    protected void streamInit(InputStream str, boolean seekable) throws FitsException {
        if (str == null) {
            throw new FitsException("Null stream in constructor");
        }
        PushbackInputStream pb = new PushbackInputStream(str, 2);
        int mag1 = -1;
        int mag2 = -1;
        try {
            mag1 = pb.read();
            mag2 = pb.read();
            pb.unread(mag2);
            pb.unread(mag1);
        }
        catch (IOException e) {
            throw new FitsException("Unable to peek on input stream:" + e);
        }
        if (mag1 == 83 && mag2 == 73) {
            this.streamInit(pb, false, seekable);
            return;
        }
        if (mag1 == 31) {
            if (mag2 == 139) {
                this.gzipCompress = true;
                this.streamInit(pb, true, false);
                return;
            }
            if (mag2 == 157) {
                this.gzipCompress = false;
                this.streamInit(pb, true, false);
                return;
            }
        }
        throw new FitsException("Invalid Magic number for FITS file");
    }

    protected void streamInit(InputStream str, boolean compressed, boolean seekable) throws FitsException {
        if (compressed) {
            if (this.gzipCompress) {
                try {
                    str = new GZIPInputStream(str);
                }
                catch (IOException e) {
                    throw new FitsException("Cannot inflate input stream" + e);
                }
            }
            try {
                Process proc = new ProcessBuilder("uncompress", "-c").start();
                final InputStream src = str;
                final OutputStream input = proc.getOutputStream();
                Thread copier = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int len;
                            byte[] buffer = new byte[8192];
                            while ((len = src.read(buffer, 0, buffer.length)) > 0) {
                                input.write(buffer, 0, len);
                            }
                            src.close();
                            input.close();
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                });
                copier.start();
                str = proc.getInputStream();
            }
            catch (Exception e) {
                throw new FitsException("Unable to read .Z compressed stream.\nIs `uncompress' in the path?\n:" + e);
            }
        }
        this.dataStr = str instanceof ArrayDataInput ? (ArrayDataInput)((Object)str) : new BufferedDataInputStream(str);
    }

    protected void randomInit(File f) throws FitsException {
        String permissions = "r";
        if (!f.exists() || !f.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        if (f.canWrite()) {
            permissions = permissions + "w";
        }
        try {
            this.dataStr = new BufferedFile(f, permissions);
            ((BufferedFile)this.dataStr).seek(0L);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open file " + f.getPath());
        }
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, FitsUtil.isCompressed(myFile));
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            if (compressed) {
                FileInputStream str = new FileInputStream(myFile);
                this.streamInit(str, true);
            } else {
                this.randomInit(myFile);
            }
        }
        catch (IOException e) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile);
        }
    }

    public Fits(String filename) throws FitsException {
        this(filename, FitsUtil.isCompressed(filename));
    }

    public Fits(String filename, boolean compressed) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        int len = filename.length();
        String lc = filename.toLowerCase();
        try {
            URL test = new URL(filename);
            InputStream is = FitsUtil.getURLStream(new URL(filename), 0);
            this.streamInit(is, false);
            return;
        }
        catch (Exception e) {
            File fil = new File(filename);
            if (fil.exists()) {
                this.fileInit(fil, compressed);
                return;
            }
            try {
                InputStream str = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
                this.streamInit(str, false);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return;
        }
    }

    public Fits(URL myURL) throws FitsException {
        this(myURL, FitsUtil.isCompressed(myURL.getFile()));
    }

    public Fits(URL myURL, boolean compressed) throws FitsException {
        try {
            this.streamInit(FitsUtil.getURLStream(myURL, 0), false);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open input from URL:" + myURL);
        }
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int size = this.getNumberOfHDUs();
        if (size == 0) {
            return null;
        }
        Object[] hdus = new BasicHDU[size];
        this.hduList.copyInto(hdus);
        return hdus;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        Header hdr;
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        if (!this.gzipCompress && this.lastFileOffset > 0L) {
            FitsUtil.reposition(this.dataStr, this.lastFileOffset);
        }
        if ((hdr = Header.readHeader(this.dataStr)) == null) {
            this.atEOF = true;
            return null;
        }
        Data datum = hdr.makeData();
        try {
            datum.read(this.dataStr);
        }
        catch (PaddingException e) {
            e.updateHeader(hdr);
            throw e;
        }
        this.lastFileOffset = FitsUtil.findOffset(this.dataStr);
        BasicHDU nextHDU = FitsFactory.HDUFactory(hdr, datum);
        this.hduList.addElement(nextHDU);
        return nextHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        for (int i = 0; i < n; ++i) {
            this.skipHDU();
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header hdr = new Header(this.dataStr);
        if (hdr == null) {
            this.atEOF = true;
            return;
        }
        int dataSize = (int)hdr.getDataSize();
        this.dataStr.skip(dataSize);
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int size;
        for (int i = size = this.getNumberOfHDUs(); i <= n; ++i) {
            BasicHDU hdu = this.readHDU();
            if (hdu != null) continue;
            return null;
        }
        try {
            return (BasicHDU)this.hduList.elementAt(n);
        }
        catch (NoSuchElementException e) {
            throw new FitsException("Internal Error: hduList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException e) {
                throw new FitsException("IO error: " + e);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void addHDU(BasicHDU myHDU) throws FitsException {
        this.insertHDU(myHDU, this.getNumberOfHDUs());
    }

    public void insertHDU(BasicHDU myHDU, int n) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (n < 0 || n > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            if (n == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    ((BasicHDU)this.hduList.elementAt(0)).setPrimaryHDU(false);
                }
                if (myHDU.canBePrimary()) {
                    myHDU.setPrimaryHDU(true);
                    this.hduList.insertElementAt(myHDU, 0);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    myHDU.setPrimaryHDU(false);
                    this.hduList.insertElementAt(myHDU, 1);
                }
            } else {
                myHDU.setPrimaryHDU(false);
                this.hduList.insertElementAt(myHDU, n);
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("hduList inconsistency in insertHDU");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.getNumberOfHDUs();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.hduList.removeElementAt(n);
            if (n == 0 && size > 1) {
                BasicHDU newFirst = (BasicHDU)this.hduList.elementAt(0);
                if (newFirst.canBePrimary()) {
                    newFirst.setPrimaryHDU(true);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("Internal Error: hduList Vector Inconsitency");
        }
    }

    public void write(DataOutput os) throws FitsException {
        ArrayDataOutput obs;
        boolean newOS = false;
        if (os instanceof ArrayDataOutput) {
            obs = (ArrayDataOutput)os;
        } else if (os instanceof DataOutputStream) {
            newOS = true;
            obs = new BufferedDataOutputStream((DataOutputStream)os);
        } else {
            throw new FitsException("Cannot create ArrayDataOutput from class " + os.getClass().getName());
        }
        for (int i = 0; i < this.getNumberOfHDUs(); ++i) {
            try {
                BasicHDU hh = (BasicHDU)this.hduList.elementAt(i);
                hh.write(obs);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                throw new FitsException("Internal Error: Vector Inconsistency" + e);
            }
        }
        if (newOS) {
            try {
                obs.flush();
                obs.close();
            }
            catch (IOException e) {
                System.err.println("Warning: error closing FITS output stream");
            }
        }
        try {
            if (obs instanceof BufferedFile) {
                ((BufferedFile)obs).setLength(((BufferedFile)obs).getFilePointer());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void read(InputStream is) throws FitsException, IOException {
        boolean newIS = false;
        this.dataStr = is instanceof ArrayDataInput ? (ArrayDataInput)((Object)is) : new BufferedDataInputStream(is);
        this.read();
        if (newIS) {
            this.dataStr.close();
            this.dataStr = null;
        }
    }

    public int currentSize() {
        return this.hduList.size();
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void setStream(ArrayDataInput stream) {
        this.dataStr = stream;
        this.atEOF = false;
        this.lastFileOffset = -1L;
    }

    public static BasicHDU makeHDU(Header h) throws FitsException {
        Data d = FitsFactory.dataFactory(h);
        return FitsFactory.HDUFactory(h, d);
    }

    public static BasicHDU makeHDU(Object o) throws FitsException {
        return FitsFactory.HDUFactory(o);
    }

    public static BasicHDU makeHDU(Data datum) throws FitsException {
        Header hdr = new Header();
        datum.fillHeader(hdr);
        return FitsFactory.HDUFactory(hdr, datum);
    }

    public static void setChecksum(BasicHDU hdu) throws HeaderCardException, FitsException, IOException {
        Header hdr = hdu.getHeader();
        hdr.deleteKey("CHECKSUM");
        String doneAt = "as of " + FitsDate.getFitsDateString();
        hdr.addValue("CHECKSUM", "0000000000000000", doneAt);
        ByteArrayOutputStream hduByteImage = new ByteArrayOutputStream();
        System.err.flush();
        hdu.write(new BufferedDataOutputStream(hduByteImage));
        byte[] data = hduByteImage.toByteArray();
        long csu = Fits.checksum(data);
        hdr.addValue("CHECKSUM", Fits.checksumEnc(csu, true), doneAt);
    }

    public void setChecksum() throws HeaderCardException, FitsException, IOException {
        for (int i = 0; i < this.getNumberOfHDUs(); ++i) {
            Fits.setChecksum(this.getHDU(i));
        }
    }

    private static long checksum(byte[] data) {
        long hi = 0L;
        long lo = 0L;
        int len = 2 * (data.length / 4);
        int remain = data.length % 4;
        for (int i = 0; i < len; i += 2) {
            hi += (long)(data[2 * i] << 8) & 0xFF00L | (long)data[2 * i + 1] & 0xFFL;
            lo += (long)(data[2 * i + 2] << 8) & 0xFF00L | (long)data[2 * i + 3] & 0xFFL;
        }
        if (remain >= 1) {
            hi += (long)(data[2 * len] << 8) & 0xFF00L;
        }
        if (remain >= 2) {
            hi += (long)data[2 * len + 1] & 0xFFL;
        }
        if (remain >= 3) {
            lo += (long)(data[2 * len + 2] << 8) & 0xFF00L;
        }
        long hicarry = hi >>> 16;
        long locarry = lo >>> 16;
        while (hicarry != 0L || locarry != 0L) {
            hi = (hi & 0xFFFFL) + locarry;
            lo = (lo & 0xFFFFL) + hicarry;
            hicarry = hi >>> 16;
            locarry = lo >>> 16;
        }
        return (hi << 16) + lo;
    }

    private static String checksumEnc(long c, boolean compl) {
        byte[] asc = new byte[16];
        int[] exclude = new int[]{58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 96};
        long[] mask = new long[]{0xFF000000L, 0xFF0000L, 65280L, 255L};
        int offset = 48;
        long value = compl ? c ^ 0xFFFFFFFFFFFFFFFFL : c;
        for (int i = 0; i < 4; ++i) {
            int byt = (int)((value & mask[i]) >>> 24 - 8 * i);
            int quotient = byt / 4 + 48;
            int remainder = byt % 4;
            int[] ch = new int[4];
            for (int j = 0; j < 4; ++j) {
                ch[j] = quotient;
            }
            ch[0] = ch[0] + remainder;
            boolean check = true;
            while (check) {
                check = false;
                for (int k = 0; k < exclude.length; ++k) {
                    for (int j = 0; j < 4; j += 2) {
                        if (ch[j] != exclude[k] && ch[j + 1] != exclude[k]) continue;
                        int n = j;
                        ch[n] = ch[n] + 1;
                        int n2 = j + 1;
                        ch[n2] = ch[n2] - 1;
                        check = true;
                    }
                }
            }
            for (int j = 0; j < 4; ++j) {
                asc[4 * j + i] = (byte)ch[j];
            }
        }
        String resul = new String(asc, 15, 1);
        return resul.concat(new String(asc, 0, 15));
    }
}

