/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCard;
import org.junit.Assert;
import org.junit.Test;

public class HeaderCardTester {
    @Test
    public void test1() throws Exception {
        HeaderCard p = new HeaderCard("SIMPLE  =                     T");
        Assert.assertEquals((String)"t1", (Object)"SIMPLE", (Object)p.getKey());
        Assert.assertEquals((String)"t2", (Object)"T", (Object)p.getValue());
        Assert.assertNull((String)"t3", (Object)p.getComment());
        p = new HeaderCard("VALUE   =                   123");
        Assert.assertEquals((String)"t4", (Object)"VALUE", (Object)p.getKey());
        Assert.assertEquals((String)"t5", (Object)"123", (Object)p.getValue());
        Assert.assertNull((String)"t3", (Object)p.getComment());
        p = new HeaderCard("VALUE   =    1.23698789798798E23 / Comment ");
        Assert.assertEquals((String)"t6", (Object)"VALUE", (Object)p.getKey());
        Assert.assertEquals((String)"t7", (Object)"1.23698789798798E23", (Object)p.getValue());
        Assert.assertEquals((String)"t8", (Object)"Comment", (Object)p.getComment());
        String lng = "111111111111111111111111111111111111111111111111111111111111111111111111";
        p = new HeaderCard("COMMENT " + lng);
        Assert.assertEquals((String)"t9", (Object)"COMMENT", (Object)p.getKey());
        Assert.assertNull((String)"t10", (Object)p.getValue());
        Assert.assertEquals((String)"t11", (Object)lng, (Object)p.getComment());
        boolean thrown = false;
        try {
            p = new HeaderCard("VALUE   = '   ");
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"t12", (Object)true, (Object)thrown);
        p = new HeaderCard("COMMENT " + lng + lng);
        Assert.assertEquals((String)"t13", (Object)lng, (Object)p.getComment());
        HeaderCard z = new HeaderCard("TTTT", 1.2345678912345679E101, "a comment");
        Assert.assertTrue((String)"t14", (z.toString().indexOf("E") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test3() throws Exception {
        HeaderCard p = new HeaderCard("KEY", "VALUE", "COMMENT");
        Assert.assertEquals((String)"x1", (Object)"KEY     = 'VALUE   '           / COMMENT                                        ", (Object)p.toString());
        p = new HeaderCard("KEY", 123, "COMMENT");
        Assert.assertEquals((String)"x2", (Object)"KEY     =                  123 / COMMENT                                        ", (Object)p.toString());
        p = new HeaderCard("KEY", 1.23, "COMMENT");
        Assert.assertEquals((String)"x3", (Object)"KEY     =                 1.23 / COMMENT                                        ", (Object)p.toString());
        p = new HeaderCard("KEY", true, "COMMENT");
        Assert.assertEquals((String)"x4", (Object)"KEY     =                    T / COMMENT                                        ", (Object)p.toString());
        boolean thrown = false;
        try {
            p = new HeaderCard("LONGKEYWORD", 123, "COMMENT");
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"x5", (Object)true, (Object)thrown);
        thrown = false;
        String lng = "00000000001111111111222222222233333333334444444444555555555566666666667777777777";
        try {
            p = new HeaderCard("KEY", lng, "COMMENT");
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"x6", (Object)true, (Object)thrown);
        p = new HeaderCard("STRING", "VALUE", null);
        Assert.assertEquals((String)"x6", (Object)"VALUE", (Object)p.getValue());
        p = new HeaderCard("STRING", "VALUE ", null);
        Assert.assertEquals((String)"x7", (Object)"VALUE", (Object)p.getValue());
        p = new HeaderCard("STRING", " VALUE", null);
        Assert.assertEquals((String)"x8", (Object)" VALUE", (Object)p.getValue());
        p = new HeaderCard("STRING", " VALUE ", null);
        Assert.assertEquals((String)"x9", (Object)" VALUE", (Object)p.getValue());
        p = new HeaderCard("QUOTES", "ABC'DEF", null);
        Assert.assertEquals((String)"x10", (Object)"ABC'DEF", (Object)p.getValue());
        Assert.assertEquals((String)"x10b", (Object)(p.toString().indexOf("''") > 0 ? 1 : 0), (Object)true);
        p = new HeaderCard("QUOTES", "ABC''DEF", null);
        Assert.assertEquals((String)"x11", (Object)"ABC''DEF", (Object)p.getValue());
        Assert.assertEquals((String)"x10b", (Object)(p.toString().indexOf("''''") > 0 ? 1 : 0), (Object)true);
    }

    @Test
    public void testHierarch() throws Exception {
        HeaderCard hc;
        String key = "HIERARCH.TEST1.TEST2.INT";
        boolean thrown = false;
        try {
            hc = new HeaderCard(key, 123, "Comment");
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"h1", (Object)true, (Object)thrown);
        String card = "HIERARCH TEST1 TEST2 INT=           123 / Comment                               ";
        hc = new HeaderCard(card);
        Assert.assertEquals((String)"h2", (Object)"HIERARCH", (Object)hc.getKey());
        Assert.assertNull((String)"h3", (Object)hc.getValue());
        Assert.assertEquals((String)"h4", (Object)"TEST1 TEST2 INT=           123 / Comment", (Object)hc.getComment());
        FitsFactory.setUseHierarch(true);
        hc = new HeaderCard(key, 123, "Comment");
        Assert.assertEquals((String)"h5", (Object)key, (Object)hc.getKey());
        Assert.assertEquals((String)"h6", (Object)"123", (Object)hc.getValue());
        Assert.assertEquals((String)"h7", (Object)"Comment", (Object)hc.getComment());
        hc = new HeaderCard(card);
        Assert.assertEquals((String)"h8", (Object)key, (Object)hc.getKey());
        Assert.assertEquals((String)"h9", (Object)"123", (Object)hc.getValue());
        Assert.assertEquals((String)"h10", (Object)"Comment", (Object)hc.getComment());
    }

    @Test
    public void testLongDoubles() throws Exception {
        HeaderCard hc = new HeaderCard("TEST", -1.2345678901234568E-123, "dummy");
        String val = hc.getValue();
        Assert.assertEquals((String)"tld1", (Object)val.length(), (Object)20);
    }
}

