/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import java.util.HashMap;
import skyview.geometry.Distorter;
import skyview.geometry.Projecter;
import skyview.geometry.Rotater;
import skyview.geometry.TransformationException;
import skyview.util.Utilities;

public class Projection {
    private double[] refProj = new double[]{0.0, 1.5707963267948966};
    private boolean refSet = false;
    private boolean fixedProjection = false;
    private Rotater rotation;
    private Projecter proj;
    private Distorter dist = null;
    private static HashMap<String, double[]> fixedPoints = new HashMap();

    public void setReference(double lon, double lat) {
        if (lon != this.refProj[0] || lat != this.refProj[1]) {
            Rotater r1 = new Rotater("ZY", -this.refProj[0], this.refProj[1], 0.0);
            Rotater r2 = new Rotater("ZY", -lon, lat, 0.0);
            this.setRotater(r1.add(r2.inverse()));
            this.refProj[0] = lon;
            this.refProj[1] = lat;
        }
        this.refSet = true;
    }

    public static double[] fixedPoint(String proj) {
        double[] ref = fixedPoints.get(proj);
        return ref;
    }

    public Rotater getRotater() {
        return this.rotation;
    }

    public void setRotater(Rotater rot) {
        this.rotation = rot;
    }

    public Projecter getProjecter() {
        return this.proj;
    }

    public Distorter getDistorter() {
        return this.dist;
    }

    protected void setDistorter(Distorter dist) {
        this.dist = dist;
    }

    protected double[] specialReference() {
        return null;
    }

    public Projection(String type) throws TransformationException {
        this.refProj = Projection.fixedPoint(type);
        if (this.refProj == null) {
            throw new TransformationException("Invalid non-parametrized projection:" + type);
        }
        String projClass = "skyview.geometry.projecter." + type + "Projecter";
        this.fixedProjection = true;
        this.proj = (Projecter)Utilities.newInstance(type, "skyview.geometry.projecter");
        if (this.proj == null) {
            throw new TransformationException("Error creating non-parametrized projection:" + type);
        }
        this.rotation = null;
    }

    public boolean isFixedProjection() {
        return this.fixedProjection;
    }

    public double[] getReferencePoint() {
        return this.refProj;
    }

    public Projection(String type, double[] reference) throws TransformationException {
        String projClass = "skyview.geometry.projecter." + type + "Projecter";
        this.proj = (Projecter)Utilities.newInstance(type, "skyview.geometry.projecter");
        if (this.proj == null) {
            throw new TransformationException("Cannot create parametrized projection:" + type + "\n");
        }
        this.rotation = new Rotater("ZYZ", reference[0], -reference[1] + 1.5707963267948966, 1.5707963267948966);
        if (this.specialReference() != null) {
            double[] spec = this.specialReference();
            this.rotation = this.rotation.add(new Rotater("ZYZ", spec[0], spec[1], spec[2]));
        }
    }

    static {
        fixedPoints.put("Car", new double[]{0.0, 0.0});
        fixedPoints.put("Ait", new double[]{0.0, 0.0});
        fixedPoints.put("Csc", new double[]{0.0, 0.0});
        fixedPoints.put("Sfl", new double[]{0.0, 0.0});
        fixedPoints.put("Toa", new double[]{0.0, 90.0});
        fixedPoints.put("Hpx", new double[]{0.0, 135.0});
        fixedPoints.put("Tea", new double[]{0.0, 90.0});
    }
}

