/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.csys;

import skyview.Component;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Rotater;

public class Julian
extends CoordinateSystem
implements Component {
    private double epoch;

    @Override
    public String getName() {
        return "J" + this.epoch;
    }

    @Override
    public String getDescription() {
        return "A Julian (FK5-based) equatorial coordinate system with epoch of the equinox of " + this.epoch;
    }

    public Julian(double epoch) {
        this.epoch = epoch;
    }

    @Override
    public Rotater getRotater() {
        if (this.epoch == 2000.0) {
            return null;
        }
        return this.precession();
    }

    public Rotater precession() {
        double sec2rad = 4.84813681109536E-6;
        double t = (this.epoch - 2000.0) / 100.0;
        double tas2r = t * sec2rad;
        double w = 2306.2181;
        double zeta = (w + (0.30188 + 0.017998 * t) * t) * tas2r;
        double z = (w + (1.09468 + 0.018203 * t) * t) * tas2r;
        double theta = (2004.3109 + (-0.42665 - 0.041833 * t) * t) * tas2r;
        return new Rotater("ZYZ", -zeta, theta, -z);
    }
}

